/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator.wan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.client.internal.locator.wan.LocatorHelper;
import org.apache.geode.cache.client.internal.locator.wan.LocatorJoinMessage;
import org.apache.geode.cache.client.internal.locator.wan.LocatorMembershipListener;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorJoinResponse;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorPingRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorPingResponse;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorRequest;
import org.apache.geode.cache.client.internal.locator.wan.RemoteLocatorResponse;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.executors.LoggingThreadFactory;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LocatorMembershipListenerImpl
implements LocatorMembershipListener {
    private static final Logger logger = LogService.getLogger();
    static final int LOCATOR_DISTRIBUTION_RETRY_ATTEMPTS = 3;
    private static final String LOCATORS_DISTRIBUTOR_THREAD_NAME = "LocatorsDistributorThread";
    private static final String LISTENER_FAILURE_MESSAGE = "Locator Membership listener could not exchange locator information {}:{} with {}:{} after {} retry attempts";
    private static final String LISTENER_FINAL_FAILURE_MESSAGE = "Locator Membership listener permanently failed to exchange locator information {}:{} with {}:{} after {} retry attempts";
    private int port;
    private DistributionConfig config;
    private final TcpClient tcpClient;
    private final ConcurrentMap<Integer, Set<String>> allServerLocatorsInfo = new ConcurrentHashMap<Integer, Set<String>>();
    private final ConcurrentMap<Integer, Set<DistributionLocatorId>> allLocatorsInfo = new ConcurrentHashMap<Integer, Set<DistributionLocatorId>>();

    LocatorMembershipListenerImpl() {
        this.tcpClient = new TcpClient(SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR), InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), TcpSocketFactory.DEFAULT);
    }

    LocatorMembershipListenerImpl(TcpClient tcpClient) {
        this.tcpClient = tcpClient;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void setConfig(DistributionConfig config) {
        this.config = config;
    }

    Thread buildLocatorsDistributorThread(DistributionLocatorId localLocatorId, Map<Integer, Set<DistributionLocatorId>> remoteLocators, DistributionLocatorId joiningLocator, int joiningLocatorDistributedSystemId) {
        DistributeLocatorsRunnable distributeLocatorsRunnable = new DistributeLocatorsRunnable(this.config.getMemberTimeout(), this.tcpClient, localLocatorId, remoteLocators, joiningLocator, joiningLocatorDistributedSystemId);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(LOCATORS_DISTRIBUTOR_THREAD_NAME, true);
        return threadFactory.newThread(distributeLocatorsRunnable);
    }

    @Override
    public void locatorJoined(int distributedSystemId, DistributionLocatorId locator, DistributionLocatorId sourceLocator) {
        String localLocator = this.config.getStartLocator();
        DistributionLocatorId localLocatorId = localLocator.equals("") ? new DistributionLocatorId(this.port, this.config.getBindAddress()) : new DistributionLocatorId(localLocator);
        ConcurrentMap<Integer, Set<DistributionLocatorId>> remoteLocators = this.getAllLocatorsInfo();
        HashMap<Integer, Set<DistributionLocatorId>> localCopy = new HashMap<Integer, Set<DistributionLocatorId>>();
        for (Map.Entry entry : remoteLocators.entrySet()) {
            CopyOnWriteHashSet copyOnWriteHashSet = new CopyOnWriteHashSet((Set)entry.getValue());
            localCopy.put((Integer)entry.getKey(), copyOnWriteHashSet);
        }
        List<DistributionLocatorId> ignoreList = Arrays.asList(locator, localLocatorId, sourceLocator);
        for (Map.Entry entry : localCopy.entrySet()) {
            for (DistributionLocatorId removeLocId : ignoreList) {
                ((Set)entry.getValue()).remove(removeLocId);
            }
        }
        Thread thread = this.buildLocatorsDistributorThread(localLocatorId, localCopy, locator, distributedSystemId);
        thread.start();
    }

    @Override
    public Object handleRequest(Object request) {
        Object response = null;
        if (request instanceof RemoteLocatorJoinRequest) {
            response = this.updateAllLocatorInfo((RemoteLocatorJoinRequest)request);
        } else if (request instanceof LocatorJoinMessage) {
            response = this.informAboutRemoteLocators((LocatorJoinMessage)request);
        } else if (request instanceof RemoteLocatorPingRequest) {
            response = this.getPingResponse((RemoteLocatorPingRequest)request);
        } else if (request instanceof RemoteLocatorRequest) {
            response = this.getRemoteLocators((RemoteLocatorRequest)request);
        }
        return response;
    }

    private synchronized Object updateAllLocatorInfo(RemoteLocatorJoinRequest request) {
        int distributedSystemId = request.getDistributedSystemId();
        DistributionLocatorId locator = request.getLocator();
        LocatorHelper.addLocator(distributedSystemId, locator, this, null);
        return new RemoteLocatorJoinResponse(this.getAllLocatorsInfo());
    }

    private Object getPingResponse(RemoteLocatorPingRequest request) {
        return new RemoteLocatorPingResponse();
    }

    private Object informAboutRemoteLocators(LocatorJoinMessage request) {
        int distributedSystemId = request.getDistributedSystemId();
        DistributionLocatorId locator = request.getLocator();
        DistributionLocatorId sourceLocatorId = request.getSourceLocator();
        LocatorHelper.addLocator(distributedSystemId, locator, this, sourceLocatorId);
        return null;
    }

    private Object getRemoteLocators(RemoteLocatorRequest request) {
        int dsId = request.getDsId();
        Set<String> locators = this.getRemoteLocatorInfo(dsId);
        return new RemoteLocatorResponse(locators);
    }

    @Override
    public Set<String> getRemoteLocatorInfo(int dsId) {
        return (Set)this.allServerLocatorsInfo.get(dsId);
    }

    @Override
    public ConcurrentMap<Integer, Set<DistributionLocatorId>> getAllLocatorsInfo() {
        return this.allLocatorsInfo;
    }

    @Override
    public ConcurrentMap<Integer, Set<String>> getAllServerLocatorsInfo() {
        return this.allServerLocatorsInfo;
    }

    @Override
    public void clearLocatorInfo() {
        this.allLocatorsInfo.clear();
        this.allServerLocatorsInfo.clear();
    }

    private static class DistributeLocatorsRunnable
    implements Runnable {
        private final int memberTimeout;
        private final TcpClient tcpClient;
        private final DistributionLocatorId localLocatorId;
        private final Map<Integer, Set<DistributionLocatorId>> remoteLocators;
        private final DistributionLocatorId joiningLocator;
        private final int joiningLocatorDistributedSystemId;

        DistributeLocatorsRunnable(int memberTimeout, TcpClient tcpClient, DistributionLocatorId localLocatorId, Map<Integer, Set<DistributionLocatorId>> remoteLocators, DistributionLocatorId joiningLocator, int joiningLocatorDistributedSystemId) {
            this.memberTimeout = memberTimeout;
            this.tcpClient = tcpClient;
            this.localLocatorId = localLocatorId;
            this.remoteLocators = remoteLocators;
            this.joiningLocator = joiningLocator;
            this.joiningLocatorDistributedSystemId = joiningLocatorDistributedSystemId;
        }

        void sendMessage(DistributionLocatorId targetLocator, LocatorJoinMessage locatorJoinMessage, Map<DistributionLocatorId, Set<LocatorJoinMessage>> failedMessages) {
            DistributionLocatorId advertisedLocator = locatorJoinMessage.getLocator();
            try {
                this.tcpClient.requestToServer(targetLocator.getHost(), locatorJoinMessage, this.memberTimeout, false);
            }
            catch (Exception exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug(LocatorMembershipListenerImpl.LISTENER_FAILURE_MESSAGE, new Object[]{advertisedLocator.getHostName(), advertisedLocator.getPort(), targetLocator.getHostName(), targetLocator.getPort(), 1, exception});
                }
                if (!failedMessages.containsKey(targetLocator)) {
                    failedMessages.put(targetLocator, new HashSet());
                }
                failedMessages.get(targetLocator).add(locatorJoinMessage);
            }
        }

        boolean retryMessage(DistributionLocatorId targetLocator, LocatorJoinMessage locatorJoinMessage, int retryAttempt) {
            DistributionLocatorId advertisedLocator = locatorJoinMessage.getLocator();
            try {
                this.tcpClient.requestToServer(targetLocator.getHost(), locatorJoinMessage, this.memberTimeout, false);
                return true;
            }
            catch (Exception exception) {
                if (retryAttempt == 3) {
                    logger.warn(LocatorMembershipListenerImpl.LISTENER_FINAL_FAILURE_MESSAGE, new Object[]{advertisedLocator.getHostName(), advertisedLocator.getPort(), targetLocator.getHostName(), targetLocator.getPort(), retryAttempt, exception});
                } else if (logger.isDebugEnabled()) {
                    logger.debug(LocatorMembershipListenerImpl.LISTENER_FAILURE_MESSAGE, new Object[]{advertisedLocator.getHostName(), advertisedLocator.getPort(), targetLocator.getHostName(), targetLocator.getPort(), retryAttempt, exception});
                }
                return false;
            }
        }

        @Override
        public void run() {
            HashMap<DistributionLocatorId, Set<LocatorJoinMessage>> failedMessages = new HashMap<DistributionLocatorId, Set<LocatorJoinMessage>>();
            for (Map.Entry<Integer, Set<DistributionLocatorId>> entry : this.remoteLocators.entrySet()) {
                for (DistributionLocatorId remoteLocator : entry.getValue()) {
                    LocatorJoinMessage advertiseNewLocatorMessage = new LocatorJoinMessage(this.joiningLocatorDistributedSystemId, this.joiningLocator, this.localLocatorId, "");
                    this.sendMessage(remoteLocator, advertiseNewLocatorMessage, failedMessages);
                    LocatorJoinMessage advertiseKnownLocatorMessage = new LocatorJoinMessage(entry.getKey(), remoteLocator, this.localLocatorId, "");
                    this.sendMessage(this.joiningLocator, advertiseKnownLocatorMessage, failedMessages);
                }
            }
            if (!failedMessages.isEmpty()) {
                for (int attempt = 1; attempt <= 3; ++attempt) {
                    for (Map.Entry entry : failedMessages.entrySet()) {
                        DistributionLocatorId targetLocator = (DistributionLocatorId)entry.getKey();
                        Set joinMessages = (Set)entry.getValue();
                        Iterator iterator = joinMessages.iterator();
                        while (iterator.hasNext()) {
                            LocatorJoinMessage locatorJoinMessage = (LocatorJoinMessage)iterator.next();
                            if (this.retryMessage(targetLocator, locatorJoinMessage, attempt)) {
                                iterator.remove();
                                continue;
                            }
                            try {
                                Thread.sleep(this.memberTimeout);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                logger.warn("Locator Membership listener permanently failed to exchange locator information due to interruption.");
                                return;
                            }
                        }
                    }
                }
            }
        }
    }
}

