/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.Future;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.executors.LoggingThreadFactory;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.netty.ByteToCommandDecoder;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.PubSub;
import org.apache.geode.redis.internal.statistics.RedisStats;
import org.apache.logging.log4j.Logger;

public class NettyRedisServer {
    private static final int RANDOM_PORT_INDICATOR = 0;
    private static final Logger logger = LogService.getLogger();
    private static final int CONNECT_TIMEOUT_MILLIS = 1000;
    private final Supplier<DistributionConfig> configSupplier;
    private final RegionProvider regionProvider;
    private final PubSub pubsub;
    private final Supplier<Boolean> allowUnsupportedSupplier;
    private final Runnable shutdownInvoker;
    private final RedisStats redisStats;
    private final ExecutorService backgroundExecutor;
    private final EventLoopGroup selectorGroup;
    private final EventLoopGroup workerGroup;
    private final EventLoopGroup subscriberGroup;
    private final InetAddress bindAddress;
    private final Channel serverChannel;
    private final int serverPort;

    public NettyRedisServer(Supplier<DistributionConfig> configSupplier, RegionProvider regionProvider, PubSub pubsub, Supplier<Boolean> allowUnsupportedSupplier, Runnable shutdownInvoker, int port, String requestedAddress, RedisStats redisStats, ExecutorService backgroundExecutor) {
        this.configSupplier = configSupplier;
        this.regionProvider = regionProvider;
        this.pubsub = pubsub;
        this.allowUnsupportedSupplier = allowUnsupportedSupplier;
        this.shutdownInvoker = shutdownInvoker;
        this.redisStats = redisStats;
        this.backgroundExecutor = backgroundExecutor;
        if (port < 0) {
            throw new IllegalArgumentException("The compatible-with-redis-port cannot be less than 0");
        }
        this.selectorGroup = NettyRedisServer.createEventLoopGroup("Selector", true, 1);
        this.workerGroup = NettyRedisServer.createEventLoopGroup("Worker", true, 0);
        this.subscriberGroup = NettyRedisServer.createEventLoopGroup("Subscriber", true, 0);
        try {
            this.bindAddress = NettyRedisServer.getBindAddress(requestedAddress);
            this.serverChannel = this.createChannel(port);
        }
        catch (ManagementException e) {
            this.stop();
            throw e;
        }
        this.serverPort = this.getActualPort();
        this.logStartupMessage();
    }

    private Channel createChannel(int port) {
        ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.selectorGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(this.createChannelInitializer()).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)this.getBufferSize())).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        return this.createBoundChannel(serverBootstrap, port);
    }

    public void stop() {
        ChannelFuture closeFuture = null;
        if (this.serverChannel != null) {
            closeFuture = this.serverChannel.closeFuture();
        }
        this.workerGroup.shutdownGracefully();
        this.subscriberGroup.shutdownGracefully();
        Future bossFuture = this.selectorGroup.shutdownGracefully();
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
        bossFuture.syncUninterruptibly();
        if (closeFuture != null) {
            closeFuture.syncUninterruptibly();
        }
    }

    public int getPort() {
        return this.serverPort;
    }

    private ChannelInitializer<SocketChannel> createChannelInitializer() {
        String redisPassword = this.configSupplier.get().getRedisPassword();
        final byte[] redisPasswordBytes = StringUtils.isBlank((CharSequence)redisPassword) ? null : Coder.stringToBytes(redisPassword);
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel socketChannel) {
                if (logger.isDebugEnabled()) {
                    logger.debug("GeodeRedisServer-Connection established with " + socketChannel.remoteAddress());
                }
                ChannelPipeline pipeline = socketChannel.pipeline();
                NettyRedisServer.this.addSSLIfEnabled(socketChannel, pipeline);
                pipeline.addLast(ByteToCommandDecoder.class.getSimpleName(), (ChannelHandler)new ByteToCommandDecoder(NettyRedisServer.this.redisStats));
                pipeline.addLast(new ChannelHandler[]{new WriteTimeoutHandler(10)});
                pipeline.addLast(ExecutionHandlerContext.class.getSimpleName(), (ChannelHandler)new ExecutionHandlerContext((Channel)socketChannel, NettyRedisServer.this.regionProvider, NettyRedisServer.this.pubsub, NettyRedisServer.this.allowUnsupportedSupplier, NettyRedisServer.this.shutdownInvoker, NettyRedisServer.this.redisStats, NettyRedisServer.this.backgroundExecutor, NettyRedisServer.this.subscriberGroup, redisPasswordBytes, NettyRedisServer.this.getPort()));
            }
        };
    }

    private void addSSLIfEnabled(SocketChannel ch, ChannelPipeline p) {
        SslContext sslContext;
        SSLConfig sslConfigForComponent = SSLConfigurationFactory.getSSLConfigForComponent((DistributionConfig)this.configSupplier.get(), (SecurableCommunicationChannel)SecurableCommunicationChannel.SERVER);
        if (!sslConfigForComponent.isEnabled()) {
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(sslConfigForComponent.getKeystore());){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(fileInputStream, sslConfigForComponent.getKeystorePassword().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, sslConfigForComponent.getKeystorePassword().toCharArray());
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer(kmf);
            sslContext = sslContextBuilder.build();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
    }

    private Channel createBoundChannel(ServerBootstrap serverBootstrap, int requestedPort) {
        int port = requestedPort == 0 ? 0 : requestedPort;
        ChannelFuture channelFuture = serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.bindAddress, port));
        try {
            channelFuture.syncUninterruptibly();
        }
        catch (Exception ex) {
            throw new ManagementException("Could not start server compatible with Redis using bind address: " + this.bindAddress + " and port: " + port + ". Please make sure nothing else is running on this address/port combination.", (Throwable)ex);
        }
        return channelFuture.channel();
    }

    private int getActualPort() {
        return ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
    }

    private void logStartupMessage() {
        String logMessage = "GeodeRedisServer started {" + this.bindAddress + ":" + this.serverPort + "}";
        logger.info(logMessage);
    }

    private int getBufferSize() {
        return this.configSupplier.get().getSocketBufferSize();
    }

    private static InetAddress getBindAddress(String requestedAddress) {
        if (requestedAddress == null || requestedAddress.isEmpty() || requestedAddress.equals(LocalHostUtil.getAnyLocalAddress().getHostAddress())) {
            return LocalHostUtil.getAnyLocalAddress();
        }
        try {
            return InetAddress.getByName(requestedAddress);
        }
        catch (UnknownHostException e) {
            throw new ManagementException("Could not start server compatible with Redis using bind address: '" + requestedAddress + "'. Please make sure that this is a valid address for this host.", (Throwable)e);
        }
    }

    private static EventLoopGroup createEventLoopGroup(String name, boolean isDaemon, int nThreads) {
        String fullName = "GeodeRedisServer-" + name + "Thread-";
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(fullName, isDaemon);
        return new NioEventLoopGroup(nThreads, (ThreadFactory)threadFactory);
    }
}

