/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class BitOpExecutor
extends StringExecutor {
    protected static final String ERROR_BITOP_NOT = "BITOP NOT must be called with a single source key";

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        String operation = command.getStringKey().toUpperCase();
        if (!(operation.equals("AND") || operation.equals("OR") || operation.equals("XOR") || operation.equals("NOT"))) {
            return RedisResponse.error("syntax error");
        }
        RedisKey destKey = new RedisKey(commandElems.get(2));
        ArrayList<RedisKey> values = new ArrayList<RedisKey>();
        for (int i = 3; i < commandElems.size(); ++i) {
            RedisKey key = new RedisKey(commandElems.get(i));
            values.add(key);
        }
        if (operation.equals("NOT") && values.size() != 1) {
            return RedisResponse.error(ERROR_BITOP_NOT);
        }
        int result = this.getRedisStringCommands(context).bitop(operation, destKey, values);
        return RedisResponse.integer(result);
    }
}

