/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.Collection;
import java.util.List;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.set.RedisSetCommands;
import org.apache.geode.redis.internal.executor.set.SetExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SRandMemberExecutor
extends SetExecutor {
    private static final String ERROR_NOT_NUMERIC = "The count provided must be numeric";

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey key = command.getKey();
        boolean countSpecified = false;
        int count = 1;
        if (commandElems.size() > 2) {
            try {
                count = Coder.bytesToInt(commandElems.get(2));
                countSpecified = true;
            }
            catch (NumberFormatException e) {
                return RedisResponse.error(ERROR_NOT_NUMERIC);
            }
        }
        if (count == 0) {
            return RedisResponse.emptyArray();
        }
        RedisSetCommands redisSetCommands = this.createRedisSetCommands(context);
        Collection<ByteArrayWrapper> results = redisSetCommands.srandmember(key, count);
        if (countSpecified) {
            return RedisResponse.array(results);
        }
        if (results.isEmpty()) {
            return RedisResponse.nil();
        }
        return RedisResponse.bulkString(results.iterator().next());
    }
}

