/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.RedisCommandType;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisCommandsFunctionInvoker;
import org.apache.geode.redis.internal.executor.set.RedisSetCommands;

public class RedisSetCommandsFunctionInvoker
extends RedisCommandsFunctionInvoker
implements RedisSetCommands {
    public RedisSetCommandsFunctionInvoker(Region<RedisKey, RedisData> region) {
        super(region);
    }

    @Override
    public long sadd(RedisKey key, ArrayList<ByteArrayWrapper> membersToAdd) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SADD, membersToAdd});
    }

    @Override
    public long srem(RedisKey key, ArrayList<ByteArrayWrapper> membersToRemove) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SREM, membersToRemove});
    }

    @Override
    public Set<ByteArrayWrapper> smembers(RedisKey key) {
        return (Set)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SMEMBERS});
    }

    @Override
    public Set<ByteArrayWrapper> internalsmembers(RedisKey key) {
        return (Set)this.invokeCommandFunction(key, new Object[]{RedisCommandType.INTERNALSMEMBERS});
    }

    @Override
    public int scard(RedisKey key) {
        return (Integer)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SCARD});
    }

    @Override
    public boolean sismember(RedisKey key, ByteArrayWrapper member) {
        return (Boolean)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SISMEMBER, member});
    }

    @Override
    public Collection<ByteArrayWrapper> srandmember(RedisKey key, int count) {
        return (Collection)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SRANDMEMBER, count});
    }

    @Override
    public Collection<ByteArrayWrapper> spop(RedisKey key, int popCount) {
        return (Collection)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SPOP, popCount});
    }

    @Override
    public Pair<BigInteger, List<Object>> sscan(RedisKey key, Pattern matchPattern, int count, BigInteger cursor) {
        return (Pair)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SSCAN, matchPattern, count, cursor});
    }

    @Override
    public int sunionstore(RedisKey destination, ArrayList<RedisKey> setKeys) {
        return (Integer)this.invokeCommandFunction(destination, new Object[]{RedisCommandType.SUNIONSTORE, setKeys});
    }

    @Override
    public int sinterstore(RedisKey destination, ArrayList<RedisKey> setKeys) {
        return (Integer)this.invokeCommandFunction(destination, new Object[]{RedisCommandType.SINTERSTORE, setKeys});
    }

    @Override
    public int sdiffstore(RedisKey destination, ArrayList<RedisKey> setKeys) {
        return (Integer)this.invokeCommandFunction(destination, new Object[]{RedisCommandType.SDIFFSTORE, setKeys});
    }
}

