/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.Subscription;

public class UnsubscribeExecutor
extends AbstractExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        context.eventLoopReady();
        List<byte[]> channelNames = this.extractChannelNames(command);
        if (channelNames.isEmpty()) {
            channelNames = context.getPubSub().findSubscriptionNames(context.getClient(), Subscription.Type.CHANNEL);
        }
        Collection<Collection<?>> response = this.unsubscribe(context, channelNames);
        return RedisResponse.flattenedArray(response);
    }

    private List<byte[]> extractChannelNames(Command command) {
        return command.getProcessedCommandWrappers().stream().skip(1L).map(ByteArrayWrapper::toBytes).collect(Collectors.toList());
    }

    private Collection<Collection<?>> unsubscribe(ExecutionHandlerContext context, List<byte[]> channelNames) {
        ArrayList response = new ArrayList();
        if (channelNames.isEmpty()) {
            response.add(this.createItem(null, 0L));
        } else {
            for (byte[] channel : channelNames) {
                long subscriptionCount = context.getPubSub().unsubscribe(channel, context.getClient());
                response.add(this.createItem(channel, subscriptionCount));
            }
        }
        return response;
    }

    private ArrayList<Object> createItem(byte[] channelName, long subscriptionCount) {
        ArrayList<Object> oneItem = new ArrayList<Object>();
        oneItem.add("unsubscribe");
        oneItem.add(channelName);
        oneItem.add(subscriptionCount);
        return oneItem;
    }
}

