/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisDataType;
import org.apache.geode.redis.internal.data.RedisDataTypeMismatchException;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.hash.RedisHashCommandsFunctionInvoker;
import org.apache.geode.redis.internal.executor.key.AbstractScanExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class HScanExecutor
extends AbstractScanExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        Pattern matchPattern;
        int cursor;
        UUID CLIENT_ID = context.getClientUUID();
        List<byte[]> commandElems = command.getProcessedCommand();
        String cursorString = Coder.bytesToString(commandElems.get(2));
        String globPattern = null;
        int count = 10;
        try {
            cursor = Integer.parseInt(cursorString);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error("invalid cursor");
        }
        if (cursor != context.getHscanCursor()) {
            cursor = 0;
        }
        RedisKey key = command.getKey();
        if (!this.getDataRegion(context).containsKey((Object)key)) {
            context.getRedisStats().incKeyspaceMisses();
            return RedisResponse.emptyScan();
        }
        if (((RedisData)this.getDataRegion(context).get((Object)key)).getType() != RedisDataType.REDIS_HASH) {
            throw new RedisDataTypeMismatchException("Operation against a key holding the wrong kind of value");
        }
        command.getCommandType().checkDeferredParameters(command, context);
        for (int i = 3; i < commandElems.size(); i += 2) {
            byte[] commandElemBytes = commandElems.get(i);
            String keyword = Coder.bytesToString(commandElemBytes);
            if (keyword.equalsIgnoreCase("MATCH")) {
                commandElemBytes = commandElems.get(i + 1);
                globPattern = Coder.bytesToString(commandElemBytes);
                continue;
            }
            if (keyword.equalsIgnoreCase("COUNT")) {
                commandElemBytes = commandElems.get(i + 1);
                try {
                    count = Coder.bytesToInt(commandElemBytes);
                }
                catch (NumberFormatException e) {
                    return RedisResponse.error("value is not an integer or out of range");
                }
                if (count >= 1) continue;
                return RedisResponse.error("syntax error");
            }
            return RedisResponse.error("syntax error");
        }
        try {
            matchPattern = this.convertGlobToRegex(globPattern);
        }
        catch (PatternSyntaxException e) {
            LogService.getLogger().warn("Could not compile the pattern: '{}' due to the following exception: '{}'. HSCAN will return an empty list.", globPattern, (Object)e.getMessage());
            return RedisResponse.emptyScan();
        }
        RedisHashCommandsFunctionInvoker redisHashCommands = new RedisHashCommandsFunctionInvoker(context.getRegionProvider().getDataRegion());
        Pair<Integer, List<Object>> scanResult = redisHashCommands.hscan(key, matchPattern, count, cursor, CLIENT_ID);
        context.setHscanCursor((Integer)scanResult.getLeft());
        return RedisResponse.scan(new BigInteger(String.valueOf(scanResult.getLeft())), (List)scanResult.getRight());
    }
}

