/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.NullRedisDataStructures;
import org.apache.geode.redis.internal.data.RedisDataCommandsFunctionExecutor;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.data.RedisSet;
import org.apache.geode.redis.internal.executor.set.RedisSetCommands;

public class RedisSetCommandsFunctionExecutor
extends RedisDataCommandsFunctionExecutor
implements RedisSetCommands {
    public RedisSetCommandsFunctionExecutor(CommandHelper helper) {
        super(helper);
    }

    private RedisSet getRedisSet(RedisKey key, boolean updateStats) {
        return this.helper.getRedisSet(key, updateStats);
    }

    @Override
    public long sadd(RedisKey key, ArrayList<ByteArrayWrapper> membersToAdd) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, false).sadd(membersToAdd, this.getRegion(), key));
    }

    @Override
    public int sunionstore(RedisKey destination, ArrayList<RedisKey> setKeys) {
        return NullRedisDataStructures.NULL_REDIS_SET.sunionstore(this.helper, destination, setKeys);
    }

    @Override
    public int sinterstore(RedisKey destination, ArrayList<RedisKey> setKeys) {
        return NullRedisDataStructures.NULL_REDIS_SET.sinterstore(this.helper, destination, setKeys);
    }

    @Override
    public int sdiffstore(RedisKey destination, ArrayList<RedisKey> setKeys) {
        return NullRedisDataStructures.NULL_REDIS_SET.sdiffstore(this.helper, destination, setKeys);
    }

    @Override
    public long srem(RedisKey key, ArrayList<ByteArrayWrapper> membersToRemove) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, false).srem(membersToRemove, this.getRegion(), key));
    }

    @Override
    public Set<ByteArrayWrapper> smembers(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, true).smembers());
    }

    @Override
    public Set<ByteArrayWrapper> internalsmembers(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, false).smembers());
    }

    @Override
    public int scard(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, true).scard());
    }

    @Override
    public boolean sismember(RedisKey key, ByteArrayWrapper member) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, true).sismember(member));
    }

    @Override
    public Collection<ByteArrayWrapper> srandmember(RedisKey key, int count) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, true).srandmember(count));
    }

    @Override
    public Collection<ByteArrayWrapper> spop(RedisKey key, int popCount) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, false).spop(this.getRegion(), key, popCount));
    }

    @Override
    public Pair<BigInteger, List<Object>> sscan(RedisKey key, Pattern matchPattern, int count, BigInteger cursor) {
        return this.stripedExecute(key, () -> this.getRedisSet(key, true).sscan(matchPattern, count, cursor));
    }
}

