/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.ParameterRequirements;

import org.apache.geode.redis.internal.ParameterRequirements.ParameterRequirements;
import org.apache.geode.redis.internal.ParameterRequirements.RedisParametersMismatchException;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class OddParameterRequirements
implements ParameterRequirements {
    private final String errorMessage;

    public OddParameterRequirements() {
        this(null);
    }

    public OddParameterRequirements(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void checkParameters(Command command, ExecutionHandlerContext executionHandlerContext) {
        if (!this.isOdd(command.getProcessedCommand().size())) {
            throw new RedisParametersMismatchException(this.getErrorMessage(command));
        }
    }

    private boolean isOdd(int n) {
        return n % 2 == 1;
    }

    private String getErrorMessage(Command command) {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return command.wrongNumberOfArgumentsErrorMessage();
    }
}

