/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.AsyncEventQueueMXBean;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DiskStoreMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.LocatorMXBean;
import org.apache.geode.management.LockServiceMXBean;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.ManagerMXBean;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.internal.AlertDetails;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.beans.AsyncEventQueueMBean;
import org.apache.geode.management.internal.beans.AsyncEventQueueMBeanBridge;
import org.apache.geode.management.internal.beans.CacheServerBridge;
import org.apache.geode.management.internal.beans.CacheServerMBean;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.geode.management.internal.beans.DiskStoreMBean;
import org.apache.geode.management.internal.beans.DiskStoreMBeanBridge;
import org.apache.geode.management.internal.beans.DistributedSystemBridge;
import org.apache.geode.management.internal.beans.GatewayReceiverMBean;
import org.apache.geode.management.internal.beans.GatewayReceiverMBeanBridge;
import org.apache.geode.management.internal.beans.GatewaySenderMBean;
import org.apache.geode.management.internal.beans.GatewaySenderMBeanBridge;
import org.apache.geode.management.internal.beans.LocatorMBean;
import org.apache.geode.management.internal.beans.LocatorMBeanBridge;
import org.apache.geode.management.internal.beans.LockServiceMBean;
import org.apache.geode.management.internal.beans.LockServiceMBeanBridge;
import org.apache.geode.management.internal.beans.MBeanAggregator;
import org.apache.geode.management.internal.beans.ManagerMBean;
import org.apache.geode.management.internal.beans.ManagerMBeanBridge;
import org.apache.geode.management.internal.beans.MemberMBean;
import org.apache.geode.management.internal.beans.MemberMBeanBridge;
import org.apache.geode.management.internal.beans.RegionMBean;
import org.apache.geode.management.internal.beans.RegionMBeanBridge;
import org.apache.geode.management.internal.beans.SequenceNumber;
import org.apache.geode.management.membership.ClientMembership;
import org.apache.geode.management.membership.ClientMembershipEvent;
import org.apache.geode.management.membership.ClientMembershipListener;
import org.apache.geode.management.membership.ClientMembershipListenerAdapter;
import org.apache.logging.log4j.Logger;

public class ManagementAdapter {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final List<String> INTERNAL_LOCK_SERVICES = Collections.unmodifiableList(Arrays.asList("DTLS", "LTLS", "__PRLS", "__PDX"));
    private final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private final Object regionOpLock = new Object();
    private SystemManagementService service;
    private InternalCache internalCache;
    private String memberSource;
    private NotificationBroadcasterSupport memberLevelNotificationEmitter;
    private MemberMBean memberBean;
    private MBeanAggregator aggregator;
    private MemberMBeanBridge memberMBeanBridge;
    private volatile boolean serviceInitialised;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCacheCreation(InternalCache cache) throws ManagementException {
        try {
            this.internalCache = cache;
            this.service = (SystemManagementService)ManagementService.getManagementService(this.internalCache);
            this.memberMBeanBridge = new MemberMBeanBridge(this.internalCache, this.service).init();
            this.memberBean = new MemberMBean(this.memberMBeanBridge);
            this.memberLevelNotificationEmitter = this.memberBean;
            this.memberSource = MBeanJMXAdapter.getMemberNameOrUniqueId(cache.getMyId());
            ObjectName objectName = MBeanJMXAdapter.getMemberMBeanName(cache.getMyId());
            ObjectName federatedName = this.service.registerInternalMBean(this.memberBean, objectName);
            this.service.federate(federatedName, MemberMXBean.class, true);
            this.serviceInitialised = true;
            if (InternalLocator.hasLocator()) {
                this.handleLocatorStart(InternalLocator.getLocator());
            }
            if (cache.getInternalDistributedSystem().getConfig().getJmxManager()) {
                this.service.createManager();
                if (cache.getInternalDistributedSystem().getConfig().getJmxManagerStart()) {
                    this.service.startManager();
                }
            }
        }
        finally {
            if (!this.serviceInitialised && this.service != null) {
                this.service.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("Management Service Could not initialise hence closing");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Management Service is initialised and Running");
            }
        }
    }

    void handleManagerStart() throws ManagementException {
        if (!this.isServiceInitialised("handleManagerStart")) {
            return;
        }
        DistributedSystemBridge distributedSystemBridge = new DistributedSystemBridge(this.service, this.internalCache);
        this.aggregator = new MBeanAggregator(distributedSystemBridge);
        this.service.addProxyListener(this.aggregator);
        MemberMXBean localMemberMXBean = this.service.getMemberMXBean();
        ObjectName memberObjectName = MBeanJMXAdapter.getMemberMBeanName(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        FederationComponent memberFederation = this.service.getLocalManager().getFedComponents().get(memberObjectName);
        this.service.afterCreateProxy(memberObjectName, MemberMXBean.class, localMemberMXBean, memberFederation);
        MBeanJMXAdapter jmxAdapter = this.service.getJMXAdapter();
        Map<ObjectName, Object> registeredMBeans = jmxAdapter.getLocalGemFireMBean();
        for (ObjectName objectName : registeredMBeans.keySet()) {
            if (objectName.equals(memberObjectName)) continue;
            Object object = registeredMBeans.get(objectName);
            try {
                ObjectInstance instance = this.mbeanServer.getObjectInstance(objectName);
                String className = instance.getClassName();
                Class clazz = ClassLoadUtil.classFromName(className);
                Type[] interfaceTypes = clazz.getGenericInterfaces();
                FederationComponent federation = this.service.getLocalManager().getFedComponents().get(objectName);
                for (Type interfaceType : interfaceTypes) {
                    Class interfaceTypeAsClass = (Class)interfaceType;
                    this.service.afterCreateProxy(objectName, interfaceTypeAsClass, object, federation);
                }
            }
            catch (InstanceNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed in Registering distributed mbean ");
                }
                throw new ManagementException(e);
            }
            catch (ClassNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed in Registering distributed mbean");
                }
                throw new ManagementException(e);
            }
        }
    }

    void handleManagerStop() throws ManagementException {
        if (!this.isServiceInitialised("handleManagerStop")) {
            return;
        }
        MemberMXBean localMemberMXBean = this.service.getMemberMXBean();
        ObjectName memberObjectName = MBeanJMXAdapter.getMemberMBeanName(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        FederationComponent memberFederation = this.service.getLocalManager().getFedComponents().get(memberObjectName);
        this.service.afterRemoveProxy(memberObjectName, MemberMXBean.class, localMemberMXBean, memberFederation);
        ObjectName aggregateMBeanPattern = this.aggregateMBeanPattern();
        MBeanJMXAdapter jmxAdapter = this.service.getJMXAdapter();
        Map<ObjectName, Object> registeredMBeans = jmxAdapter.getLocalGemFireMBean();
        for (ObjectName objectName : registeredMBeans.keySet()) {
            if (objectName.equals(memberObjectName) || aggregateMBeanPattern.apply(objectName)) continue;
            Object object = registeredMBeans.get(objectName);
            try {
                ObjectInstance instance = this.mbeanServer.getObjectInstance(objectName);
                String className = instance.getClassName();
                Class clazz = ClassLoadUtil.classFromName(className);
                Type[] interfaceTypes = clazz.getGenericInterfaces();
                FederationComponent federation = this.service.getLocalManager().getFedComponents().get(objectName);
                for (Type interfaceType : interfaceTypes) {
                    Class interfaceTypeClass = (Class)interfaceType;
                    this.service.afterRemoveProxy(objectName, interfaceTypeClass, object, federation);
                }
            }
            catch (ClassNotFoundException | InstanceNotFoundException e) {
                logger.warn("Failed to invoke aggregator for {} with exception {}", (Object)objectName, (Object)e.getMessage(), (Object)e);
            }
        }
        this.service.removeProxyListener(this.aggregator);
        this.aggregator = null;
    }

    void handleManagerCreation() throws ManagementException {
        if (!this.isServiceInitialised("handleManagerCreation")) {
            return;
        }
        ObjectName objectName = MBeanJMXAdapter.getManagerName();
        ManagerMBeanBridge managerMBeanBridge = new ManagerMBeanBridge(this.service);
        ManagerMBean managerMXBean = new ManagerMBean(managerMBeanBridge);
        ObjectName federatedName = this.service.registerInternalMBean(managerMXBean, objectName);
        this.service.federate(federatedName, ManagerMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.manager.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Manager is Started in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> void handleRegionCreation(Region<K, V> region) throws ManagementException {
        if (!this.isServiceInitialised("handleRegionCreation")) {
            return;
        }
        Object object = this.regionOpLock;
        synchronized (object) {
            if (region.isDestroyed()) {
                return;
            }
            RegionMBeanBridge<K, V> regionMBeanBridge = RegionMBeanBridge.getInstance(region);
            RegionMBean<K, V> regionMXBean = new RegionMBean<K, V>(regionMBeanBridge);
            ObjectName objectName = MBeanJMXAdapter.getRegionMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), region.getFullPath());
            ObjectName federatedName = this.service.registerInternalMBean(regionMXBean, objectName);
            this.service.federate(federatedName, RegionMXBean.class, true);
            Notification notification = new Notification("gemfire.distributedsystem.cache.region.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Region Created With Name " + region.getFullPath());
            this.memberLevelNotificationEmitter.sendNotification(notification);
            this.memberMBeanBridge.addRegion(region);
        }
    }

    void handleDiskCreation(DiskStore diskStore) throws ManagementException {
        if (!this.isServiceInitialised("handleDiskCreation")) {
            return;
        }
        DiskStoreMBeanBridge diskStoreMBeanBridge = new DiskStoreMBeanBridge(diskStore);
        DiskStoreMBean diskStoreMXBean = new DiskStoreMBean(diskStoreMBeanBridge);
        ObjectName objectName = MBeanJMXAdapter.getDiskStoreMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), diskStore.getName());
        ObjectName federatedName = this.service.registerInternalMBean(diskStoreMXBean, objectName);
        this.service.federate(federatedName, DiskStoreMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.cache.disk.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "DiskStore Created With Name " + diskStore.getName());
        this.memberLevelNotificationEmitter.sendNotification(notification);
        this.memberMBeanBridge.addDiskStore(diskStore);
    }

    void handleLockServiceCreation(DLockService lockService) throws ManagementException {
        if (!this.isServiceInitialised("handleLockServiceCreation")) {
            return;
        }
        if (INTERNAL_LOCK_SERVICES.contains(lockService.getName())) {
            return;
        }
        LockServiceMBeanBridge lockServiceMBeanBridge = new LockServiceMBeanBridge(lockService);
        LockServiceMBean lockServiceMXBean = new LockServiceMBean(lockServiceMBeanBridge);
        ObjectName objectName = MBeanJMXAdapter.getLockServiceMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), lockService.getName());
        ObjectName federatedName = this.service.registerInternalMBean(lockServiceMXBean, objectName);
        this.service.federate(federatedName, LockServiceMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.cache.lockservice.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "LockService Created With Name " + lockService.getName());
        this.memberLevelNotificationEmitter.sendNotification(notification);
        this.memberMBeanBridge.addLockServiceStats(lockService);
    }

    void handleGatewaySenderCreation(GatewaySender sender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderCreation")) {
            return;
        }
        GatewaySenderMBeanBridge gatewaySenderMBeanBridge = new GatewaySenderMBeanBridge(sender);
        GatewaySenderMBean gatewaySenderMXBean = new GatewaySenderMBean(gatewaySenderMBeanBridge);
        ObjectName objectName = MBeanJMXAdapter.getGatewaySenderMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), sender.getId());
        ObjectName federatedName = this.service.registerInternalMBean(gatewaySenderMXBean, objectName);
        this.service.federate(federatedName, GatewaySenderMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Created in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewayReceiverCreate(GatewayReceiver gatewayReceiver) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewayReceiverCreate")) {
            return;
        }
        if (!gatewayReceiver.isManualStart()) {
            return;
        }
        this.createGatewayReceiverMBean(gatewayReceiver);
    }

    private void createGatewayReceiverMBean(GatewayReceiver gatewayReceiver) {
        GatewayReceiverMBeanBridge gatewayReceiverMBeanBridge = new GatewayReceiverMBeanBridge(gatewayReceiver);
        GatewayReceiverMBean gatewayReceiverMXBean = new GatewayReceiverMBean(gatewayReceiverMBeanBridge);
        ObjectName objectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(this.internalCache.getDistributedSystem().getDistributedMember());
        ObjectName federatedName = this.service.registerInternalMBean(gatewayReceiverMXBean, objectName);
        this.service.federate(federatedName, GatewayReceiverMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.gateway.receiver.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewayReceiver Created in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewayReceiverDestroy() throws ManagementException {
        if (!this.isServiceInitialised("handleGatewayReceiverDestroy")) {
            return;
        }
        GatewayReceiverMBean gatewayReceiverMBean = (GatewayReceiverMBean)this.service.getLocalGatewayReceiverMXBean();
        GatewayReceiverMBeanBridge gatewayReceiverMBeanBridge = gatewayReceiverMBean.getBridge();
        gatewayReceiverMBeanBridge.destroyServer();
        ObjectName objectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(this.internalCache.getDistributedSystem().getDistributedMember());
        this.service.unregisterMBean(objectName);
        Notification notification = new Notification("gemfire.distributedsystem.gateway.receiver.destroyed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewayReceiver Destroyed in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewayReceiverStart(GatewayReceiver gatewayReceiver) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewayReceiverStart")) {
            return;
        }
        if (!gatewayReceiver.isManualStart()) {
            this.createGatewayReceiverMBean(gatewayReceiver);
        }
        GatewayReceiverMBean gatewayReceiverMBean = (GatewayReceiverMBean)this.service.getLocalGatewayReceiverMXBean();
        GatewayReceiverMBeanBridge gatewayReceiverMBeanBridge = gatewayReceiverMBean.getBridge();
        gatewayReceiverMBeanBridge.startServer();
        Notification notification = new Notification("gemfire.distributedsystem.gateway.receiver.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewayReceiver Started in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewayReceiverStop() throws ManagementException {
        if (!this.isServiceInitialised("handleGatewayReceiverStop")) {
            return;
        }
        GatewayReceiverMBean gatewayReceiverMBean = (GatewayReceiverMBean)this.service.getLocalGatewayReceiverMXBean();
        GatewayReceiverMBeanBridge gatewayReceiverMBeanBridge = gatewayReceiverMBean.getBridge();
        gatewayReceiverMBeanBridge.stopServer();
        Notification notification = new Notification("gemfire.distributedsystem.gateway.receiver.stopped", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewayReceiver Stopped in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleAsyncEventQueueCreation(AsyncEventQueue asyncEventQueue) throws ManagementException {
        if (!this.isServiceInitialised("handleAsyncEventQueueCreation")) {
            return;
        }
        AsyncEventQueueMBeanBridge asyncEventQueueMBeanBridge = new AsyncEventQueueMBeanBridge(asyncEventQueue);
        AsyncEventQueueMBean asyncEventQueueMXBean = new AsyncEventQueueMBean(asyncEventQueueMBeanBridge);
        ObjectName objectName = MBeanJMXAdapter.getAsyncEventQueueMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), asyncEventQueue.getId());
        ObjectName federatedName = this.service.registerInternalMBean(asyncEventQueueMXBean, objectName);
        this.service.federate(federatedName, AsyncEventQueueMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.asycn.event.queue.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Async Event Queue is Created  in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleAsyncEventQueueRemoval(AsyncEventQueue asyncEventQueue) throws ManagementException {
        if (!this.isServiceInitialised("handleAsyncEventQueueRemoval")) {
            return;
        }
        ObjectName objectName = MBeanJMXAdapter.getAsyncEventQueueMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), asyncEventQueue.getId());
        try {
            AsyncEventQueueMBean asyncEventQueueMBean = (AsyncEventQueueMBean)this.service.getLocalAsyncEventQueueMXBean(asyncEventQueue.getId());
            if (asyncEventQueueMBean == null) {
                return;
            }
            asyncEventQueueMBean.stopMonitor();
        }
        catch (ManagementException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return;
        }
        this.service.unregisterMBean(objectName);
        Notification notification = new Notification("gemfire.distributedsystem.async.event.queue.closed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Async Event Queue is Closed in the VM " + asyncEventQueue.getId());
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleSystemNotification(AlertDetails alertDetails) {
        if (!this.isServiceInitialised("handleSystemNotification")) {
            return;
        }
        if (this.service.isManager()) {
            String systemSource = "DistributedSystem(" + this.service.getDistributedSystemMXBean().getDistributedSystemId() + ")";
            Notification notification = new Notification("system.alert", systemSource, SequenceNumber.next(), alertDetails.getMsgTime().getTime(), alertDetails.getMsg());
            notification.setUserData(this.prepareUserData(alertDetails));
            this.service.handleNotification(notification);
        }
    }

    private Map<String, String> prepareUserData(AlertDetails alertDetails) {
        HashMap<String, String> userData = new HashMap<String, String>();
        userData.put("AlertLevel", AlertDetails.getAlertLevelAsString(alertDetails.getAlertLevel()));
        userData.put("Thread", alertDetails.getSource());
        userData.put("Member", this.getNameOrId(alertDetails.getSender()));
        return userData;
    }

    void handleCacheServerStart(CacheServer cacheServer) {
        if (!this.isServiceInitialised("handleCacheServerStart")) {
            return;
        }
        CacheServerBridge cacheServerBridge = new CacheServerBridge(this.internalCache, cacheServer);
        cacheServerBridge.setMemberMBeanBridge(this.memberMBeanBridge);
        CacheServerMBean cacheServerMBean = new CacheServerMBean(cacheServerBridge);
        ObjectName objectName = MBeanJMXAdapter.getClientServiceMBeanName(cacheServer.getPort(), this.internalCache.getDistributedSystem().getDistributedMember());
        ObjectName federatedName = this.service.registerInternalMBean(cacheServerMBean, objectName);
        CacheServerMembershipListenerAdapter managementClientListener = new CacheServerMembershipListenerAdapter(cacheServerMBean, this.memberLevelNotificationEmitter, federatedName);
        ClientMembership.registerClientMembershipListener(managementClientListener);
        cacheServerBridge.setClientMembershipListener(managementClientListener);
        this.service.federate(federatedName, CacheServerMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.cache.server.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Cache Server is Started in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
        this.memberMBeanBridge.setCacheServer(true);
    }

    void handleCacheServerStop(CacheServer server) {
        if (!this.isServiceInitialised("handleCacheServerStop")) {
            return;
        }
        CacheServerMBean cacheServerMBean = (CacheServerMBean)this.service.getLocalCacheServerMXBean(server.getPort());
        ClientMembershipListener clientMembershipListener = cacheServerMBean.getBridge().getClientMembershipListener();
        if (clientMembershipListener != null) {
            ClientMembership.unregisterClientMembershipListener(clientMembershipListener);
        }
        cacheServerMBean.stopMonitor();
        ObjectName objectName = MBeanJMXAdapter.getClientServiceMBeanName(server.getPort(), this.internalCache.getDistributedSystem().getDistributedMember());
        this.service.unregisterMBean(objectName);
        Notification notification = new Notification("gemfire.distributedsystem.cache.server.stopped", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Cache Server is stopped in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
        this.memberMBeanBridge.setCacheServer(false);
    }

    void handleCacheRemoval() throws ManagementException {
        block8: {
            if (!this.isServiceInitialised("handleCacheRemoval")) {
                return;
            }
            this.serviceInitialised = false;
            try {
                this.cleanUpMonitors();
                this.cleanBridgeResources();
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.service.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.internalCache = null;
            this.service = null;
            this.memberMBeanBridge = null;
            this.memberBean = null;
            this.memberLevelNotificationEmitter = null;
        }
    }

    private String getNameOrId(DistributedMember member) {
        if (member == null) {
            return this.memberSource;
        }
        return StringUtils.isNotBlank((CharSequence)member.getName()) ? member.getName() : member.getId();
    }

    private void cleanUpMonitors() {
        GatewayReceiverMBean gatewayReceiverMBean;
        Set<GatewaySender> gatewaySenders;
        MemberMBean memberMBean = (MemberMBean)this.service.getMemberMXBean();
        if (memberMBean != null) {
            memberMBean.stopMonitor();
        }
        if ((gatewaySenders = this.internalCache.getGatewaySenders()) != null && !gatewaySenders.isEmpty()) {
            for (GatewaySender gatewaySender : gatewaySenders) {
                GatewaySenderMBean gatewaySenderMBean = (GatewaySenderMBean)this.service.getLocalGatewaySenderMXBean(gatewaySender.getId());
                if (gatewaySenderMBean == null) continue;
                gatewaySenderMBean.stopMonitor();
            }
        }
        if ((gatewayReceiverMBean = (GatewayReceiverMBean)this.service.getLocalGatewayReceiverMXBean()) != null) {
            gatewayReceiverMBean.stopMonitor();
        }
    }

    private void cleanBridgeResources() {
        List<CacheServer> cacheServers = this.internalCache.getCacheServers();
        if (cacheServers != null && !cacheServers.isEmpty()) {
            for (CacheServer cacheServer : cacheServers) {
                ClientMembershipListener listener;
                CacheServerMBean cacheServerMBean = (CacheServerMBean)this.service.getLocalCacheServerMXBean(cacheServer.getPort());
                if (cacheServerMBean == null || (listener = cacheServerMBean.getBridge().getClientMembershipListener()) == null) continue;
                ClientMembership.unregisterClientMembershipListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRegionRemoval(Region region) throws ManagementException {
        if (!this.isServiceInitialised("handleRegionRemoval")) {
            return;
        }
        Object object = this.regionOpLock;
        synchronized (object) {
            ObjectName objectName = MBeanJMXAdapter.getRegionMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), region.getFullPath());
            try {
                RegionMBean regionMBean = (RegionMBean)this.service.getLocalRegionMBean(region.getFullPath());
                if (regionMBean != null) {
                    regionMBean.stopMonitor();
                }
            }
            catch (ManagementException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                return;
            }
            this.service.unregisterMBean(objectName);
            Notification notification = new Notification("gemfire.distributedsystem.cache.region.closed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Region Destroyed/Closed With Name " + region.getFullPath());
            this.memberLevelNotificationEmitter.sendNotification(notification);
            this.memberMBeanBridge.removeRegion(region);
        }
    }

    void handleDiskRemoval(DiskStore diskStore) throws ManagementException {
        if (!this.isServiceInitialised("handleDiskRemoval")) {
            return;
        }
        ObjectName objectName = MBeanJMXAdapter.getDiskStoreMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), diskStore.getName());
        try {
            DiskStoreMBean diskStoreMBean = (DiskStoreMBean)this.service.getLocalDiskStoreMBean(diskStore.getName());
            if (diskStoreMBean == null) {
                return;
            }
            diskStoreMBean.stopMonitor();
        }
        catch (ManagementException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return;
        }
        this.service.unregisterMBean(objectName);
        Notification notification = new Notification("gemfire.distributedsystem.cache.disk.closed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "DiskStore Destroyed/Closed With Name " + diskStore.getName());
        this.memberLevelNotificationEmitter.sendNotification(notification);
        this.memberMBeanBridge.removeDiskStore(diskStore);
    }

    void handleLockServiceRemoval(DLockService lockService) throws ManagementException {
        if (!this.isServiceInitialised("handleLockServiceRemoval")) {
            return;
        }
        ObjectName objectName = MBeanJMXAdapter.getLockServiceMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), lockService.getName());
        this.service.unregisterMBean(objectName);
        Notification notification = new Notification("gemfire.distributedsystem.cache.lockservice.closed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Lockservice closed With Name " + lockService.getName());
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleLocatorStart(Locator locator) throws ManagementException {
        if (!this.isServiceInitialised("handleLocatorCreation")) {
            return;
        }
        ObjectName objectName = MBeanJMXAdapter.getLocatorMBeanName(this.internalCache.getDistributedSystem().getDistributedMember());
        LocatorMBeanBridge locatorMBeanBridge = new LocatorMBeanBridge(locator);
        LocatorMBean locatorMBean = new LocatorMBean(locatorMBeanBridge);
        ObjectName federatedName = this.service.registerInternalMBean(locatorMBean, objectName);
        this.service.federate(federatedName, LocatorMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.locator.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Locator is Started in the VM ");
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewaySenderStart(GatewaySender gatewaySender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderStart")) {
            return;
        }
        if (gatewaySender.getRemoteDSId() < 0) {
            return;
        }
        GatewaySenderMBean gatewaySenderMBean = (GatewaySenderMBean)this.service.getLocalGatewaySenderMXBean(gatewaySender.getId());
        gatewaySenderMBean.getBridge().setDispatcher();
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Started in the VM " + gatewaySender.getId());
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewaySenderStop(GatewaySender gatewaySender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderStop")) {
            return;
        }
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.stopped", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Stopped in the VM " + gatewaySender.getId());
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewaySenderPaused(GatewaySender gatewaySender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderPaused")) {
            return;
        }
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.paused", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Paused in the VM " + gatewaySender.getId());
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewaySenderResumed(GatewaySender gatewaySender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderResumed")) {
            return;
        }
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.resumed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Resumed in the VM " + gatewaySender.getId());
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleGatewaySenderRemoved(GatewaySender gatewaySender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderRemoved")) {
            return;
        }
        if (gatewaySender.getRemoteDSId() < 0) {
            return;
        }
        GatewaySenderMBean gatewaySenderMBean = (GatewaySenderMBean)this.service.getLocalGatewaySenderMXBean(gatewaySender.getId());
        gatewaySenderMBean.stopMonitor();
        ObjectName objectName = MBeanJMXAdapter.getGatewaySenderMBeanName(this.internalCache.getDistributedSystem().getDistributedMember(), gatewaySender.getId());
        this.service.unregisterMBean(objectName);
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.removed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Removed in the VM " + gatewaySender.getId());
        this.memberLevelNotificationEmitter.sendNotification(notification);
    }

    void handleCacheServiceCreation(CacheService cacheService) throws ManagementException {
        if (!this.isServiceInitialised("handleCacheServiceCreation")) {
            return;
        }
        InternalDistributedMember member = this.internalCache.getInternalDistributedSystem().getDistributedMember();
        if (member.getVmKind() == 11) {
            return;
        }
        CacheServiceMBeanBase cacheServiceMBean = cacheService.getMBean();
        if (cacheServiceMBean != null) {
            String id = cacheServiceMBean.getId();
            ObjectName objectName = MBeanJMXAdapter.getCacheServiceMBeanName(member, id);
            ObjectName federatedName = this.service.registerInternalMBean(cacheServiceMBean, objectName);
            this.service.federate(federatedName, cacheServiceMBean.getInterfaceClass(), true);
            Notification notification = new Notification("gemfire.distributedsystem.cache.service.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Cache Service Created With Name " + id);
            this.memberLevelNotificationEmitter.sendNotification(notification);
        }
    }

    private ObjectName aggregateMBeanPattern() {
        try {
            return new ObjectName("GemFire:*,type=Distributed");
        }
        catch (NullPointerException | MalformedObjectNameException e) {
            throw new ManagementException(e);
        }
    }

    private boolean isServiceInitialised(String method) {
        if (!this.serviceInitialised && logger.isDebugEnabled()) {
            logger.debug("Management Service is not initialised hence returning from {}", (Object)method);
        }
        return this.serviceInitialised;
    }

    private static class CacheServerMembershipListenerAdapter
    extends ClientMembershipListenerAdapter {
        private final NotificationBroadcasterSupport serverLevelNotificationEmitter;
        private final NotificationBroadcasterSupport memberLevelNotificationEmitter;
        private final String serverSource;

        private CacheServerMembershipListenerAdapter(NotificationBroadcasterSupport serverLevelNotificationEmitter, NotificationBroadcasterSupport memberLevelNotificationEmitter, ObjectName serverSource) {
            this.serverLevelNotificationEmitter = serverLevelNotificationEmitter;
            this.memberLevelNotificationEmitter = memberLevelNotificationEmitter;
            this.serverSource = serverSource.toString();
        }

        @Override
        public void memberJoined(ClientMembershipEvent event) {
            Notification notification = new Notification("gemfire.distributedsystem.cacheserver.client.joined", this.serverSource, SequenceNumber.next(), System.currentTimeMillis(), "Client joined with Id " + event.getMemberId());
            this.serverLevelNotificationEmitter.sendNotification(notification);
            this.memberLevelNotificationEmitter.sendNotification(notification);
        }

        @Override
        public void memberLeft(ClientMembershipEvent event) {
            Notification notification = new Notification("gemfire.distributedsystem.cacheserver.client.left", this.serverSource, SequenceNumber.next(), System.currentTimeMillis(), "Client left with Id " + event.getMemberId());
            this.serverLevelNotificationEmitter.sendNotification(notification);
            this.memberLevelNotificationEmitter.sendNotification(notification);
        }

        @Override
        public void memberCrashed(ClientMembershipEvent event) {
            Notification notification = new Notification("gemfire.distributedsystem.cacheserver.client.crashed", this.serverSource, SequenceNumber.next(), System.currentTimeMillis(), "Client crashed with Id " + event.getMemberId());
            this.serverLevelNotificationEmitter.sendNotification(notification);
            this.memberLevelNotificationEmitter.sendNotification(notification);
        }
    }
}

