/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class JmxManagerLocatorResponse
implements DataSerializableFixedID {
    private String host;
    private int port;
    private boolean ssl;
    private Throwable ex;

    public JmxManagerLocatorResponse(String host, int port, boolean ssl, Throwable ex) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.ex = ex;
    }

    public JmxManagerLocatorResponse() {
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.host = DataSerializer.readString(in);
        this.port = DataSerializer.readPrimitiveInt(in);
        this.ssl = DataSerializer.readPrimitiveBoolean(in);
        this.ex = (Throwable)context.getDeserializer().readObject(in);
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeString(this.host, out);
        DataSerializer.writePrimitiveInt(this.port, out);
        DataSerializer.writePrimitiveBoolean(this.ssl, out);
        context.getSerializer().writeObject((Object)this.ex, out);
    }

    public int getDSFID() {
        return 2151;
    }

    public String toString() {
        return "JmxManagerLocatorResponse [host=" + this.host + ", port=" + this.port + ", ssl=" + this.ssl + ", ex=" + this.ex + "]";
    }

    public String getHost() {
        try {
            return InetAddress.getByName(this.host).getHostName();
        }
        catch (UnknownHostException e) {
            return this.host;
        }
    }

    public int getPort() {
        return this.port;
    }

    public Throwable getException() {
        return this.ex;
    }

    public boolean isJmxManagerSslEnabled() {
        return this.ssl;
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

