/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.logging.internal.LoggingSessionNotifier;
import org.apache.geode.logging.internal.spi.LogFile;
import org.apache.geode.logging.internal.spi.LoggingSessionListener;
import org.apache.geode.logging.internal.spi.LoggingSessionRegistry;
import org.apache.geode.logging.internal.spi.SessionContext;

public class LoggingSessionRegistryProvider
implements LoggingSessionRegistry,
LoggingSessionNotifier {
    @MakeNotStatic
    private static final LoggingSessionRegistryProvider INSTANCE = new LoggingSessionRegistryProvider();
    private final Set<LoggingSessionListener> listeners = new LinkedHashSet<LoggingSessionListener>();

    public static LoggingSessionRegistryProvider get() {
        return INSTANCE;
    }

    @VisibleForTesting
    LoggingSessionRegistryProvider() {
    }

    @Override
    public void addLoggingSessionListener(LoggingSessionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLoggingSessionListener(LoggingSessionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clear() {
        this.listeners.clear();
    }

    @Override
    public void createSession(SessionContext sessionContext) {
        for (LoggingSessionListener listener : this.listeners) {
            listener.createSession(sessionContext);
        }
    }

    @Override
    public void startSession() {
        for (LoggingSessionListener listener : this.listeners) {
            listener.startSession();
        }
    }

    @Override
    public void stopSession() {
        for (LoggingSessionListener listener : this.listeners) {
            listener.stopSession();
        }
    }

    @Override
    public Optional<LogFile> getLogFile() {
        for (LoggingSessionListener listener : this.listeners) {
            if (!listener.getLogFile().isPresent()) continue;
            return listener.getLogFile();
        }
        return Optional.empty();
    }
}

