/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Set;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.operations.ExecuteCQOperationContext;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.cache.operations.GetOperationContext;
import org.apache.geode.cache.operations.KeySetOperationContext;
import org.apache.geode.cache.operations.QueryOperationContext;
import org.apache.geode.cache.operations.internal.GetOperationContextImpl;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.security.AccessControl;
import org.apache.geode.security.NotAuthorizedException;

public class AuthorizeRequestPP {
    private AccessControl postAuthzCallback;
    private final ClientProxyMembershipID id;
    private final LogWriter logger;
    private final Principal principal;
    private final boolean isPrincipalSerializable;

    public AuthorizeRequestPP(String postAuthzFactoryName, ClientProxyMembershipID id, Principal principal, Cache cache) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.id = id;
        this.principal = principal;
        this.isPrincipalSerializable = this.principal instanceof Serializable;
        this.logger = cache.getSecurityLogger();
        Method postAuthzMethod = ClassLoadUtil.methodFromName(postAuthzFactoryName);
        this.postAuthzCallback = (AccessControl)postAuthzMethod.invoke(null, (Object[])null);
        this.postAuthzCallback.init(principal, id.getDistributedMember(), cache);
        if (this.logger.infoEnabled()) {
            this.logger.info(String.format("AuthorizeRequestPP: Setting post process authorization callback to %s for client[%s].", id, postAuthzFactoryName));
        }
    }

    public AccessControl getPostAuthzCallback() {
        return this.postAuthzCallback;
    }

    public GetOperationContext getAuthorize(String regionName, Object key, Object result, boolean isObject, GetOperationContext getContext) throws NotAuthorizedException {
        if (getContext == null) {
            getContext = new GetOperationContextImpl(key, true);
        } else {
            getContext.setPostOperation();
        }
        getContext.setObject(result, isObject);
        if (!this.postAuthzCallback.authorizeOperation(regionName, getContext)) {
            String errStr = String.format("In post-process: not authorized to perform GET operation on region %s", regionName);
            this.logger.warning(String.format("%s : %s", this.id, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.id + ": In post-process: authorized to perform GET operation on region [" + regionName + ']');
        }
        return getContext;
    }

    public QueryOperationContext queryAuthorize(String queryString, Set regionNames, Object queryResult, QueryOperationContext queryContext, Object[] queryParams) throws NotAuthorizedException {
        if (queryContext == null) {
            queryContext = new QueryOperationContext(queryString, regionNames, true, queryParams);
        } else {
            queryContext.setPostOperation();
        }
        queryContext.setQueryResult(queryResult);
        if (!this.postAuthzCallback.authorizeOperation(null, queryContext)) {
            String errStr = String.format("In post-process: not authorized to perform QUERY operation %s on the cache", queryString);
            this.logger.warning(String.format("%s : %s", this.id, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.id + ": In post-process: authorized to perform QUERY operation [" + queryString + "] on cache");
        }
        return queryContext;
    }

    public QueryOperationContext executeCQAuthorize(String cqName, String queryString, Set regionNames, Object queryResult, QueryOperationContext executeCQContext) throws NotAuthorizedException {
        if (executeCQContext == null) {
            executeCQContext = new ExecuteCQOperationContext(cqName, queryString, regionNames, true);
        } else {
            executeCQContext.setPostOperation();
        }
        executeCQContext.setQueryResult(queryResult);
        if (!this.postAuthzCallback.authorizeOperation(null, executeCQContext)) {
            String errStr = String.format("In post-process: not authorized to perform EXECUTE_CQ operation %s on the cache", queryString);
            this.logger.warning(String.format("%s : %s", this.id, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.id + ": In post-process: authorized to perform EXECUTE_CQ operation [" + queryString + "] on cache");
        }
        return executeCQContext;
    }

    public KeySetOperationContext keySetAuthorize(String regionName, Set keySet, KeySetOperationContext keySetContext) throws NotAuthorizedException {
        if (keySetContext == null) {
            keySetContext = new KeySetOperationContext(true);
        } else {
            keySetContext.setPostOperation();
        }
        keySetContext.setKeySet(keySet);
        if (!this.postAuthzCallback.authorizeOperation(regionName, keySetContext)) {
            String errStr = String.format("In post-process: not authorized to perform KEY_SET operation on region %s", regionName);
            this.logger.warning(String.format("%s : %s", this.id, errStr));
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.id + ": In post-process: authorized to perform KEY_SET operation on region [" + regionName + ']');
        }
        return keySetContext;
    }

    public ExecuteFunctionOperationContext executeFunctionAuthorize(Object oneResult, ExecuteFunctionOperationContext executeContext) throws NotAuthorizedException {
        executeContext.setResult(oneResult);
        String regionName = executeContext.getRegionName();
        if (!this.postAuthzCallback.authorizeOperation(regionName, executeContext)) {
            String errStr = String.format("%s: In post-process: Not authorized to perform EXECUTE_REGION_FUNCTION operation on region [%s]", this.toString(), regionName);
            if (this.logger.warningEnabled()) {
                this.logger.warning(String.format("%s", errStr));
            }
            if (this.isPrincipalSerializable) {
                throw new NotAuthorizedException(errStr, this.principal);
            }
            throw new NotAuthorizedException(errStr);
        }
        if (this.logger.finestEnabled()) {
            this.logger.finest(this.id + ": In post-process: authorized to perform EXECUTE_REGION_FUNCTION operation on region [" + regionName + ']');
        }
        return executeContext;
    }

    public void close() {
        this.postAuthzCallback.close();
    }
}

