/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.CancelException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.FixedPartitionAttributes;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.MirrorType;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.cache.TransactionListener;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.internal.index.HashIndex;
import org.apache.geode.cache.query.internal.index.PrimaryKeyIndex;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.Role;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.ClientSubscriptionConfigImpl;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DiskWriteAttributesImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.persistence.DefaultDiskDirs;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.CacheXml;
import org.apache.geode.internal.cache.xmlcache.CacheXmlVersion;
import org.apache.geode.internal.cache.xmlcache.ClientCacheCreation;
import org.apache.geode.internal.cache.xmlcache.Declarable2;
import org.apache.geode.internal.cache.xmlcache.DiskStoreAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.IndexCreationData;
import org.apache.geode.internal.cache.xmlcache.RegionAttributesCreation;
import org.apache.geode.internal.cache.xmlcache.RegionCreation;
import org.apache.geode.internal.cache.xmlcache.SerializerCreation;
import org.apache.geode.internal.cache.xmlcache.XmlGeneratorUtils;
import org.apache.geode.internal.size.SizeClassOnceObjectSizer;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class CacheXmlGenerator
extends CacheXml
implements XMLReader {
    @Immutable
    private static final Attributes EMPTY = new AttributesImpl();
    private ContentHandler handler;
    private final Cache cache;
    private boolean useSchema;
    private boolean includeKeysValues = true;
    private final boolean generateDefaults;
    private final CacheCreation creation;

    public static void generate(Cache cache, PrintWriter pw, boolean useSchema, String version) {
        new CacheXmlGenerator(cache, useSchema, version, true).generate(pw);
    }

    public static void generate(Cache cache, PrintWriter pw, boolean includeKeysValues) {
        new CacheXmlGenerator(cache, true, "1.0", includeKeysValues).generate(pw);
    }

    @Deprecated
    public static void generate(Cache cache, PrintWriter pw, boolean useSchema, boolean includeKeysValues, boolean includeDefaults) {
        new CacheXmlGenerator(cache, true, "1.0", includeKeysValues, includeDefaults).generate(pw);
    }

    public static void generate(Cache cache, PrintWriter pw, boolean includeKeysValues, boolean includeDefaults) {
        new CacheXmlGenerator(cache, true, "1.0", includeKeysValues, includeDefaults).generate(pw);
    }

    public static void generate(Cache cache, PrintWriter pw) {
        new CacheXmlGenerator(cache, true, "1.0", true).generate(pw);
    }

    public static void generate(ClientCache cache, PrintWriter pw, boolean useSchema, String version) {
        new CacheXmlGenerator(cache, useSchema, version, true).generate(pw);
    }

    public static void generate(ClientCache cache, PrintWriter pw, boolean includeKeysValues) {
        new CacheXmlGenerator(cache, true, "1.0", includeKeysValues).generate(pw);
    }

    public static void generate(ClientCache cache, PrintWriter pw) {
        new CacheXmlGenerator(cache, true, "1.0", true).generate(pw);
    }

    public static void generateDefault(PrintWriter pw) {
        new CacheXmlGenerator().generate(pw);
    }

    private CacheXmlGenerator(Cache cache, boolean useSchema, String version, boolean includeKeysValues) {
        this(cache, useSchema, version, includeKeysValues, true);
    }

    private CacheXmlGenerator(Cache cache, boolean useSchema, String version, boolean includeKeysValues, boolean generateDefaults) {
        this.cache = cache;
        this.useSchema = useSchema;
        this.version = CacheXmlVersion.valueForVersion(version);
        this.includeKeysValues = includeKeysValues;
        this.generateDefaults = generateDefaults;
        if (cache instanceof CacheCreation) {
            this.creation = (CacheCreation)cache;
            this.creation.startingGenerate();
        } else if (cache instanceof GemFireCacheImpl) {
            if (((InternalCache)cache).isClient()) {
                this.creation = new ClientCacheCreation();
                if (this.generateDefaults() || cache.getCopyOnRead()) {
                    this.creation.setCopyOnRead(cache.getCopyOnRead());
                }
            } else {
                this.creation = new CacheCreation(!generateDefaults);
                if (this.generateDefaults() || cache.getLockLease() != GemFireCacheImpl.DEFAULT_LOCK_LEASE) {
                    this.creation.setLockLease(cache.getLockLease());
                }
                if (this.generateDefaults() || cache.getLockTimeout() != GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT) {
                    this.creation.setLockTimeout(cache.getLockTimeout());
                }
                if (this.generateDefaults() || cache.getSearchTimeout() != GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT) {
                    this.creation.setSearchTimeout(cache.getSearchTimeout());
                }
                if (this.generateDefaults() || cache.isServer()) {
                    this.creation.setIsServer(cache.isServer());
                }
                if (this.generateDefaults() || cache.getCopyOnRead()) {
                    this.creation.setCopyOnRead(cache.getCopyOnRead());
                }
            }
        } else {
            this.creation = new CacheCreation(!generateDefaults);
            if (this.generateDefaults() || cache.getLockLease() != GemFireCacheImpl.DEFAULT_LOCK_LEASE) {
                this.creation.setLockLease(cache.getLockLease());
            }
            if (this.generateDefaults() || cache.getLockTimeout() != GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT) {
                this.creation.setLockTimeout(cache.getLockTimeout());
            }
            if (this.generateDefaults() || cache.getSearchTimeout() != GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT) {
                this.creation.setSearchTimeout(cache.getSearchTimeout());
            }
            if (this.generateDefaults() || cache.isServer()) {
                this.creation.setIsServer(cache.isServer());
            }
            if (this.generateDefaults() || cache.getCopyOnRead()) {
                this.creation.setCopyOnRead(cache.getCopyOnRead());
            }
        }
    }

    private CacheXmlGenerator(ClientCache cache, boolean useSchema, String version, boolean includeKeysValues) {
        this.cache = (Cache)((Object)cache);
        this.useSchema = useSchema;
        this.version = CacheXmlVersion.valueForVersion(version);
        this.includeKeysValues = includeKeysValues;
        this.generateDefaults = true;
        if (cache instanceof ClientCacheCreation) {
            this.creation = (ClientCacheCreation)cache;
            this.creation.startingGenerate();
        } else {
            this.creation = new ClientCacheCreation();
            if (cache.getCopyOnRead()) {
                this.creation.setCopyOnRead(cache.getCopyOnRead());
            }
        }
    }

    private boolean generateDefaults() {
        return this.generateDefaults;
    }

    private CacheXmlGenerator() {
        this.cache = null;
        this.useSchema = true;
        this.version = CacheXmlVersion.valueForVersion("1.0");
        this.generateDefaults = true;
        this.creation = new CacheCreation();
        this.creation.setLockLease(GemFireCacheImpl.DEFAULT_LOCK_LEASE);
        this.creation.setLockTimeout(GemFireCacheImpl.DEFAULT_LOCK_TIMEOUT);
        this.creation.setSearchTimeout(GemFireCacheImpl.DEFAULT_SEARCH_TIMEOUT);
        this.creation.setIsServer(false);
        this.creation.setCopyOnRead(false);
    }

    private void generate(PrintWriter pw) {
        try {
            SAXSource src = new SAXSource(this, new InputSource());
            StreamResult res = new StreamResult(pw);
            TransformerFactory xFactory = TransformerFactory.newInstance();
            Transformer xform = xFactory.newTransformer();
            xform.setOutputProperty("method", "xml");
            xform.setOutputProperty("indent", "yes");
            if (!this.useSchema) {
                xform.setOutputProperty("doctype-system", this.version.getSystemId());
                xform.setOutputProperty("doctype-public", this.version.getPublicId());
            }
            xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xform.transform(src, res);
            pw.flush();
        }
        catch (Exception ex) {
            if (ExceptionUtils.getRootCause((Throwable)ex) instanceof CancelException) {
                throw (CancelException)ExceptionUtils.getRootCause((Throwable)ex);
            }
            throw new RuntimeException("An Exception was thrown while generating XML.", ex);
        }
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        Assert.assertTrue(this.handler != null);
        boolean isClientCache = this.creation instanceof ClientCacheCreation;
        this.handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        if (this.useSchema) {
            if (null == this.version.getSchemaLocation()) {
                throw new IllegalStateException("No schema for version " + this.version.getVersion());
            }
            this.handler.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            XmlGeneratorUtils.addAttribute(atts, "xsi", "schemaLocation", this.version.getNamespace() + " " + this.version.getSchemaLocation());
            this.handler.startPrefixMapping("", this.version.getNamespace());
            XmlGeneratorUtils.addAttribute(atts, "version", this.version.getVersion());
        }
        if (this.creation.hasLockLease()) {
            atts.addAttribute("", "", "lock-lease", "", String.valueOf(this.creation.getLockLease()));
        }
        if (this.creation.hasLockTimeout()) {
            atts.addAttribute("", "", "lock-timeout", "", String.valueOf(this.creation.getLockTimeout()));
        }
        if (this.creation.hasSearchTimeout()) {
            atts.addAttribute("", "", "search-timeout", "", String.valueOf(this.creation.getSearchTimeout()));
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_1) >= 0 && this.creation.hasMessageSyncInterval()) {
            atts.addAttribute("", "", "message-sync-interval", "", String.valueOf(this.creation.getMessageSyncInterval()));
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_4_0) >= 0) {
            if (this.creation.hasServer()) {
                atts.addAttribute("", "", "is-server", "", String.valueOf(this.creation.isServer()));
            }
            if (this.creation.hasCopyOnRead()) {
                atts.addAttribute("", "", "copy-on-read", "", String.valueOf(this.creation.getCopyOnRead()));
            }
        }
        if (isClientCache) {
            this.handler.startElement("", "client-cache", "client-cache", atts);
        } else {
            this.handler.startElement("", "cache", "cache", atts);
        }
        if (this.cache != null) {
            if (!isClientCache) {
                this.generate(this.cache.getCacheTransactionManager());
            } else if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_6) >= 0) {
                this.generate(this.cache.getCacheTransactionManager());
            }
            this.generateDynamicRegionFactory(this.cache);
            if (!isClientCache && this.version.compareTo(CacheXmlVersion.GEMFIRE_7_0) >= 0) {
                Set<GatewaySender> senderSet = this.cache.getGatewaySenders();
                Iterator iterator = senderSet.iterator();
                while (iterator.hasNext()) {
                    GatewaySender gatewaySender = (GatewaySender)iterator.next();
                    this.generateGatewaySender(gatewaySender);
                }
                this.generateGatewayReceiver(this.cache);
                this.generateAsyncEventQueue(this.cache);
            }
            if (!isClientCache && this.version.compareTo(CacheXmlVersion.GEMFIRE_7_0) >= 0 && this.cache.getGatewayConflictResolver() != null) {
                this.generate("gateway-conflict-resolver", this.cache.getGatewayConflictResolver());
            }
            if (!isClientCache) {
                for (CacheServer cacheServer : this.cache.getCacheServers()) {
                    this.generate(cacheServer);
                }
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_7) >= 0) {
                Iterator<Pool> pools = this.cache instanceof GemFireCacheImpl ? PoolManager.getAll().values().iterator() : this.creation.getPools().values().iterator();
                while (pools.hasNext()) {
                    Pool pool = pools.next();
                    this.generate(pool);
                }
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_5) >= 0) {
                if (this.cache instanceof GemFireCacheImpl) {
                    InternalCache gfc = (InternalCache)this.cache;
                    for (DiskStore diskStore : gfc.listDiskStores()) {
                        this.generate(diskStore);
                    }
                } else {
                    for (DiskStore diskStore : this.creation.listDiskStores()) {
                        this.generate(diskStore);
                    }
                }
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_6) >= 0) {
                this.generatePdx();
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_4_1) >= 0) {
                Map namedAttributes = this.cache.listRegionAttributes();
                Iterator iterator = namedAttributes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator.next();
                    String id = entry2.getKey();
                    RegionAttributes attrs = entry2.getValue();
                    if (this.creation instanceof ClientCacheCreation) {
                        try {
                            ClientRegionShortcut.valueOf(id);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    } else {
                        try {
                            RegionShortcut.valueOf(id);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    this.generate(id, attrs);
                }
            }
            if (this.cache instanceof GemFireCacheImpl) {
                this.generateRegions();
            } else {
                TreeSet<Region> rSet = new TreeSet<Region>(new RegionComparator());
                rSet.addAll(this.cache.rootRegions());
                for (Region region : rSet) {
                    this.generateRegion(region);
                }
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_8) >= 0) {
                this.generateFunctionService();
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_0) >= 0) {
                this.generateResourceManager();
                this.generateSerializerRegistration();
            }
            if (!isClientCache && this.version.compareTo(CacheXmlVersion.GEMFIRE_6_5) >= 0) {
                if (this.cache instanceof GemFireCacheImpl) {
                    InternalCache internalCache = (InternalCache)this.cache;
                    for (File file : internalCache.getBackupFiles()) {
                        this.generateBackupFile(file);
                    }
                } else {
                    for (File file : this.creation.getBackupFiles()) {
                        this.generateBackupFile(file);
                    }
                }
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_6) >= 0) {
                this.generateInitializer();
            }
        }
        if (this.cache instanceof Extensible) {
            Extensible extensible = (Extensible)((Object)this.cache);
            this.generate(extensible);
        }
        if (isClientCache) {
            this.handler.endElement("", "client-cache", "client-cache");
        } else {
            this.handler.endElement("", "cache", "cache");
        }
        this.handler.endDocument();
    }

    private void generatePdx() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        CacheConfig config = ((InternalCache)this.cache).getCacheConfig();
        if (config.pdxReadSerializedUserSet && (this.generateDefaults() || this.cache.getPdxReadSerialized())) {
            atts.addAttribute("", "", "read-serialized", "", Boolean.toString(this.cache.getPdxReadSerialized()));
        }
        if (config.pdxIgnoreUnreadFieldsUserSet && (this.generateDefaults() || this.cache.getPdxIgnoreUnreadFields())) {
            atts.addAttribute("", "", "ignore-unread-fields", "", Boolean.toString(this.cache.getPdxIgnoreUnreadFields()));
        }
        if (config.pdxPersistentUserSet && (this.generateDefaults() || this.cache.getPdxPersistent())) {
            atts.addAttribute("", "", "persistent", "", Boolean.toString(this.cache.getPdxPersistent()));
        }
        if (config.pdxDiskStoreUserSet && (this.generateDefaults() || this.cache.getPdxDiskStore() != null && !this.cache.getPdxDiskStore().equals(""))) {
            atts.addAttribute("", "", "disk-store-name", "", this.cache.getPdxDiskStore());
        }
        if (!this.generateDefaults() && this.cache.getPdxSerializer() == null && atts.getLength() == 0) {
            return;
        }
        this.handler.startElement("", "pdx", "pdx", atts);
        if (this.cache.getPdxSerializer() != null) {
            this.generate("pdx-serializer", this.cache.getPdxSerializer());
        }
        this.handler.endElement("", "pdx", "pdx");
    }

    private void generateInitializer() throws SAXException {
        if (this.cache.getInitializer() != null) {
            this.generate(this.cache.getInitializer(), this.cache.getInitializerProps());
        }
    }

    private void generateRegion(Region root) throws SAXException {
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_0) >= 0) {
            this.generate(root, "region");
        } else {
            this.generate(root, "vm-root-region");
        }
    }

    private void generateRegions() throws SAXException {
        HashSet<Region> colocatedChildRegions = new HashSet<Region>();
        HashSet<Region> generatedRegions = new HashSet<Region>();
        TreeSet<Region> rSet = new TreeSet<Region>(new RegionComparator());
        rSet.addAll(this.cache.rootRegions());
        for (Region root : rSet) {
            Assert.assertTrue(root instanceof LocalRegion);
            if (root instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)root;
                if (pr.getColocatedWith() != null) {
                    colocatedChildRegions.add(root);
                    continue;
                }
                this.generateRegion(root);
                generatedRegions.add(root);
                continue;
            }
            boolean found = false;
            for (Region<?, ?> subregion : root.subregions(false)) {
                PartitionedRegion pr;
                Assert.assertTrue(subregion instanceof LocalRegion);
                if (!(subregion instanceof PartitionedRegion) || (pr = (PartitionedRegion)subregion).getColocatedWith() == null) continue;
                colocatedChildRegions.add(root);
                found = true;
                break;
            }
            if (found) continue;
            this.generateRegion(root);
            generatedRegions.add(root);
        }
        TreeSet<Region> rColSet = new TreeSet<Region>(new RegionComparator());
        rColSet.addAll(colocatedChildRegions);
        for (Region root : rColSet) {
            Assert.assertTrue(root instanceof LocalRegion);
            if (root instanceof PartitionedRegion) {
                PartitionedRegion pr = (PartitionedRegion)root;
                PartitionedRegion colocatedWithPr = ColocationHelper.getColocatedRegion(pr);
                if (colocatedWithPr != null && !generatedRegions.contains(colocatedWithPr)) {
                    this.generateRegion(colocatedWithPr);
                    generatedRegions.add(colocatedWithPr);
                }
                if (generatedRegions.contains(root)) continue;
                this.generateRegion(root);
                generatedRegions.add(root);
                continue;
            }
            this.generateRegion(root);
            generatedRegions.add(root);
        }
    }

    private void generateResourceManager() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (this.cache instanceof CacheCreation && this.creation.hasResourceManager()) {
            float ehp;
            float chp;
            boolean generateIt = false;
            if (this.creation.getResourceManager().hasCriticalHeap()) {
                chp = this.creation.getResourceManager().getCriticalHeapPercentage();
                if (this.generateDefaults() || chp != 0.0f) {
                    atts.addAttribute("", "", "critical-heap-percentage", "", String.valueOf(chp));
                    generateIt = true;
                }
            }
            if (this.creation.getResourceManager().hasEvictionHeap()) {
                ehp = this.creation.getResourceManager().getEvictionHeapPercentage();
                if (this.generateDefaults() || ehp != 0.0f) {
                    atts.addAttribute("", "", "eviction-heap-percentage", "", String.valueOf(ehp));
                    generateIt = true;
                }
            }
            if (this.version.compareTo(CacheXmlVersion.GEODE_1_0) >= 0) {
                if (this.creation.getResourceManager().hasCriticalOffHeap()) {
                    chp = this.creation.getResourceManager().getCriticalOffHeapPercentage();
                    if (this.generateDefaults() || chp != 0.0f) {
                        atts.addAttribute("", "", "critical-off-heap-percentage", "", String.valueOf(chp));
                        generateIt = true;
                    }
                }
                if (this.creation.getResourceManager().hasEvictionOffHeap()) {
                    ehp = this.creation.getResourceManager().getEvictionOffHeapPercentage();
                    if (this.generateDefaults() || ehp != 0.0f) {
                        atts.addAttribute("", "", "eviction-off-heap-percentage", "", String.valueOf(ehp));
                        generateIt = true;
                    }
                }
            }
            if (generateIt) {
                this.generateResourceManagerElement(atts);
            }
        } else if (this.cache instanceof GemFireCacheImpl) {
            int chp = (int)this.cache.getResourceManager().getCriticalHeapPercentage();
            if (this.generateDefaults() || (float)chp != 0.0f) {
                atts.addAttribute("", "", "critical-heap-percentage", "", String.valueOf(chp));
            }
            int ehp = (int)this.cache.getResourceManager().getEvictionHeapPercentage();
            if (this.generateDefaults() || (float)ehp != 0.0f) {
                atts.addAttribute("", "", "eviction-heap-percentage", "", String.valueOf(ehp));
            }
            if (this.version.compareTo(CacheXmlVersion.GEODE_1_0) >= 0) {
                chp = (int)this.cache.getResourceManager().getCriticalOffHeapPercentage();
                if (this.generateDefaults() || (float)chp != 0.0f) {
                    atts.addAttribute("", "", "critical-off-heap-percentage", "", String.valueOf(chp));
                }
                ehp = (int)this.cache.getResourceManager().getEvictionOffHeapPercentage();
                if (this.generateDefaults() || (float)ehp != 0.0f) {
                    atts.addAttribute("", "", "eviction-off-heap-percentage", "", String.valueOf(ehp));
                }
            }
            if (this.generateDefaults() || atts.getLength() > 0) {
                this.generateResourceManagerElement(atts);
            }
        }
    }

    private void generateResourceManagerElement(AttributesImpl atts) throws SAXException {
        this.handler.startElement("", "resource-manager", "resource-manager", atts);
        this.handler.endElement("", "resource-manager", "resource-manager");
    }

    private void generateBackupFile(File file) throws SAXException {
        this.handler.startElement("", "backup", "backup", EMPTY);
        this.handler.characters(file.getPath().toCharArray(), 0, file.getPath().length());
        this.handler.endElement("", "backup", "backup");
    }

    private void generateSerializerRegistration() throws SAXException {
        SerializerCreation sc = this.creation.getSerializerCreation();
        if (sc == null) {
            return;
        }
        this.handler.startElement("", "serialization-registration", "serialization-registration", EMPTY);
        for (Class clazz : sc.getSerializerRegistrations()) {
            this.handler.startElement("", "serializer", "serializer", EMPTY);
            this.handler.startElement("", "class-name", "class-name", EMPTY);
            this.handler.characters(clazz.getName().toCharArray(), 0, clazz.getName().length());
            this.handler.endElement("", "class-name", "class-name");
            this.handler.endElement("", "serializer", "serializer");
        }
        for (Map.Entry entry : sc.getInstantiatorRegistrations().entrySet()) {
            Class c = (Class)entry.getKey();
            Integer i = (Integer)entry.getValue();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "id", "", i.toString());
            this.handler.startElement("", "instantiator", "instantiator", atts);
            this.handler.startElement("", "class-name", "class-name", EMPTY);
            this.handler.characters(c.getName().toCharArray(), 0, c.getName().length());
            this.handler.endElement("", "class-name", "class-name");
            this.handler.endElement("", "instantiator", "instantiator");
        }
        this.handler.endElement("", "serialization-registration", "serialization-registration");
    }

    private void generateFunctionService() throws SAXException {
        Collection<Object> functions = Collections.emptyList();
        if (this.cache instanceof CacheCreation) {
            if (this.creation.hasFunctionService()) {
                functions = this.creation.getFunctionServiceCreation().getFunctionList();
            }
        } else {
            functions = FunctionService.getRegisteredFunctions().values();
        }
        if (!this.generateDefaults() && functions.isEmpty()) {
            return;
        }
        this.handler.startElement("", "function-service", "function-service", EMPTY);
        for (Function function : functions) {
            if (!(function instanceof Declarable)) continue;
            this.handler.startElement("", "function", "function", EMPTY);
            this.generate((Declarable)((Object)function), false);
            this.handler.endElement("", "function", "function");
        }
        this.handler.endElement("", "function-service", "function-service");
    }

    private void generateClientHaQueue(CacheServer bridge) {
        AttributesImpl atts = new AttributesImpl();
        ClientSubscriptionConfigImpl csc = (ClientSubscriptionConfigImpl)bridge.getClientSubscriptionConfig();
        try {
            String dsVal;
            atts.addAttribute("", "", "eviction-policy", "", csc.getEvictionPolicy());
            atts.addAttribute("", "", "capacity", "", String.valueOf(csc.getCapacity()));
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_5) >= 0 && (dsVal = csc.getDiskStoreName()) != null) {
                atts.addAttribute("", "", "disk-store-name", "", dsVal);
            }
            if (csc.getDiskStoreName() == null && csc.hasOverflowDirectory()) {
                atts.addAttribute("", "", "overflow-directory", "", csc.getOverflowDirectory());
            }
            this.handler.startElement("", "client-subscription", "client-subscription", atts);
            this.handler.endElement("", "client-subscription", "client-subscription");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(CacheServer bridge) throws SAXException {
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_4_0) < 0) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        try {
            if (this.generateDefaults() || bridge.getPort() != 40404) {
                atts.addAttribute("", "", "port", "", String.valueOf(bridge.getPort()));
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_4_1) < 0) {
                return;
            }
            if (this.generateDefaults() || bridge.getMaximumTimeBetweenPings() != 60000) {
                atts.addAttribute("", "", "maximum-time-between-pings", "", String.valueOf(bridge.getMaximumTimeBetweenPings()));
            }
            if (this.generateDefaults() || !bridge.getNotifyBySubscription()) {
                atts.addAttribute("", "", "notify-by-subscription", "", String.valueOf(bridge.getNotifyBySubscription()));
            }
            if (this.generateDefaults() || bridge.getSocketBufferSize() != 32768) {
                atts.addAttribute("", "", "socket-buffer-size", "", String.valueOf(bridge.getSocketBufferSize()));
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_0) < 0) {
                return;
            }
            if (this.generateDefaults() || bridge.getMaxConnections() != 800) {
                atts.addAttribute("", "", "max-connections", "", String.valueOf(bridge.getMaxConnections()));
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_1) < 0) {
                return;
            }
            if (this.generateDefaults() || bridge.getMaxThreads() != 0) {
                atts.addAttribute("", "", "max-threads", "", String.valueOf(bridge.getMaxThreads()));
            }
            if (this.generateDefaults() || bridge.getMaximumMessageCount() != 230000) {
                atts.addAttribute("", "", "maximum-message-count", "", String.valueOf(bridge.getMaximumMessageCount()));
            }
            if (this.generateDefaults() || bridge.getMessageTimeToLive() != 180) {
                atts.addAttribute("", "", "message-time-to-live", "", String.valueOf(bridge.getMessageTimeToLive()));
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_7) < 0) {
                return;
            }
            if (bridge.getBindAddress() != null && (this.generateDefaults() || !"".equals(bridge.getBindAddress()))) {
                atts.addAttribute("", "", "bind-address", "", bridge.getBindAddress());
            }
            if (bridge.getHostnameForClients() != null && !bridge.getHostnameForClients().equals("")) {
                atts.addAttribute("", "", "hostname-for-clients", "", bridge.getHostnameForClients());
            }
            if (this.generateDefaults() || bridge.getLoadPollInterval() != 5000L) {
                atts.addAttribute("", "", "load-poll-interval", "", String.valueOf(bridge.getLoadPollInterval()));
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_8_0) < 0) {
                return;
            }
            if (this.generateDefaults() || !bridge.getTcpNoDelay()) {
                atts.addAttribute("", "", "tcp-no-delay", "", "" + bridge.getTcpNoDelay());
            }
        }
        finally {
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_7) >= 0) {
                this.handler.startElement("", "cache-server", "cache-server", atts);
            } else {
                this.handler.startElement("", "bridge-server", "bridge-server", atts);
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_7) >= 0) {
                String[] groups = bridge.getGroups();
                if (groups.length > 0) {
                    for (String group : groups) {
                        this.handler.startElement("", "group", "group", EMPTY);
                        this.handler.characters(group.toCharArray(), 0, group.length());
                        this.handler.endElement("", "group", "group");
                    }
                }
                if (!bridge.getClientSubscriptionConfig().getEvictionPolicy().equals("none")) {
                    this.generateClientHaQueue(bridge);
                }
                ServerLoadProbe probe = bridge.getLoadProbe();
                if (this.generateDefaults() || !probe.equals(CacheServer.DEFAULT_LOAD_PROBE)) {
                    this.generate("custom-load-probe", probe);
                }
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_7) >= 0) {
                this.handler.endElement("", "", "cache-server");
            } else {
                this.handler.endElement("", "", "bridge-server");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(DiskStore ds) throws SAXException {
        AttributesImpl atts;
        block19: {
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_5) < 0) {
                return;
            }
            atts = new AttributesImpl();
            try {
                atts.addAttribute("", "", "name", "", ds.getName());
                if (!(ds instanceof DiskStoreAttributesCreation && !((DiskStoreAttributesCreation)ds).hasAutoCompact() || !this.generateDefaults() && ds.getAutoCompact())) {
                    atts.addAttribute("", "", "auto-compact", "", String.valueOf(ds.getAutoCompact()));
                }
                if ((!(ds instanceof DiskStoreAttributesCreation) || ((DiskStoreAttributesCreation)ds).hasAllowForceCompaction()) && (this.generateDefaults() || ds.getAllowForceCompaction())) {
                    atts.addAttribute("", "", "allow-force-compaction", "", String.valueOf(ds.getAllowForceCompaction()));
                }
                if (!(ds instanceof DiskStoreAttributesCreation && !((DiskStoreAttributesCreation)ds).hasCompactionThreshold() || !this.generateDefaults() && ds.getCompactionThreshold() == 50)) {
                    atts.addAttribute("", "", "compaction-threshold", "", String.valueOf(ds.getCompactionThreshold()));
                }
                if (!(ds instanceof DiskStoreAttributesCreation && !((DiskStoreAttributesCreation)ds).hasMaxOplogSize() || !this.generateDefaults() && ds.getMaxOplogSize() == DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE)) {
                    atts.addAttribute("", "", "max-oplog-size", "", String.valueOf(ds.getMaxOplogSize()));
                }
                if (!(ds instanceof DiskStoreAttributesCreation && !((DiskStoreAttributesCreation)ds).hasTimeInterval() || !this.generateDefaults() && ds.getTimeInterval() == 1000L)) {
                    atts.addAttribute("", "", "time-interval", "", String.valueOf(ds.getTimeInterval()));
                }
                if (!(ds instanceof DiskStoreAttributesCreation && !((DiskStoreAttributesCreation)ds).hasWriteBufferSize() || !this.generateDefaults() && ds.getWriteBufferSize() == 32768)) {
                    atts.addAttribute("", "", "write-buffer-size", "", String.valueOf(ds.getWriteBufferSize()));
                }
                if (!(ds instanceof DiskStoreAttributesCreation && !((DiskStoreAttributesCreation)ds).hasQueueSize() || !this.generateDefaults() && ds.getQueueSize() == 0)) {
                    atts.addAttribute("", "", "queue-size", "", String.valueOf(ds.getQueueSize()));
                }
                if (this.version.compareTo(CacheXmlVersion.GEMFIRE_8_0) < 0) break block19;
                if (!(ds instanceof DiskStoreAttributesCreation && !((DiskStoreAttributesCreation)ds).hasDiskUsageWarningPercentage() || !this.generateDefaults() && ds.getDiskUsageWarningPercentage() == 90.0f)) {
                    atts.addAttribute("", "", "disk-usage-warning-percentage", "", String.valueOf(ds.getDiskUsageWarningPercentage()));
                }
                if (ds instanceof DiskStoreAttributesCreation && !((DiskStoreAttributesCreation)ds).hasDiskUsageCriticalPercentage() || !this.generateDefaults() && ds.getDiskUsageCriticalPercentage() == 99.0f) break block19;
                atts.addAttribute("", "", "disk-usage-critical-percentage", "", String.valueOf(ds.getDiskUsageCriticalPercentage()));
            }
            catch (Throwable throwable) {
                this.handler.startElement("", "disk-store", "disk-store", atts);
                if (!(ds instanceof DiskStoreAttributesCreation) || ((DiskStoreAttributesCreation)ds).hasDiskDirs()) {
                    Object[] diskDirs = ds.getDiskDirs();
                    int[] diskSizes = ds.getDiskDirSizes();
                    if (!(diskDirs == null || diskDirs.length <= 0 || !this.generateDefaults() && Arrays.equals(diskDirs, DefaultDiskDirs.getDefaultDiskDirs()) && Arrays.equals(diskSizes, DiskStoreFactory.DEFAULT_DISK_DIR_SIZES))) {
                        this.handler.startElement("", "disk-dirs", "disk-dirs", EMPTY);
                        for (int i = 0; i < diskDirs.length; ++i) {
                            AttributesImpl diskAtts = new AttributesImpl();
                            if (diskSizes[i] != Integer.MAX_VALUE) {
                                diskAtts.addAttribute("", "", "dir-size", "", String.valueOf(diskSizes[i]));
                            }
                            this.handler.startElement("", "disk-dir", "disk-dir", diskAtts);
                            Object dir = diskDirs[i];
                            String name = this.generateDefaults() ? ((File)dir).getAbsolutePath() : ((File)dir).getPath();
                            this.handler.characters(name.toCharArray(), 0, name.length());
                            this.handler.endElement("", "disk-dir", "disk-dir");
                        }
                        this.handler.endElement("", "disk-dirs", "disk-dirs");
                    }
                }
                this.handler.endElement("", "", "disk-store");
                throw throwable;
            }
        }
        this.handler.startElement("", "disk-store", "disk-store", atts);
        if (!(ds instanceof DiskStoreAttributesCreation) || ((DiskStoreAttributesCreation)ds).hasDiskDirs()) {
            Object[] diskDirs = ds.getDiskDirs();
            int[] diskSizes = ds.getDiskDirSizes();
            if (!(diskDirs == null || diskDirs.length <= 0 || !this.generateDefaults() && Arrays.equals(diskDirs, DefaultDiskDirs.getDefaultDiskDirs()) && Arrays.equals(diskSizes, DiskStoreFactory.DEFAULT_DISK_DIR_SIZES))) {
                this.handler.startElement("", "disk-dirs", "disk-dirs", EMPTY);
                for (int i = 0; i < diskDirs.length; ++i) {
                    AttributesImpl diskAtts = new AttributesImpl();
                    if (diskSizes[i] != Integer.MAX_VALUE) {
                        diskAtts.addAttribute("", "", "dir-size", "", String.valueOf(diskSizes[i]));
                    }
                    this.handler.startElement("", "disk-dir", "disk-dir", diskAtts);
                    Object dir = diskDirs[i];
                    String name = this.generateDefaults() ? ((File)dir).getAbsolutePath() : ((File)dir).getPath();
                    this.handler.characters(name.toCharArray(), 0, name.length());
                    this.handler.endElement("", "disk-dir", "disk-dir");
                }
                this.handler.endElement("", "disk-dirs", "disk-dirs");
            }
        }
        this.handler.endElement("", "", "disk-store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(Pool cp) throws SAXException {
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_7) < 0) {
            return;
        }
        if (((PoolImpl)cp).isUsedByGateway()) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        try {
            atts.addAttribute("", "", "name", "", cp.getName());
            if (this.version.compareTo(CacheXmlVersion.GEODE_1_0) >= 0) {
                if (this.generateDefaults() || cp.getSubscriptionTimeoutMultiplier() != 0) {
                    atts.addAttribute("", "", "subscription-timeout-multiplier", "", String.valueOf(cp.getSubscriptionTimeoutMultiplier()));
                }
                if (this.generateDefaults() || cp.getSocketConnectTimeout() != 59000) {
                    atts.addAttribute("", "", "socket-connect-timeout", "", String.valueOf(cp.getSocketConnectTimeout()));
                }
            }
            if (this.generateDefaults() || cp.getFreeConnectionTimeout() != 10000) {
                atts.addAttribute("", "", "free-connection-timeout", "", String.valueOf(cp.getFreeConnectionTimeout()));
            }
            if (this.generateDefaults() || cp.getServerConnectionTimeout() != 0) {
                atts.addAttribute("", "", "server-connection-timeout", "", String.valueOf(cp.getServerConnectionTimeout()));
            }
            if (this.generateDefaults() || cp.getLoadConditioningInterval() != 300000) {
                atts.addAttribute("", "", "load-conditioning-interval", "", String.valueOf(cp.getLoadConditioningInterval()));
            }
            if (this.generateDefaults() || cp.getMinConnections() != 1) {
                atts.addAttribute("", "", "min-connections", "", String.valueOf(cp.getMinConnections()));
            }
            if (this.generateDefaults() || cp.getMaxConnections() != -1) {
                atts.addAttribute("", "", "max-connections", "", String.valueOf(cp.getMaxConnections()));
            }
            if (this.generateDefaults() || cp.getRetryAttempts() != -1) {
                atts.addAttribute("", "", "retry-attempts", "", String.valueOf(cp.getRetryAttempts()));
            }
            if (this.generateDefaults() || cp.getIdleTimeout() != 5000L) {
                atts.addAttribute("", "", "idle-timeout", "", String.valueOf(cp.getIdleTimeout()));
            }
            if (this.generateDefaults() || cp.getPingInterval() != 10000L) {
                atts.addAttribute("", "", "ping-interval", "", String.valueOf(cp.getPingInterval()));
            }
            if (this.generateDefaults() || cp.getStatisticInterval() != -1) {
                atts.addAttribute("", "", "statistic-interval", "", String.valueOf(cp.getStatisticInterval()));
            }
            if (this.generateDefaults() || cp.getSubscriptionAckInterval() != 100) {
                atts.addAttribute("", "", "subscription-ack-interval", "", String.valueOf(cp.getSubscriptionAckInterval()));
            }
            if (this.generateDefaults() || cp.getSubscriptionEnabled()) {
                atts.addAttribute("", "", "subscription-enabled", "", String.valueOf(cp.getSubscriptionEnabled()));
            }
            if (this.generateDefaults() || cp.getSubscriptionMessageTrackingTimeout() != 900000) {
                atts.addAttribute("", "", "subscription-message-tracking-timeout", "", String.valueOf(cp.getSubscriptionMessageTrackingTimeout()));
            }
            if (this.generateDefaults() || cp.getSubscriptionRedundancy() != 0) {
                atts.addAttribute("", "", "subscription-redundancy", "", String.valueOf(cp.getSubscriptionRedundancy()));
            }
            if (this.generateDefaults() || cp.getReadTimeout() != 10000) {
                atts.addAttribute("", "", "read-timeout", "", String.valueOf(cp.getReadTimeout()));
            }
            if (cp.getServerGroup() != null && !cp.getServerGroup().equals("")) {
                atts.addAttribute("", "", "server-group", "", cp.getServerGroup());
            }
            if (this.generateDefaults() || cp.getSocketBufferSize() != 32768) {
                atts.addAttribute("", "", "socket-buffer-size", "", String.valueOf(cp.getSocketBufferSize()));
            }
            if (this.generateDefaults() || cp.getThreadLocalConnections()) {
                atts.addAttribute("", "", "thread-local-connections", "", String.valueOf(cp.getThreadLocalConnections()));
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_1) > 0 && (this.generateDefaults() || !cp.getPRSingleHopEnabled())) {
                atts.addAttribute("", "", "pr-single-hop-enabled", "", String.valueOf(cp.getPRSingleHopEnabled()));
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_1) > 0 && (this.generateDefaults() || cp.getMultiuserAuthentication())) {
                atts.addAttribute("", "", "multiuser-authentication", "", String.valueOf(cp.getMultiuserAuthentication()));
            }
        }
        finally {
            AttributesImpl sAtts;
            this.handler.startElement("", "pool", "pool", atts);
            for (InetSocketAddress addr : cp.getLocators()) {
                sAtts = new AttributesImpl();
                sAtts.addAttribute("", "", "host", "", addr.getHostString());
                sAtts.addAttribute("", "", "port", "", String.valueOf(addr.getPort()));
                this.handler.startElement("", "locator", "locator", sAtts);
                this.handler.endElement("", "locator", "locator");
            }
            for (InetSocketAddress addr : cp.getServers()) {
                sAtts = new AttributesImpl();
                sAtts.addAttribute("", "", "host", "", addr.getHostString());
                sAtts.addAttribute("", "", "port", "", String.valueOf(addr.getPort()));
                this.handler.startElement("", "server", "server", sAtts);
                this.handler.endElement("", "server", "server");
            }
            if (this.version.compareTo(CacheXmlVersion.GEODE_1_0) >= 0 && cp.getSocketFactory() != PoolFactory.DEFAULT_SOCKET_FACTORY) {
                this.generate("socket-factory", cp.getSocketFactory());
            }
            this.handler.endElement("", "", "pool");
        }
    }

    private void generate(CacheTransactionManager txMgr) throws SAXException {
        TransactionListener[] listeners;
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_4_0) < 0) {
            return;
        }
        if (txMgr == null) {
            return;
        }
        if (!this.generateDefaults() && txMgr.getWriter() == null && txMgr.getListeners().length == 0) {
            return;
        }
        this.handler.startElement("", "cache-transaction-manager", "cache-transaction-manager", EMPTY);
        for (TransactionListener listener : listeners = txMgr.getListeners()) {
            this.generate("transaction-listener", listener);
        }
        if (txMgr.getWriter() != null) {
            this.generate("transaction-writer", txMgr.getWriter());
        }
        this.handler.endElement("", "cache-transaction-manager", "cache-transaction-manager");
    }

    private void generateDynamicRegionFactory(Cache c) throws SAXException {
        DynamicRegionFactory.Config cfg;
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_4_1) < 0) {
            return;
        }
        if (c instanceof CacheCreation) {
            cfg = ((CacheCreation)c).getDynamicRegionFactoryConfig();
        } else {
            DynamicRegionFactory drf = DynamicRegionFactory.get();
            if (drf == null || drf.isClosed()) {
                return;
            }
            cfg = drf.getConfig();
        }
        if (cfg == null) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        if (!cfg.getPersistBackup()) {
            atts.addAttribute("", "", "disable-persist-backup", "", "true");
        }
        if (!cfg.getRegisterInterest()) {
            atts.addAttribute("", "", "disable-register-interest", "", "true");
        }
        if (cfg.getPoolName() != null) {
            atts.addAttribute("", "", "pool-name", "", cfg.getPoolName());
        }
        this.handler.startElement("", "dynamic-region-factory", "dynamic-region-factory", atts);
        File dir = cfg.getDiskDir();
        if (dir != null) {
            this.handler.startElement("", "disk-dir", "disk-dir", EMPTY);
            String name = this.generateDefaults() ? dir.getAbsolutePath() : dir.getPath();
            this.handler.characters(name.toCharArray(), 0, name.length());
            this.handler.endElement("", "disk-dir", "disk-dir");
        }
        this.handler.endElement("", "dynamic-region-factory", "dynamic-region-factory");
    }

    private void generateGatewaySender(GatewaySender sender) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "id", "", sender.getId());
        atts.addAttribute("", "", "remote-distributed-system-id", "", String.valueOf(sender.getRemoteDSId()));
        if (this.generateDefaults() || sender.isParallel()) {
            atts.addAttribute("", "", "parallel", "", String.valueOf(sender.isParallel()));
        }
        if (this.generateDefaults() || sender.isManualStart()) {
            atts.addAttribute("", "", "manual-start", "", String.valueOf(sender.isManualStart()));
        }
        if (this.generateDefaults() || sender.getSocketBufferSize() != 524288) {
            atts.addAttribute("", "", "socket-buffer-size", "", String.valueOf(sender.getSocketBufferSize()));
        }
        if (this.generateDefaults() || sender.getSocketReadTimeout() != GatewaySender.DEFAULT_SOCKET_READ_TIMEOUT) {
            atts.addAttribute("", "", "socket-read-timeout", "", String.valueOf(sender.getSocketReadTimeout()));
        }
        if (this.generateDefaults() || sender.isBatchConflationEnabled()) {
            atts.addAttribute("", "", "enable-batch-conflation", "", String.valueOf(sender.isBatchConflationEnabled()));
        }
        if (this.generateDefaults() || sender.getBatchSize() != 100) {
            atts.addAttribute("", "", "batch-size", "", String.valueOf(sender.getBatchSize()));
        }
        if (this.generateDefaults() || sender.getBatchTimeInterval() != 1000) {
            atts.addAttribute("", "", "batch-time-interval", "", String.valueOf(sender.getBatchTimeInterval()));
        }
        if (this.generateDefaults() || sender.isPersistenceEnabled()) {
            atts.addAttribute("", "", "enable-persistence", "", String.valueOf(sender.isPersistenceEnabled()));
        }
        if (this.generateDefaults() || sender.getDiskStoreName() != null && !sender.getDiskStoreName().equals("")) {
            atts.addAttribute("", "", "disk-store-name", "", String.valueOf(sender.getDiskStoreName()));
        }
        if (this.generateDefaults() || !sender.isDiskSynchronous()) {
            atts.addAttribute("", "", "disk-synchronous", "", String.valueOf(sender.isDiskSynchronous()));
        }
        if (this.generateDefaults() || sender.getMaximumQueueMemory() != 100) {
            atts.addAttribute("", "", "maximum-queue-memory", "", String.valueOf(sender.getMaximumQueueMemory()));
        }
        if (this.generateDefaults() || sender.getAlertThreshold() != 0) {
            atts.addAttribute("", "", "alert-threshold", "", String.valueOf(sender.getAlertThreshold()));
        }
        if (this.generateDefaults() || sender.getDispatcherThreads() != 5) {
            atts.addAttribute("", "", "dispatcher-threads", "", String.valueOf(sender.getDispatcherThreads()));
        }
        if (sender.getOrderPolicy() != null && (this.generateDefaults() || !sender.getOrderPolicy().equals((Object)GatewaySender.DEFAULT_ORDER_POLICY))) {
            atts.addAttribute("", "", "order-policy", "", String.valueOf((Object)sender.getOrderPolicy()));
        }
        this.handler.startElement("", "gateway-sender", "gateway-sender", atts);
        for (GatewayEventFilter gef : sender.getGatewayEventFilters()) {
            this.generateGatewayEventFilter(gef);
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_8_0) >= 0 && sender.getGatewayEventSubstitutionFilter() != null) {
            this.generateGatewayEventSubstitutionFilter(sender.getGatewayEventSubstitutionFilter());
        }
        for (GatewayTransportFilter gsf : sender.getGatewayTransportFilters()) {
            this.generateGatewayTransportFilter(gsf);
        }
        this.handler.endElement("", "gateway-sender", "gateway-sender");
    }

    private void generateAsyncEventQueue(Cache cache) throws SAXException {
        Set<AsyncEventQueue> asyncEventQueues = cache.getAsyncEventQueues();
        for (AsyncEventQueue asyncEventQueue : asyncEventQueues) {
            AsyncEventListener asyncListener;
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "id", "", asyncEventQueue.getId());
            if (this.generateDefaults() || asyncEventQueue.isParallel()) {
                atts.addAttribute("", "", "parallel", "", String.valueOf(asyncEventQueue.isParallel()));
            }
            if (this.generateDefaults() || asyncEventQueue.getBatchSize() != 100) {
                atts.addAttribute("", "", "batch-size", "", String.valueOf(asyncEventQueue.getBatchSize()));
            }
            if (this.generateDefaults() || asyncEventQueue.getBatchTimeInterval() != 1000) {
                atts.addAttribute("", "", "batch-time-interval", "", String.valueOf(asyncEventQueue.getBatchTimeInterval()));
            }
            if (this.generateDefaults() || asyncEventQueue.isBatchConflationEnabled()) {
                atts.addAttribute("", "", "enable-batch-conflation", "", String.valueOf(asyncEventQueue.isBatchConflationEnabled()));
            }
            if (this.generateDefaults() || asyncEventQueue.getMaximumQueueMemory() != 100) {
                atts.addAttribute("", "", "maximum-queue-memory", "", String.valueOf(asyncEventQueue.getMaximumQueueMemory()));
            }
            if (this.generateDefaults() || asyncEventQueue.isPersistent()) {
                atts.addAttribute("", "", "persistent", "", String.valueOf(asyncEventQueue.isPersistent()));
            }
            if (asyncEventQueue.isPersistent() && (this.generateDefaults() || asyncEventQueue.getDiskStoreName() != null && !asyncEventQueue.getDiskStoreName().equals(""))) {
                atts.addAttribute("", "", "disk-store-name", "", String.valueOf(asyncEventQueue.getDiskStoreName()));
            }
            if (this.generateDefaults() || asyncEventQueue.getDispatcherThreads() != 5) {
                atts.addAttribute("", "", "dispatcher-threads", "", String.valueOf(asyncEventQueue.getDispatcherThreads()));
            }
            if (asyncEventQueue.getOrderPolicy() != null && (this.generateDefaults() || !asyncEventQueue.getOrderPolicy().equals((Object)GatewaySender.DEFAULT_ORDER_POLICY))) {
                atts.addAttribute("", "", "order-policy", "", String.valueOf((Object)asyncEventQueue.getOrderPolicy()));
            }
            if (this.version.compareTo(CacheXmlVersion.GEODE_1_0) >= 0 && (this.generateDefaults() || asyncEventQueue.isForwardExpirationDestroy())) {
                atts.addAttribute("", "", "forward-expiration-destroy", "", String.valueOf(asyncEventQueue.isForwardExpirationDestroy()));
            }
            if (this.generateDefaults() || !asyncEventQueue.isDiskSynchronous()) {
                atts.addAttribute("", "", "disk-synchronous", "", String.valueOf(asyncEventQueue.isDiskSynchronous()));
            }
            this.handler.startElement("", "async-event-queue", "async-event-queue", atts);
            List<GatewayEventFilter> eventFilters = asyncEventQueue.getGatewayEventFilters();
            if (eventFilters != null) {
                for (GatewayEventFilter eventFilter : eventFilters) {
                    this.generateGatewayEventFilter(eventFilter);
                }
            }
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_8_0) >= 0 && asyncEventQueue.getGatewayEventSubstitutionFilter() != null) {
                this.generateGatewayEventSubstitutionFilter(asyncEventQueue.getGatewayEventSubstitutionFilter());
            }
            if ((asyncListener = asyncEventQueue.getAsyncEventListener()) != null) {
                this.generate("async-event-listener", asyncListener);
            }
            this.handler.endElement("", "async-event-queue", "async-event-queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateGatewayReceiver(Cache cache) throws SAXException {
        Set<GatewayReceiver> receiverList = cache.getGatewayReceivers();
        for (GatewayReceiver receiver : receiverList) {
            AttributesImpl atts = new AttributesImpl();
            try {
                if (this.generateDefaults() || receiver.getHostnameForSenders() != null) {
                    atts.addAttribute("", "", "hostname-for-senders", "", receiver.getHostnameForSenders());
                }
                if (this.generateDefaults() || receiver.getStartPort() != 5000) {
                    atts.addAttribute("", "", "start-port", "", String.valueOf(receiver.getStartPort()));
                }
                if (this.generateDefaults() || receiver.getEndPort() != 5500) {
                    atts.addAttribute("", "", "end-port", "", String.valueOf(receiver.getEndPort()));
                }
                if (this.generateDefaults() || receiver.getBindAddress() != null && !receiver.getBindAddress().equals("")) {
                    atts.addAttribute("", "", "bind-address", "", receiver.getBindAddress());
                }
                if (this.generateDefaults() || receiver.getMaximumTimeBetweenPings() != 60000) {
                    atts.addAttribute("", "", "maximum-time-between-pings", "", String.valueOf(receiver.getMaximumTimeBetweenPings()));
                }
                if (this.generateDefaults() || receiver.getSocketBufferSize() != 524288) {
                    atts.addAttribute("", "", "socket-buffer-size", "", String.valueOf(receiver.getSocketBufferSize()));
                }
                if (this.version.compareTo(CacheXmlVersion.GEMFIRE_8_0) < 0) {
                    return;
                }
                if (!this.generateDefaults() && !receiver.isManualStart()) continue;
                atts.addAttribute("", "", "manual-start", "", String.valueOf(receiver.isManualStart()));
            }
            finally {
                this.handler.startElement("", "gateway-receiver", "gateway-receiver", atts);
                for (GatewayTransportFilter gsf : receiver.getGatewayTransportFilters()) {
                    this.generateGatewayTransportFilter(gsf);
                }
                this.handler.endElement("", "gateway-receiver", "gateway-receiver");
            }
        }
    }

    private void generateGatewayEventFilter(GatewayEventFilter gef) throws SAXException {
        this.handler.startElement("", "gateway-event-filter", "gateway-event-filter", EMPTY);
        String className = gef.getClass().getName();
        this.handler.startElement("", "class-name", "class-name", EMPTY);
        this.handler.characters(className.toCharArray(), 0, className.length());
        this.handler.endElement("", "class-name", "class-name");
        if (gef instanceof Declarable2) {
            Properties props = ((Declarable2)((Object)gef)).getConfig();
            this.generate(props, null);
        }
        this.handler.endElement("", "gateway-event-filter", "gateway-event-filter");
    }

    private void generateGatewayTransportFilter(GatewayTransportFilter gef) throws SAXException {
        this.handler.startElement("", "gateway-transport-filter", "gateway-transport-filter", EMPTY);
        String className = gef.getClass().getName();
        this.handler.startElement("", "class-name", "class-name", EMPTY);
        this.handler.characters(className.toCharArray(), 0, className.length());
        this.handler.endElement("", "class-name", "class-name");
        if (gef instanceof Declarable2) {
            Properties props = ((Declarable2)((Object)gef)).getConfig();
            this.generate(props, null);
        }
        this.handler.endElement("", "gateway-transport-filter", "gateway-transport-filter");
    }

    private void generateGatewayEventSubstitutionFilter(GatewayEventSubstitutionFilter filter) throws SAXException {
        this.handler.startElement("", "gateway-event-substitution-filter", "gateway-event-substitution-filter", EMPTY);
        String className = filter.getClass().getName();
        this.handler.startElement("", "class-name", "class-name", EMPTY);
        this.handler.characters(className.toCharArray(), 0, className.length());
        this.handler.endElement("", "class-name", "class-name");
        if (filter instanceof Declarable2) {
            Properties props = ((Declarable2)((Object)filter)).getConfig();
            this.generate(props, null);
        }
        this.handler.endElement("", "gateway-event-substitution-filter", "gateway-event-substitution-filter");
    }

    private void generate(Region<?, ?> region, String elementName) throws SAXException {
        Region.Entry<?, ?> entry;
        RegionCreation rc;
        Iterator<Region.Entry<?, ?>> refId;
        if (region == null) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "", region.getName());
        if (region instanceof RegionCreation && (refId = (rc = (RegionCreation)region).getRefid()) != null) {
            atts.addAttribute("", "", "refid", "", (String)((Object)refId));
        }
        this.handler.startElement("", elementName, elementName, atts);
        if (region instanceof RegionCreation) {
            rc = (RegionCreation)region;
            if (rc.hasAttributes()) {
                this.generate(null, region.getAttributes());
            }
        } else {
            this.generate(null, region.getAttributes());
        }
        Collection<Index> indexesForRegion = this.cache.getQueryService().getIndexes(region);
        for (Index index : indexesForRegion) {
            this.generate(index);
        }
        if (region instanceof PartitionedRegion) {
            if (this.includeKeysValues && !region.isEmpty()) {
                refId = region.entrySet(false).iterator();
                while (refId.hasNext()) {
                    Region.Entry<?, ?> entry2;
                    entry = entry2 = refId.next();
                    this.generate(entry);
                }
            }
        } else if (this.includeKeysValues) {
            refId = region.entrySet(false).iterator();
            while (refId.hasNext()) {
                Region.Entry<?, ?> entry3;
                entry = entry3 = refId.next();
                this.generate(entry);
            }
        }
        TreeSet<Region> rSet = new TreeSet<Region>(new RegionComparator());
        rSet.addAll(region.subregions(false));
        for (Region subregion : rSet) {
            this.generate(subregion, "region");
        }
        if (region instanceof Extensible) {
            Extensible extensible = (Extensible)((Object)region);
            this.generate(extensible);
        }
        this.handler.endElement("", elementName, elementName);
    }

    private void generate(Region.Entry entry) throws SAXException {
        if (entry == null) {
            return;
        }
        this.handler.startElement("", "entry", "entry", EMPTY);
        this.handler.startElement("", "key", "key", EMPTY);
        this.generate(entry.getKey());
        this.handler.endElement("", "key", "key");
        this.handler.startElement("", "value", "value", EMPTY);
        this.generate(entry.getValue());
        this.handler.endElement("", "value", "value");
        this.handler.endElement("", "entry", "entry");
    }

    private void generate(Index index) throws SAXException {
        if (index == null) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        if (index instanceof IndexCreationData) {
            IndexCreationData indexData = (IndexCreationData)index;
            atts.addAttribute("", "", "name", "", indexData.getIndexName());
            String indexType = indexData.getIndexType();
            if (indexType.equals("KEY")) {
                atts.addAttribute("", "", "key-index", "", "true");
            } else {
                indexType = indexType.equals("HASH") ? "hash" : "range";
                atts.addAttribute("", "", "key-index", "", "false");
                atts.addAttribute("", "", "type", "", "" + indexType);
            }
            atts.addAttribute("", "", "from-clause", "", indexData.getIndexFromClause());
            atts.addAttribute("", "", "expression", "", indexData.getIndexExpression());
        } else {
            atts.addAttribute("", "", "name", "", index.getName());
            if (index instanceof PrimaryKeyIndex) {
                atts.addAttribute("", "", "key-index", "", "true");
            } else {
                atts.addAttribute("", "", "key-index", "", "false");
                String indexType = "range";
                if (index instanceof HashIndex) {
                    indexType = "hash";
                }
                atts.addAttribute("", "", "type", "", "" + indexType);
            }
            atts.addAttribute("", "", "from-clause", "", index.getFromClause());
            atts.addAttribute("", "", "expression", "", index.getIndexedExpression());
        }
        this.handler.startElement("", "index", "index", atts);
        this.handler.endElement("", "index", "index");
    }

    private void generate(String id, RegionAttributes<?, ?> attrs) throws SAXException {
        SubscriptionAttributes sa;
        Object p;
        String refId;
        AttributesImpl atts = new AttributesImpl();
        if (id != null) {
            atts.addAttribute("", "", "id", "", id);
        }
        if (attrs instanceof RegionAttributesCreation && (refId = ((RegionAttributesCreation)attrs).getRefid()) != null) {
            atts.addAttribute("", "", "refid", "", refId);
        }
        if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasScope()) {
            boolean isPartitionedRegion;
            String scopeString;
            Scope scope = attrs.getScope();
            if (scope.equals(Scope.LOCAL)) {
                scopeString = "local";
            } else if (scope.equals(Scope.DISTRIBUTED_NO_ACK)) {
                scopeString = "distributed-no-ack";
            } else if (scope.equals(Scope.DISTRIBUTED_ACK)) {
                scopeString = "distributed-ack";
            } else if (scope.equals(Scope.GLOBAL)) {
                scopeString = "global";
            } else {
                throw new InternalGemFireException(String.format("Unknown scope: %s", scope));
            }
            if (attrs instanceof RegionAttributesCreation) {
                RegionAttributesCreation rac = (RegionAttributesCreation)attrs;
                isPartitionedRegion = rac.getPartitionAttributes() != null || rac.hasDataPolicy() && rac.getDataPolicy().withPartitioning();
            } else {
                boolean bl = isPartitionedRegion = attrs.getPartitionAttributes() != null || attrs.getDataPolicy().withPartitioning();
            }
            if (!(isPartitionedRegion || !this.generateDefaults() && scope.equals(AbstractRegion.DEFAULT_SCOPE))) {
                atts.addAttribute("", "", "scope", "", scopeString);
            }
        }
        if ((!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasEarlyAck()) && (this.generateDefaults() || attrs.getEarlyAck())) {
            atts.addAttribute("", "", "early-ack", "", String.valueOf(attrs.getEarlyAck()));
        }
        if ((!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasMulticastEnabled()) && (this.generateDefaults() || attrs.getMulticastEnabled())) {
            atts.addAttribute("", "", "multicast-enabled", "", String.valueOf(attrs.getMulticastEnabled()));
        }
        if ((!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasPublisher()) && (this.generateDefaults() || attrs.getPublisher())) {
            atts.addAttribute("", "", "publisher", "", String.valueOf(attrs.getPublisher()));
        }
        if ((!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasEnableAsyncConflation()) && (this.generateDefaults() || attrs.getEnableAsyncConflation())) {
            atts.addAttribute("", "", "enable-async-conflation", "", String.valueOf(attrs.getEnableAsyncConflation()));
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_0) >= 0) {
            if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasEnableSubscriptionConflation()) {
                if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_7) >= 0) {
                    if (this.generateDefaults() || attrs.getEnableSubscriptionConflation()) {
                        atts.addAttribute("", "", "enable-subscription-conflation", "", String.valueOf(attrs.getEnableSubscriptionConflation()));
                    }
                } else if (this.generateDefaults() || attrs.getEnableSubscriptionConflation()) {
                    atts.addAttribute("", "", "enable-bridge-conflation", "", String.valueOf(attrs.getEnableSubscriptionConflation()));
                }
            }
            if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasDataPolicy()) {
                String dpString;
                DataPolicy dp = attrs.getDataPolicy();
                if (dp.isEmpty()) {
                    dpString = "empty";
                } else if (dp.isNormal()) {
                    dpString = "normal";
                } else if (dp.isPreloaded()) {
                    dpString = "preloaded";
                } else if (dp.isReplicate()) {
                    dpString = "replicate";
                } else if (dp == DataPolicy.PERSISTENT_REPLICATE) {
                    dpString = "persistent-replicate";
                } else if (dp == DataPolicy.PERSISTENT_PARTITION) {
                    dpString = "persistent-partition";
                } else if (dp.isPartition()) {
                    dpString = this.version.compareTo(CacheXmlVersion.GEMFIRE_5_1) >= 0 ? "partition" : "empty";
                } else {
                    throw new InternalGemFireException(String.format("Unknown data policy: %s", dp));
                }
                if (this.generateDefaults() || !dp.equals(DataPolicy.DEFAULT)) {
                    atts.addAttribute("", "", "data-policy", "", dpString);
                }
            }
        } else {
            if ((!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasEnableSubscriptionConflation()) && (this.generateDefaults() || attrs.getEnableSubscriptionConflation())) {
                atts.addAttribute("", "", "enable-conflation", "", String.valueOf(attrs.getEnableSubscriptionConflation()));
            }
            if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasMirrorType()) {
                String mirrorString;
                MirrorType mirror = attrs.getMirrorType();
                if (mirror.equals(MirrorType.NONE)) {
                    mirrorString = "none";
                } else if (mirror.equals(MirrorType.KEYS)) {
                    mirrorString = "keys";
                } else if (mirror.equals(MirrorType.KEYS_VALUES)) {
                    mirrorString = "keys-values";
                } else {
                    throw new InternalGemFireException(String.format("Unknown mirror type: %s", mirror));
                }
                atts.addAttribute("", "", "mirror-type", "", mirrorString);
            }
            if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasPersistBackup()) {
                atts.addAttribute("", "", "persist-backup", "", String.valueOf(attrs.getDataPolicy() == DataPolicy.PERSISTENT_REPLICATE));
            }
        }
        if (!(attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasInitialCapacity() || !this.generateDefaults() && attrs.getInitialCapacity() == 16)) {
            atts.addAttribute("", "", "initial-capacity", "", String.valueOf(attrs.getInitialCapacity()));
        }
        if (!(attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasLoadFactor() || !this.generateDefaults() && attrs.getLoadFactor() == 0.75f)) {
            atts.addAttribute("", "", "load-factor", "", String.valueOf(attrs.getLoadFactor()));
        }
        if (!(attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasConcurrencyLevel() || !this.generateDefaults() && attrs.getConcurrencyLevel() == 16)) {
            atts.addAttribute("", "", "concurrency-level", "", String.valueOf(attrs.getConcurrencyLevel()));
        }
        if (!(this.version.compareTo(CacheXmlVersion.GEMFIRE_7_0) < 0 || attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasConcurrencyChecksEnabled() || !this.generateDefaults() && attrs.getConcurrencyChecksEnabled())) {
            atts.addAttribute("", "", "concurrency-checks-enabled", "", String.valueOf(attrs.getConcurrencyChecksEnabled()));
        }
        if ((!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasStatisticsEnabled()) && (this.generateDefaults() || attrs.getStatisticsEnabled())) {
            atts.addAttribute("", "", "statistics-enabled", "", String.valueOf(attrs.getStatisticsEnabled()));
        }
        if ((!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasIgnoreJTA()) && (this.generateDefaults() || attrs.getIgnoreJTA())) {
            atts.addAttribute("", "", "ignore-jta", "", String.valueOf(attrs.getIgnoreJTA()));
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_4_0) >= 0 && (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasIsLockGrantor()) && (this.generateDefaults() || attrs.isLockGrantor())) {
            atts.addAttribute("", "", "is-lock-grantor", "", String.valueOf(attrs.isLockGrantor()));
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_7) >= 0 && (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasPoolName())) {
            String cpVal = attrs.getPoolName();
            if (cpVal == null) {
                cpVal = "";
            }
            if (this.generateDefaults() || !cpVal.equals("")) {
                atts.addAttribute("", "", "pool-name", "", cpVal);
            }
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_5) >= 0) {
            String dsVal;
            if ((!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasDiskStoreName()) && (dsVal = attrs.getDiskStoreName()) != null) {
                atts.addAttribute("", "", "disk-store-name", "", dsVal);
            }
            if (!(attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasDiskSynchronous() || !this.generateDefaults() && attrs.isDiskSynchronous())) {
                atts.addAttribute("", "", "disk-synchronous", "", String.valueOf(attrs.isDiskSynchronous()));
            }
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_1) >= 0 && (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasCloningEnabled()) && (this.generateDefaults() || attrs.getCloningEnabled())) {
            atts.addAttribute("", "", "cloning-enabled", "", String.valueOf(attrs.getCloningEnabled()));
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_7_0) >= 0 && (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasGatewaySenderId())) {
            HashSet<String> senderIds = new HashSet<String>(attrs.getGatewaySenderIds());
            StringBuilder senderStringBuff = new StringBuilder();
            if (senderIds.size() != 0) {
                for (String senderId : senderIds) {
                    if (senderStringBuff.length() != 0) {
                        senderStringBuff.append(",");
                    }
                    senderStringBuff.append(senderId);
                }
            }
            if (this.generateDefaults() || senderStringBuff.length() > 0) {
                atts.addAttribute("", "", "gateway-sender-ids", "", senderStringBuff.toString());
            }
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_7_0) >= 0 && (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasAsyncEventListeners())) {
            HashSet<String> asyncEventQueueIds = new HashSet<String>(attrs.getAsyncEventQueueIds());
            StringBuilder asyncEventQueueStringBuff = new StringBuilder();
            if (asyncEventQueueIds.size() != 0) {
                for (String asyncEventQueueId : asyncEventQueueIds) {
                    if (asyncEventQueueStringBuff.length() != 0) {
                        asyncEventQueueStringBuff.append(",");
                    }
                    asyncEventQueueStringBuff.append(asyncEventQueueId);
                }
            }
            if (this.generateDefaults() || asyncEventQueueStringBuff.length() > 0) {
                atts.addAttribute("", "", "async-event-queue-ids", "", asyncEventQueueStringBuff.toString());
            }
        }
        if (this.version.compareTo(CacheXmlVersion.GEODE_1_0) >= 0 && (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasOffHeap()) && (this.generateDefaults() || attrs.getOffHeap())) {
            atts.addAttribute("", "", "off-heap", "", String.valueOf(attrs.getOffHeap()));
        }
        this.handler.startElement("", "region-attributes", "region-attributes", atts);
        if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasKeyConstraint()) {
            this.generate(attrs.getKeyConstraint(), "key-constraint");
        }
        if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasValueConstraint()) {
            this.generate(attrs.getValueConstraint(), "value-constraint");
        }
        if (!(attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasRegionTimeToLive() || !this.generateDefaults() && attrs.getRegionTimeToLive().equals(ExpirationAttributes.DEFAULT))) {
            this.generate("region-time-to-live", attrs.getRegionTimeToLive(), null);
        }
        if (!(attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasRegionIdleTimeout() || !this.generateDefaults() && attrs.getRegionIdleTimeout().equals(ExpirationAttributes.DEFAULT))) {
            this.generate("region-idle-time", attrs.getRegionIdleTimeout(), null);
        }
        if (!(attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasEntryTimeToLive() && !((RegionAttributesCreation)attrs).hasCustomEntryTimeToLive() || !this.generateDefaults() && attrs.getEntryTimeToLive().equals(ExpirationAttributes.DEFAULT) && attrs.getCustomEntryTimeToLive() == null)) {
            this.generate("entry-time-to-live", attrs.getEntryTimeToLive(), attrs.getCustomEntryTimeToLive());
        }
        if (!(attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasEntryIdleTimeout() && !((RegionAttributesCreation)attrs).hasCustomEntryIdleTimeout() || !this.generateDefaults() && attrs.getEntryIdleTimeout().equals(ExpirationAttributes.DEFAULT) && attrs.getCustomEntryIdleTimeout() == null)) {
            this.generate("entry-idle-time", attrs.getEntryIdleTimeout(), attrs.getCustomEntryIdleTimeout());
        }
        if (attrs.getDiskStoreName() == null && (this.generateDefaults() || this.version.compareTo(CacheXmlVersion.GEMFIRE_6_5) < 0)) {
            if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasDiskWriteAttributes()) {
                this.generate(attrs.getDiskWriteAttributes());
            }
            if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasDiskDirs()) {
                File[] diskDirs = attrs.getDiskDirs();
                int[] diskSizes = attrs.getDiskDirSizes();
                if (diskDirs != null && diskDirs.length > 0) {
                    this.handler.startElement("", "disk-dirs", "disk-dirs", EMPTY);
                    for (int i = 0; i < diskDirs.length; ++i) {
                        AttributesImpl diskAtts = new AttributesImpl();
                        if (diskSizes[i] != Integer.MAX_VALUE) {
                            diskAtts.addAttribute("", "", "dir-size", "", String.valueOf(diskSizes[i]));
                        }
                        this.handler.startElement("", "disk-dir", "disk-dir", diskAtts);
                        File dir = diskDirs[i];
                        String name = this.generateDefaults() ? dir.getAbsolutePath() : dir.getPath();
                        this.handler.characters(name.toCharArray(), 0, name.length());
                        this.handler.endElement("", "disk-dir", "disk-dir");
                    }
                    this.handler.endElement("", "disk-dirs", "disk-dirs");
                }
            }
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_0) >= 0 && (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasPartitionAttributes()) && (p = attrs.getPartitionAttributes()) != null) {
            this.generate((PartitionAttributes<?, ?>)p);
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_0) >= 0 && (p = attrs.getMembershipAttributes()) != null && ((MembershipAttributes)p).hasRequiredRoles()) {
            this.generate((MembershipAttributes)p);
        }
        if (!(this.version.compareTo(CacheXmlVersion.GEMFIRE_5_0) < 0 || attrs instanceof RegionAttributesCreation && !((RegionAttributesCreation)attrs).hasSubscriptionAttributes() || (sa = attrs.getSubscriptionAttributes()) == null || !this.generateDefaults() && sa.equals(new SubscriptionAttributes()))) {
            this.generate(sa);
        }
        if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasCacheLoader()) {
            this.generate("cache-loader", attrs.getCacheLoader());
        }
        if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasCacheWriter()) {
            this.generate("cache-writer", attrs.getCacheWriter());
        }
        if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasCacheListeners()) {
            CacheListener<?, ?>[] listeners;
            for (CacheListener<?, ?> listener : listeners = attrs.getCacheListeners()) {
                this.generate("cache-listener", listener);
            }
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_8_0) >= 0 && (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasCompressor())) {
            this.generate("compressor", attrs.getCompressor());
        }
        if (!(attrs instanceof RegionAttributesCreation) || ((RegionAttributesCreation)attrs).hasEvictionAttributes()) {
            this.generate(attrs.getEvictionAttributes());
        }
        this.handler.endElement("", "region-attributes", "region-attributes");
    }

    private void generate(String kind, Object callback) throws SAXException {
        if (callback == null) {
            return;
        }
        this.handler.startElement("", kind, kind, EMPTY);
        String className = callback.getClass().getName();
        this.handler.startElement("", "class-name", "class-name", EMPTY);
        this.handler.characters(className.toCharArray(), 0, className.length());
        this.handler.endElement("", "class-name", "class-name");
        Properties props = null;
        if (callback instanceof Declarable2) {
            props = ((Declarable2)callback).getConfig();
        } else if (callback instanceof ReflectionBasedAutoSerializer) {
            props = ((ReflectionBasedAutoSerializer)callback).getConfig();
        } else if (callback instanceof Declarable && this.cache instanceof GemFireCacheImpl) {
            props = ((InternalCache)this.cache).getDeclarableProperties((Declarable)callback);
        }
        this.generate(props, null);
        this.handler.endElement("", kind, kind);
    }

    private void generate(Declarable d, Properties p) throws SAXException {
        if (d == null) {
            return;
        }
        this.handler.startElement("", "initializer", "initializer", EMPTY);
        String className = d.getClass().getName();
        this.handler.startElement("", "class-name", "class-name", EMPTY);
        this.handler.characters(className.toCharArray(), 0, className.length());
        this.handler.endElement("", "class-name", "class-name");
        this.generate(p, null);
        this.handler.endElement("", "initializer", "initializer");
    }

    private void generate(EvictionAttributes ea) throws SAXException {
        EvictionAction eAction = ea.getAction();
        if (eAction.isNone()) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "action", "", eAction.toString());
        this.handler.startElement("", "eviction-attributes", "eviction-attributes", EMPTY);
        if (ea.getAlgorithm() == EvictionAlgorithm.LRU_ENTRY) {
            atts.addAttribute("", "", "maximum", "", String.valueOf(ea.getMaximum()));
            this.handler.startElement("", "lru-entry-count", "lru-entry-count", atts);
            this.handler.endElement("", "lru-entry-count", "lru-entry-count");
        } else if (ea.getAlgorithm() == EvictionAlgorithm.LRU_MEMORY) {
            atts.addAttribute("", "", "maximum", "", String.valueOf(ea.getMaximum()));
            this.handler.startElement("", "lru-memory-size", "lru-memory-size", atts);
            ObjectSizer os = ea.getObjectSizer();
            if (os != null && os != ObjectSizer.DEFAULT) {
                this.generate((Declarable)((Object)os), false);
            }
            this.handler.endElement("", "lru-memory-size", "lru-memory-size");
        } else if (ea.getAlgorithm() == EvictionAlgorithm.LRU_HEAP) {
            ObjectSizer os;
            this.handler.startElement("", "lru-heap-percentage", "lru-heap-percentage", atts);
            if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_0) >= 0 && !((os = ea.getObjectSizer()) instanceof SizeClassOnceObjectSizer) && os != null) {
                this.generate((Declarable)((Object)os), false);
            }
            this.handler.endElement("", "lru-heap-percentage", "lru-heap-percentage");
        }
        this.handler.endElement("", "eviction-attributes", "eviction-attributes");
    }

    private void generate(String kind, ExpirationAttributes attrs, CustomExpiry custom) throws SAXException {
        String actionString;
        if (attrs == null) {
            return;
        }
        this.handler.startElement("", kind, kind, EMPTY);
        int timeout = attrs.getTimeout();
        ExpirationAction action = attrs.getAction();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "timeout", "", String.valueOf(timeout));
        if (action.equals(ExpirationAction.DESTROY)) {
            actionString = "destroy";
        } else if (action.equals(ExpirationAction.INVALIDATE)) {
            actionString = "invalidate";
        } else if (action.equals(ExpirationAction.LOCAL_DESTROY)) {
            actionString = "local-destroy";
        } else if (action.equals(ExpirationAction.LOCAL_INVALIDATE)) {
            actionString = "local-invalidate";
        } else {
            throw new InternalGemFireException(String.format("Unknown ExpirationAction: %s", action));
        }
        atts.addAttribute("", "", "action", "", actionString);
        this.handler.startElement("", "expiration-attributes", "expiration-attributes", atts);
        if (custom != null) {
            AttributesImpl endAtts = new AttributesImpl();
            this.handler.startElement("", "custom-expiry", "custom-expiry", endAtts);
            this.generate((Declarable)custom, false);
            this.handler.endElement("", "custom-expiry", "custom-expiry");
        }
        this.handler.endElement("", "expiration-attributes", "expiration-attributes");
        this.handler.endElement("", kind, kind);
    }

    private void generate(SubscriptionAttributes attrs) throws SAXException {
        String interestString;
        if (attrs == null) {
            return;
        }
        InterestPolicy ip = attrs.getInterestPolicy();
        AttributesImpl atts = new AttributesImpl();
        if (ip.isAll()) {
            interestString = "all";
        } else if (ip.isCacheContent()) {
            interestString = "cache-content";
        } else {
            throw new InternalGemFireException(String.format("Unknown InterestPolicy: %s", ip));
        }
        atts.addAttribute("", "", "interest-policy", "", interestString);
        this.handler.startElement("", "subscription-attributes", "subscription-attributes", atts);
        this.handler.endElement("", "subscription-attributes", "subscription-attributes");
    }

    private void generate(PartitionAttributes<?, ?> pa) throws SAXException {
        List<FixedPartitionAttributes> staticAttrs;
        PartitionResolver<?, ?> rr;
        AttributesImpl atts = new AttributesImpl();
        if (this.generateDefaults() || pa.getRedundantCopies() != 0) {
            atts.addAttribute("", "", "redundant-copies", "", String.valueOf(pa.getRedundantCopies()));
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_1) >= 0) {
            if (this.generateDefaults() || pa.getLocalMaxMemory() != ((PartitionAttributesImpl)pa).getLocalMaxMemoryDefault()) {
                atts.addAttribute("", "", "local-max-memory", "", String.valueOf(pa.getLocalMaxMemory()));
            }
            if (this.generateDefaults() || pa.getTotalMaxMemory() != Integer.MAX_VALUE) {
                atts.addAttribute("", "", "total-max-memory", "", String.valueOf(pa.getTotalMaxMemory()));
            }
            if (this.generateDefaults() || pa.getTotalNumBuckets() != 113) {
                atts.addAttribute("", "", "total-num-buckets", "", String.valueOf(pa.getTotalNumBuckets()));
            }
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_8) >= 0 && pa.getColocatedWith() != null) {
            atts.addAttribute("", "", "colocated-with", "", pa.getColocatedWith());
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_0) >= 0) {
            if (this.generateDefaults() || pa.getRecoveryDelay() != -1L) {
                atts.addAttribute("", "", "recovery-delay", "", String.valueOf(pa.getRecoveryDelay()));
            }
            if (this.generateDefaults() || pa.getStartupRecoveryDelay() != 0L) {
                atts.addAttribute("", "", "startup-recovery-delay", "", String.valueOf(pa.getStartupRecoveryDelay()));
            }
        }
        if (!this.generateDefaults() && atts.getLength() == 0 && pa.getPartitionResolver() == null && pa.getPartitionListeners().length == 0 && (pa.getFixedPartitionAttributes() == null || pa.getFixedPartitionAttributes().isEmpty())) {
            return;
        }
        this.handler.startElement("", "partition-attributes", "partition-attributes", atts);
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_8) >= 0 && (rr = pa.getPartitionResolver()) != null) {
            this.generate(rr);
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_1) >= 0) {
            PartitionListener[] listeners;
            for (PartitionListener listener : listeners = pa.getPartitionListeners()) {
                if (listener == null) continue;
                this.generate(listener);
            }
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_6_6) >= 0 && (staticAttrs = pa.getFixedPartitionAttributes()) != null) {
            this.generateFixedPartitionAttributes(staticAttrs);
        }
        if (this.version.compareTo(CacheXmlVersion.GEMFIRE_5_1) < 0) {
            Properties p = pa.getLocalProperties();
            this.generate(p, "local-properties");
            p = pa.getGlobalProperties();
            this.generate(p, "global-properties");
        }
        this.handler.endElement("", "partition-attributes", "partition-attributes");
    }

    private void generate(PartitionResolver rr) throws SAXException {
        if (rr == null) {
            return;
        }
        this.handler.startElement("", "partition-resolver", "partition-resolver", EMPTY);
        String className = rr.getClass().getName();
        this.handler.startElement("", "class-name", "class-name", EMPTY);
        this.handler.characters(className.toCharArray(), 0, className.length());
        this.handler.endElement("", "class-name", "class-name");
        if (rr instanceof Declarable2) {
            Properties props = ((Declarable2)((Object)rr)).getConfig();
            this.generate(props, null);
        }
        this.handler.endElement("", "partition-resolver", "partition-resolver");
    }

    private void generate(PartitionListener pl) throws SAXException {
        if (pl == null) {
            return;
        }
        this.handler.startElement("", "partition-listener", "partition-listener", EMPTY);
        String className = pl.getClass().getName();
        this.handler.startElement("", "class-name", "class-name", EMPTY);
        this.handler.characters(className.toCharArray(), 0, className.length());
        this.handler.endElement("", "class-name", "class-name");
        if (pl instanceof Declarable2) {
            Properties props = ((Declarable2)((Object)pl)).getConfig();
            this.generate(props, null);
        }
        this.handler.endElement("", "partition-listener", "partition-listener");
    }

    private void generateFixedPartitionAttributes(List<FixedPartitionAttributes> allStaticAttrs) throws SAXException {
        for (FixedPartitionAttributes attr : allStaticAttrs) {
            AttributesImpl sAtts = new AttributesImpl();
            sAtts.addAttribute("", "", "partition-name", "", attr.getPartitionName());
            sAtts.addAttribute("", "", "is-primary", "", String.valueOf(attr.isPrimary()));
            sAtts.addAttribute("", "", "num-buckets", "", String.valueOf(attr.getNumBuckets()));
            this.handler.startElement("", "fixed-partition-attributes", "fixed-partition-attributes", sAtts);
            this.handler.endElement("", "fixed-partition-attributes", "fixed-partition-attributes");
        }
    }

    private void generate(DiskWriteAttributes dwa) throws SAXException {
        if (dwa == null) {
            return;
        }
        long maxOplogSize = dwa.getMaxOplogSize();
        String maxOplogSizeString = maxOplogSize == (long)DiskWriteAttributesImpl.getDefaultMaxOplogSizeLimit() ? "0" : "" + maxOplogSize;
        AttributesImpl atts = new AttributesImpl();
        if (dwa.isRollOplogs() != DiskWriteAttributesImpl.getDefaultRollOplogsValue()) {
            atts.addAttribute("", "", "roll-oplogs", "", String.valueOf(dwa.isRollOplogs()));
        }
        if (dwa.getMaxOplogSize() != DiskWriteAttributesImpl.getDefaultMaxOplogSize()) {
            atts.addAttribute("", "", "max-oplog-size", "", maxOplogSizeString);
        }
        this.handler.startElement("", "disk-write-attributes", "disk-write-attributes", atts);
        if (dwa.isSynchronous()) {
            this.handler.startElement("", "synchronous-writes", "synchronous-writes", EMPTY);
            this.handler.endElement("", "synchronous-writes", "synchronous-writes");
        } else {
            atts = new AttributesImpl();
            if (dwa.getTimeInterval() != -1L) {
                atts.addAttribute("", "", "time-interval", "", String.valueOf(dwa.getTimeInterval()));
            } else {
                atts.addAttribute("", "", "time-interval", "", "1000");
            }
            atts.addAttribute("", "", "bytes-threshold", "", String.valueOf(dwa.getBytesThreshold()));
            this.handler.startElement("", "asynchronous-writes", "asynchronous-writes", atts);
            this.handler.endElement("", "asynchronous-writes", "asynchronous-writes");
        }
        this.handler.endElement("", "disk-write-attributes", "disk-write-attributes");
    }

    private void generate(MembershipAttributes ra) throws SAXException {
        Set<Role> roles = ra.getRequiredRoles();
        String laction = ra.getLossAction().toString().toLowerCase().replace('_', '-');
        String raction = ra.getResumptionAction().toString().toLowerCase().replace('_', '-');
        AttributesImpl raAtts = new AttributesImpl();
        raAtts.addAttribute("", "", "loss-action", "", laction);
        raAtts.addAttribute("", "", "resumption-action", "", raction);
        this.handler.startElement("", "membership-attributes", "membership-attributes", raAtts);
        Iterator<Role> iterator = roles.iterator();
        while (iterator.hasNext()) {
            Role o;
            Role role = o = iterator.next();
            AttributesImpl roleAtts = new AttributesImpl();
            roleAtts.addAttribute("", "", "name", "", role.getName());
            this.handler.startElement("", "required-role", "required-role", roleAtts);
            this.handler.endElement("", "required-role", "required-role");
        }
        this.handler.endElement("", "membership-attributes", "membership-attributes");
    }

    private void generate(String s) throws SAXException {
        this.handler.startElement("", "string", "string", EMPTY);
        this.handler.characters(s.toCharArray(), 0, s.length());
        this.handler.endElement("", "string", "string");
    }

    private void generate(Declarable d) throws SAXException {
        this.generate(d, true);
    }

    private void generate(Declarable d, boolean includeDeclarable) throws SAXException {
        if (includeDeclarable) {
            this.handler.startElement("", "declarable", "declarable", EMPTY);
        }
        String className = d.getClass().getName();
        this.handler.startElement("", "class-name", "class-name", EMPTY);
        this.handler.characters(className.toCharArray(), 0, className.length());
        this.handler.endElement("", "class-name", "class-name");
        if (d instanceof Declarable2) {
            Properties props = ((Declarable2)d).getConfig();
            this.generate(props, null);
        }
        if (includeDeclarable) {
            this.handler.endElement("", "declarable", "declarable");
        }
    }

    private void generate(Class c, String element) throws SAXException {
        if (c != null) {
            this.handler.startElement("", element, element, EMPTY);
            String className = c.getName();
            this.handler.characters(className.toCharArray(), 0, className.length());
            this.handler.endElement("", element, element);
        }
    }

    private void generate(Object o) throws SAXException {
        if (o instanceof String) {
            this.handler.startElement("", "string", "string", EMPTY);
            String s = (String)o;
            this.handler.characters(s.toCharArray(), 0, s.length());
            this.handler.endElement("", "string", "string");
        } else if (o instanceof Declarable) {
            this.generate((Declarable)o);
        } else if (o == null) {
            this.handler.startElement("", "string", "string", EMPTY);
            String s = "null";
            this.handler.characters(s.toCharArray(), 0, s.length());
            this.handler.endElement("", "string", "string");
        } else {
            this.handler.startElement("", "string", "string", EMPTY);
            String s = o.getClass().getName();
            this.handler.characters(s.toCharArray(), 0, s.length());
            this.handler.endElement("", "string", "string");
        }
    }

    private void generate(Properties props, String elementName) throws SAXException {
        if (props == null || props.isEmpty()) {
            return;
        }
        if (elementName != null) {
            this.handler.startElement("", elementName, elementName, EMPTY);
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "name", "", name);
            this.handler.startElement("", "parameter", "parameter", atts);
            if (value instanceof String) {
                this.generate((String)value);
            } else if (value instanceof Declarable) {
                this.generate((Declarable)value);
            }
            this.handler.endElement("", "parameter", "parameter");
        }
        if (elementName != null) {
            this.handler.endElement("", elementName, elementName);
        }
    }

    private void generate(Extensible<?> extensible) throws SAXException {
        for (Extension<?> extension : extensible.getExtensionPoint().getExtensions()) {
            extension.getXmlGenerator().generate(this);
        }
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this;
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public void parse(String systemId) {
    }

    public static void main(String[] args) throws IOException {
        FileWriter fw = new FileWriter(new File("cache.xml"));
        PrintWriter pw = new PrintWriter(fw);
        CacheXmlGenerator.generateDefault(pw);
        pw.close();
        fw.close();
    }

    static class RegionComparator
    implements Comparator<Region> {
        RegionComparator() {
        }

        @Override
        public int compare(Region o1, Region o2) {
            return o1.getFullPath().compareTo(o2.getFullPath());
        }
    }
}

