/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.InternalFunctionExecutionService;
import org.apache.geode.internal.cache.execute.InternalFunctionExecutionServiceImpl;
import org.apache.geode.internal.cache.execute.MemberFunctionExecutor;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.ExecuteFunction66;
import org.apache.geode.internal.security.SecurityService;

public class ExecuteFunction70
extends ExecuteFunction66 {
    @Immutable
    private static final ExecuteFunction70 singleton = new ExecuteFunction70();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteFunction70() {
    }

    ExecuteFunction70(InternalFunctionExecutionService internalFunctionExecutionService, ExecuteFunction66.ServerToClientFunctionResultSender65Factory serverToClientFunctionResultSender65Factory, ExecuteFunction66.FunctionContextImplFactory functionContextImplFactory) {
        super(internalFunctionExecutionService, serverToClientFunctionResultSender65Factory, functionContextImplFactory);
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        super.cmdExecute(clientMessage, serverConnection, securityService, start);
    }

    @Override
    protected String[] getGroups(Message msg) throws IOException, ClassNotFoundException {
        String[] groups = null;
        Part messagePart = msg.getPart(4);
        if (messagePart != null) {
            groups = (String[])messagePart.getObject();
        }
        return groups;
    }

    @Override
    protected boolean getIgnoreFailedMembers(Message msg) {
        return this.isFlagSet(msg, 1);
    }

    @Override
    protected boolean getAllMembers(Message msg) {
        return this.isFlagSet(msg, 0);
    }

    private boolean isFlagSet(Message msg, int index) {
        byte[] flags;
        boolean isSet = false;
        Part messagePart = msg.getPart(5);
        if (messagePart != null && (flags = messagePart.getSerializedForm()) != null && flags.length > index && flags[index] == 1) {
            isSet = true;
        }
        return isSet;
    }

    @Override
    protected void executeFunctionOnGroups(Object function, Object args, String[] groups, boolean allMembers, Function functionObject, ServerToClientFunctionResultSender resultSender, boolean ignoreFailedMembers) {
        InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
        if (ds == null) {
            throw new IllegalStateException("DistributedSystem is either not created or not ready");
        }
        HashSet<DistributedMember> members = new HashSet<DistributedMember>();
        for (String group : groups) {
            if (allMembers) {
                members.addAll(((DistributedSystem)ds).getGroupMembers(group));
                continue;
            }
            ArrayList<DistributedMember> memberList = new ArrayList<DistributedMember>(((DistributedSystem)ds).getGroupMembers(group));
            if (memberList.isEmpty()) continue;
            if (!InternalFunctionExecutionServiceImpl.RANDOM_onMember && memberList.contains(((DistributedSystem)ds).getDistributedMember())) {
                members.add(((DistributedSystem)ds).getDistributedMember());
                continue;
            }
            Collections.shuffle(memberList);
            members.add((DistributedMember)memberList.get(0));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing Function on Groups: {} all members: {} members are: {}", (Object)Arrays.toString(groups), (Object)allMembers, members);
        }
        Execution execution = new MemberFunctionExecutor(ds, members, resultSender);
        if (args != null) {
            execution = execution.setArguments(args);
        }
        if (ignoreFailedMembers) {
            if (logger.isDebugEnabled()) {
                logger.debug("Function will ignore failed members");
            }
            ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        }
        if (!functionObject.isHA()) {
            ((AbstractExecution)execution).setWaitOnExceptionFlag(true);
        }
        if (function instanceof String) {
            execution.execute(functionObject.getId()).getResult();
        } else {
            execution.execute(functionObject).getResult();
        }
    }
}

