/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.geode.CancelException;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.InterestRegistrationEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class ClientInterestList {
    private static final Logger logger = LogService.getLogger();
    final CacheClientProxy ccp;
    final Object id;
    private final Object interestListLock = new Object();
    protected final Set<String> regions = new HashSet<String>();

    protected ClientInterestList(CacheClientProxy ccp, Object interestID) {
        this.ccp = ccp;
        this.id = interestID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClientInterest(String regionName, Object keyOfInterest, int interestType2, boolean sendUpdatesAsInvalidates) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: registerClientInterest region={} key={}", (Object)this.ccp, (Object)regionName, keyOfInterest);
        }
        Set keysRegistered = null;
        Object object = this.interestListLock;
        synchronized (object) {
            LocalRegion r = (LocalRegion)this.ccp._cache.getRegion(regionName, true);
            if (r == null) {
                throw new RegionDestroyedException("Region could not be found for interest registration", regionName);
            }
            if (!(r instanceof CacheDistributionAdvisee)) {
                throw new IllegalArgumentException("region " + regionName + " is not distributed and does not support interest registration");
            }
            FilterProfile p = r.getFilterProfile();
            keysRegistered = p.registerClientInterest(this.id, keyOfInterest, interestType2, sendUpdatesAsInvalidates);
            this.regions.add(regionName);
        }
        if (keysRegistered != null && this.containsInterestRegistrationListeners() && !keysRegistered.isEmpty()) {
            this.handleInterestEvent(regionName, keysRegistered, interestType2, true);
        }
    }

    protected FilterProfile getProfile(String regionName) {
        try {
            return this.ccp._cache.getFilterProfile(regionName);
        }
        catch (CancelException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterClientInterest(String regionName, Object keyOfInterest, int interestType2) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: unregisterClientInterest region={} key={}", (Object)this.ccp, (Object)regionName, keyOfInterest);
        }
        FilterProfile p = this.getProfile(regionName);
        Set keysUnregistered = null;
        Object object = this.interestListLock;
        synchronized (object) {
            if (p != null) {
                keysUnregistered = p.unregisterClientInterest(this.id, keyOfInterest, interestType2);
                if (!p.hasInterestFor(this.id)) {
                    this.regions.remove(regionName);
                }
            } else {
                this.regions.remove(regionName);
            }
        }
        if (keysUnregistered != null && !keysUnregistered.isEmpty()) {
            this.handleInterestEvent(regionName, keysUnregistered, interestType2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClientInterestList(String regionName, List keysOfInterest, boolean sendUpdatesAsInvalidates) {
        FilterProfile p = this.getProfile(regionName);
        if (p == null) {
            throw new RegionDestroyedException("Region not found during client interest registration", regionName);
        }
        Set keysRegistered = null;
        Object object = this.interestListLock;
        synchronized (object) {
            keysRegistered = p.registerClientInterestList(this.id, keysOfInterest, sendUpdatesAsInvalidates);
            this.regions.add(regionName);
        }
        if (this.containsInterestRegistrationListeners() && !keysRegistered.isEmpty()) {
            this.handleInterestEvent(regionName, keysRegistered, 0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterClientInterestList(String regionName, List keysOfInterest) {
        FilterProfile p = this.getProfile(regionName);
        Set keysUnregistered = null;
        Object object = this.interestListLock;
        synchronized (object) {
            if (p != null) {
                keysUnregistered = p.unregisterClientInterestList(this.id, keysOfInterest);
                if (!p.hasInterestFor(this.id)) {
                    this.regions.remove(regionName);
                }
            } else {
                this.regions.remove(regionName);
            }
        }
        if (!keysUnregistered.isEmpty()) {
            this.handleInterestEvent(regionName, keysUnregistered, 0, false);
        }
    }

    protected boolean hasInterest() {
        return this.regions.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearClientInterestList() {
        boolean isClosed = this.ccp.getCache().isClosed();
        Object object = this.interestListLock;
        synchronized (object) {
            for (String regionName : this.regions) {
                FilterProfile p = this.getProfile(regionName);
                if (p == null) continue;
                if (!isClosed) {
                    Map<String, Pattern> patternsOfInterest;
                    Set keysOfInterest;
                    if (p.hasAllKeysInterestFor(this.id)) {
                        Set<String> allKeys = new HashSet<String>();
                        allKeys.add(".*");
                        allKeys = Collections.unmodifiableSet(allKeys);
                        this.handleInterestEvent(regionName, allKeys, 1, false);
                    }
                    if ((keysOfInterest = p.getKeysOfInterestFor(this.id)) != null && keysOfInterest.size() > 0) {
                        this.handleInterestEvent(regionName, keysOfInterest, 0, false);
                    }
                    if ((patternsOfInterest = p.getPatternsOfInterestFor(this.id)) != null && patternsOfInterest.size() > 0) {
                        this.handleInterestEvent(regionName, patternsOfInterest.keySet(), 1, false);
                    }
                }
                p.clearInterestFor(this.id);
            }
            this.regions.clear();
        }
    }

    private void handleInterestEvent(String regionName, Set keysOfInterest, int interestType2, boolean isRegister) {
        InterestRegistrationEventImpl event = null;
        if (CacheClientProxy.NOTIFY_REGION_ON_INTEREST && this.ccp.isPrimary() && interestType2 == 0) {
            event = new InterestRegistrationEventImpl(this.ccp, regionName, keysOfInterest, interestType2, isRegister);
            try {
                this.notifyRegionOfInterest(event);
            }
            catch (Exception e) {
                logger.warn("Region notification of interest failed", (Throwable)e);
            }
        }
        if (this.containsInterestRegistrationListeners()) {
            if (event == null) {
                event = new InterestRegistrationEventImpl(this.ccp, regionName, keysOfInterest, interestType2, isRegister);
            }
            this.notifyInterestRegistrationListeners(event);
        }
    }

    private void notifyRegionOfInterest(InterestRegistrationEvent event) {
        this.ccp.getCacheClientNotifier().handleInterestEvent(event);
    }

    private void notifyInterestRegistrationListeners(InterestRegistrationEvent event) {
        this.ccp.getCacheClientNotifier().notifyInterestRegistrationListeners(event);
    }

    private boolean containsInterestRegistrationListeners() {
        return this.ccp.getCacheClientNotifier().containsInterestRegistrationListeners();
    }
}

