/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.backup.BackupDefinition;
import org.apache.geode.internal.cache.backup.BackupFileCopier;
import org.apache.geode.internal.cache.backup.BackupWriter;
import org.apache.geode.internal.cache.backup.DiskStoreBackup;
import org.apache.geode.internal.cache.backup.RestoreScript;
import org.apache.geode.internal.cache.backup.TemporaryBackupFiles;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class BackupTask {
    private static final Logger logger = LogService.getLogger();
    private final Map<DiskStoreImpl, DiskStoreBackup> backupByDiskStore = new HashMap<DiskStoreImpl, DiskStoreBackup>();
    private final RestoreScript restoreScript = new RestoreScript();
    private final InternalCache cache;
    private final CountDownLatch allowDestroys = new CountDownLatch(1);
    private final CountDownLatch locksAcquired = new CountDownLatch(1);
    private final CountDownLatch otherMembersReady = new CountDownLatch(1);
    private final HashSet<PersistentID> diskStoresWithData = new HashSet();
    private final BackupWriter backupWriter;
    private volatile boolean isCancelled;
    private TemporaryBackupFiles temporaryFiles;
    private BackupFileCopier fileCopier;

    BackupTask(InternalCache cache, BackupWriter backupWriter) {
        this.cache = cache;
        this.backupWriter = backupWriter;
    }

    HashSet<PersistentID> getPreparedDiskStores() throws InterruptedException {
        this.locksAcquired.await();
        return this.diskStoresWithData;
    }

    void notifyOtherMembersReady() {
        this.otherMembersReady.countDown();
    }

    HashSet<PersistentID> backup() throws InterruptedException, IOException {
        this.prepareForBackup();
        this.locksAcquired.countDown();
        try {
            this.otherMembersReady.await();
        }
        catch (InterruptedException e) {
            this.cleanup();
            throw e;
        }
        if (this.isCancelled) {
            this.cleanup();
            return new HashSet<PersistentID>();
        }
        return this.doBackup();
    }

    private void prepareForBackup() {
        for (DiskStore store : this.cache.listDiskStoresIncludingRegionOwned()) {
            DiskStoreImpl storeImpl = (DiskStoreImpl)store;
            storeImpl.lockStoreBeforeBackup();
            if (logger.isDebugEnabled()) {
                logger.debug("Acquired lock for backup on disk store {}", (Object)store.getName());
            }
            if (!storeImpl.hasPersistedData()) continue;
            this.diskStoresWithData.add(storeImpl.getPersistentID());
            storeImpl.getStats().startBackup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<PersistentID> doBackup() throws IOException {
        if (this.isCancelled) {
            this.cleanup();
            return new HashSet<PersistentID>();
        }
        try {
            Collection<DiskStore> diskStores = this.cache.listDiskStoresIncludingRegionOwned();
            this.temporaryFiles = TemporaryBackupFiles.create();
            this.fileCopier = new BackupFileCopier(this.cache, this.temporaryFiles);
            Map<DiskStoreImpl, DiskStoreBackup> backupByDiskStores = this.startDiskStoreBackups(diskStores);
            this.allowDestroys.countDown();
            HashSet<PersistentID> persistentIds = this.finishDiskStoreBackups(backupByDiskStores);
            if (!backupByDiskStores.isEmpty()) {
                this.backupAdditionalFiles();
                BackupDefinition backupDefinition = this.fileCopier.getBackupDefinition();
                backupDefinition.setRestoreScript(this.restoreScript);
                this.backupWriter.backupFiles(backupDefinition);
            }
            HashSet<PersistentID> hashSet = persistentIds;
            return hashSet;
        }
        finally {
            this.cleanup();
        }
    }

    private HashSet<PersistentID> finishDiskStoreBackups(Map<DiskStoreImpl, DiskStoreBackup> backupByDiskStores) throws IOException {
        HashSet<PersistentID> persistentIds = new HashSet<PersistentID>();
        for (Map.Entry<DiskStoreImpl, DiskStoreBackup> entry : backupByDiskStores.entrySet()) {
            DiskStoreImpl diskStore = entry.getKey();
            this.completeBackup(diskStore, entry.getValue());
            diskStore.getStats().endBackup();
            persistentIds.add(diskStore.getPersistentID());
        }
        return persistentIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<DiskStoreImpl, DiskStoreBackup> startDiskStoreBackups(Collection<DiskStore> diskStores) throws IOException {
        HashMap<DiskStoreImpl, DiskStoreBackup> backupByDiskStore = new HashMap<DiskStoreImpl, DiskStoreBackup>();
        for (DiskStore store : diskStores) {
            DiskStoreImpl diskStore = (DiskStoreImpl)store;
            try {
                if (!diskStore.hasPersistedData()) continue;
                DiskStoreBackup backup = this.startDiskStoreBackup(diskStore);
                backupByDiskStore.put(diskStore, backup);
            }
            finally {
                diskStore.releaseBackupLock();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Released lock for backup on disk store {}", (Object)store.getName());
            }
        }
        return backupByDiskStore;
    }

    void abort() {
        this.isCancelled = true;
        this.otherMembersReady.countDown();
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    void waitTillBackupFilesAreCopiedToTemporaryLocation() {
        try {
            this.allowDestroys.await();
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError(e);
        }
    }

    private void cleanup() {
        this.isCancelled = true;
        this.allowDestroys.countDown();
        if (this.temporaryFiles != null) {
            this.temporaryFiles.cleanupFiles();
        }
        this.releaseBackupLocks();
    }

    private void releaseBackupLocks() {
        for (DiskStore store : this.cache.listDiskStoresIncludingRegionOwned()) {
            ((DiskStoreImpl)store).releaseBackupLock();
        }
    }

    private void backupAdditionalFiles() throws IOException {
        this.fileCopier.copyConfigFiles();
        this.fileCopier.copyUserFiles();
        this.fileCopier.copyDeployedJars();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeBackup(DiskStoreImpl diskStore, DiskStoreBackup backup) throws IOException {
        if (backup == null) {
            return;
        }
        try {
            diskStore.waitForDelayedWrites();
            for (Oplog oplog : backup.getPendingBackup()) {
                if (this.isCancelled()) {
                    break;
                }
                oplog.finishKrf();
                this.fileCopier.copyOplog(diskStore, oplog);
                backup.backupFinished(oplog);
            }
        }
        finally {
            backup.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DiskStoreBackup startDiskStoreBackup(DiskStoreImpl diskStore) throws IOException {
        DiskStoreBackup backup = null;
        boolean done = false;
        try {
            block11: {
                while (true) {
                    Object childLock;
                    Oplog childOplog;
                    if ((childOplog = diskStore.getPersistentOplogSet().getChild()) == null) {
                        backup = new DiskStoreBackup(new Oplog[0]);
                        this.backupByDiskStore.put(diskStore, backup);
                        break block11;
                    }
                    Object object = childLock = childOplog.getLock();
                    synchronized (object) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Synchronized on lock for oplog {} on disk store {}", (Object)childOplog.getOplogId(), (Object)diskStore.getName());
                        }
                        if (diskStore.getPersistentOplogSet().getChild() == childOplog) break;
                    }
                }
                {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Creating snapshot of oplogs for disk store {}", (Object)diskStore.getName());
                    }
                    this.restoreScript.addExistenceTest(diskStore.getDiskInitFile().getIFFile());
                    Oplog[] allOplogs = diskStore.getAllOplogsForBackup();
                    backup = new DiskStoreBackup(allOplogs);
                    this.backupByDiskStore.put(diskStore, backup);
                    this.fileCopier.copyDiskInitFile(diskStore);
                    diskStore.getPersistentOplogSet().forceRoll(null);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Finished backup of disk store {}", (Object)diskStore.getName());
                    }
                }
            }
            done = true;
            return backup;
        }
        finally {
            if (!done && backup != null) {
                this.backupByDiskStore.remove(diskStore);
                backup.cleanup();
            }
        }
    }

    DiskStoreBackup getBackupForDiskStore(DiskStoreImpl diskStore) {
        return this.backupByDiskStore.get(diskStore);
    }
}

