/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionStats;
import org.apache.geode.internal.statistics.StatisticsClock;

class RegionPerfStats
extends CachePerfStats
implements RegionStats {
    private static final String HIT_TAG_VALUE = "hit";
    private static final String MISS_TAG_VALUE = "miss";
    private final CachePerfStats cachePerfStats;
    private final StatisticsClock clock;
    private final MeterRegistry meterRegistry;
    private final Gauge entriesGauge;
    private final Timer cacheGetsHitTimer;
    private final Timer cacheGetsMissTimer;

    RegionPerfStats(StatisticsFactory statisticsFactory, String textId, CachePerfStats cachePerfStats, InternalRegion region, MeterRegistry meterRegistry, StatisticsClock clock) {
        this(statisticsFactory, textId, clock, cachePerfStats, region, meterRegistry);
    }

    @VisibleForTesting
    RegionPerfStats(StatisticsFactory statisticsFactory, String textId, StatisticsClock clock, CachePerfStats cachePerfStats, InternalRegion region, MeterRegistry meterRegistry) {
        this(statisticsFactory, textId, clock, cachePerfStats, region, meterRegistry, RegionPerfStats.registerEntriesGauge(region, meterRegistry), RegionPerfStats.registerCacheGetsTimer(region, meterRegistry, HIT_TAG_VALUE), RegionPerfStats.registerCacheGetsTimer(region, meterRegistry, MISS_TAG_VALUE));
    }

    @VisibleForTesting
    RegionPerfStats(StatisticsFactory statisticsFactory, String textId, StatisticsClock clock, CachePerfStats cachePerfStats, InternalRegion region, MeterRegistry meterRegistry, Gauge entriesGauge, Timer cacheGetsHitTimer, Timer cacheGetsMissTimer) {
        super(statisticsFactory, textId, clock);
        this.clock = clock;
        this.cachePerfStats = cachePerfStats;
        this.meterRegistry = meterRegistry;
        this.entriesGauge = entriesGauge;
        this.cacheGetsHitTimer = cacheGetsHitTimer;
        this.cacheGetsMissTimer = cacheGetsMissTimer;
        this.stats.setLongSupplier(entryCountId, region::getLocalSize);
    }

    @Override
    protected void close() {
        this.meterRegistry.remove((Meter)this.entriesGauge);
        this.entriesGauge.close();
        this.meterRegistry.remove((Meter)this.cacheGetsHitTimer);
        this.cacheGetsHitTimer.close();
        this.meterRegistry.remove((Meter)this.cacheGetsMissTimer);
        this.cacheGetsMissTimer.close();
        super.close();
    }

    @Override
    public void incReliableQueuedOps(int inc) {
        this.stats.incInt(reliableQueuedOpsId, inc);
        this.cachePerfStats.incReliableQueuedOps(inc);
    }

    @Override
    public void incReliableQueueSize(int inc) {
        this.stats.incInt(reliableQueueSizeId, inc);
        this.cachePerfStats.incReliableQueueSize(inc);
    }

    @Override
    public void incReliableQueueMax(int inc) {
        this.stats.incInt(reliableQueueMaxId, inc);
        this.cachePerfStats.incReliableQueueMax(inc);
    }

    @Override
    public void incReliableRegions(int inc) {
        this.stats.incInt(reliableRegionsId, inc);
        this.cachePerfStats.incReliableRegions(inc);
    }

    @Override
    public void incReliableRegionsMissing(int inc) {
        this.stats.incInt(reliableRegionsMissingId, inc);
        this.cachePerfStats.incReliableRegionsMissing(inc);
    }

    @Override
    public void incReliableRegionsQueuing(int inc) {
        this.stats.incInt(reliableRegionsQueuingId, inc);
        this.cachePerfStats.incReliableRegionsQueuing(inc);
    }

    @Override
    public void incReliableRegionsMissingFullAccess(int inc) {
        this.stats.incInt(reliableRegionsMissingFullAccessId, inc);
        this.cachePerfStats.incReliableRegionsMissingFullAccess(inc);
    }

    @Override
    public void incReliableRegionsMissingLimitedAccess(int inc) {
        this.stats.incInt(reliableRegionsMissingLimitedAccessId, inc);
        this.cachePerfStats.incReliableRegionsMissingLimitedAccess(inc);
    }

    @Override
    public void incReliableRegionsMissingNoAccess(int inc) {
        this.stats.incInt(reliableRegionsMissingNoAccessId, inc);
        this.cachePerfStats.incReliableRegionsMissingNoAccess(inc);
    }

    @Override
    public void incQueuedEvents(int inc) {
        this.stats.incLong(eventsQueuedId, (long)inc);
        this.cachePerfStats.incQueuedEvents(inc);
    }

    @Override
    public long startLoad() {
        this.stats.incInt(loadsInProgressId, 1);
        return this.cachePerfStats.startLoad();
    }

    @Override
    public void endLoad(long start) {
        long ts = this.getTime();
        this.stats.incLong(loadTimeId, ts - start);
        this.stats.incInt(loadsInProgressId, -1);
        this.stats.incInt(loadsCompletedId, 1);
        this.cachePerfStats.endLoad(start);
    }

    @Override
    public long startNetload() {
        this.stats.incInt(netloadsInProgressId, 1);
        this.cachePerfStats.startNetload();
        return this.getTime();
    }

    @Override
    public void endNetload(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(netloadTimeId, this.getTime() - start);
        }
        this.stats.incInt(netloadsInProgressId, -1);
        this.stats.incInt(netloadsCompletedId, 1);
        this.cachePerfStats.endNetload(start);
    }

    @Override
    public long startNetsearch() {
        this.stats.incInt(netsearchesInProgressId, 1);
        return this.cachePerfStats.startNetsearch();
    }

    @Override
    public void endNetsearch(long start) {
        long ts = this.getTime();
        this.stats.incLong(netsearchTimeId, ts - start);
        this.stats.incInt(netsearchesInProgressId, -1);
        this.stats.incInt(netsearchesCompletedId, 1);
        this.cachePerfStats.endNetsearch(start);
    }

    @Override
    public long startCacheWriterCall() {
        this.stats.incInt(cacheWriterCallsInProgressId, 1);
        this.cachePerfStats.startCacheWriterCall();
        return this.getTime();
    }

    @Override
    public void endCacheWriterCall(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(cacheWriterCallTimeId, this.getTime() - start);
        }
        this.stats.incInt(cacheWriterCallsInProgressId, -1);
        this.stats.incInt(cacheWriterCallsCompletedId, 1);
        this.cachePerfStats.endCacheWriterCall(start);
    }

    @Override
    public long startCacheListenerCall() {
        this.stats.incInt(cacheListenerCallsInProgressId, 1);
        this.cachePerfStats.startCacheListenerCall();
        return this.getTime();
    }

    @Override
    public void endCacheListenerCall(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(cacheListenerCallTimeId, this.getTime() - start);
        }
        this.stats.incInt(cacheListenerCallsInProgressId, -1);
        this.stats.incInt(cacheListenerCallsCompletedId, 1);
        this.cachePerfStats.endCacheListenerCall(start);
    }

    @Override
    public long startGetInitialImage() {
        this.stats.incInt(getInitialImagesInProgressId, 1);
        this.cachePerfStats.startGetInitialImage();
        return this.getTime();
    }

    @Override
    public void endGetInitialImage(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(getInitialImageTimeId, this.getTime() - start);
        }
        this.stats.incInt(getInitialImagesInProgressId, -1);
        this.stats.incInt(getInitialImagesCompletedId, 1);
        this.cachePerfStats.endGetInitialImage(start);
    }

    @Override
    public void endNoGIIDone(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(getInitialImageTimeId, this.getTime() - start);
        }
        this.stats.incInt(getInitialImagesInProgressId, -1);
        this.cachePerfStats.endNoGIIDone(start);
    }

    @Override
    public void incGetInitialImageKeysReceived() {
        this.stats.incInt(getInitialImageKeysReceivedId, 1);
        this.cachePerfStats.incGetInitialImageKeysReceived();
    }

    @Override
    public long startIndexUpdate() {
        this.stats.incInt(indexUpdateInProgressId, 1);
        this.cachePerfStats.startIndexUpdate();
        return this.getTime();
    }

    @Override
    public void endIndexUpdate(long start) {
        long ts = this.getTime();
        this.stats.incLong(indexUpdateTimeId, ts - start);
        this.stats.incInt(indexUpdateInProgressId, -1);
        this.stats.incInt(indexUpdateCompletedId, 1);
        this.cachePerfStats.endIndexUpdate(start);
    }

    @Override
    public void incRegions(int inc) {
        this.stats.incInt(regionsId, inc);
        this.cachePerfStats.incRegions(inc);
    }

    @Override
    public void incPartitionedRegions(int inc) {
        this.stats.incInt(partitionedRegionsId, inc);
        this.cachePerfStats.incPartitionedRegions(inc);
    }

    @Override
    public void incDestroys() {
        this.stats.incLong(destroysId, 1L);
        this.cachePerfStats.incDestroys();
    }

    @Override
    public void incCreates() {
        this.stats.incLong(createsId, 1L);
        this.cachePerfStats.incCreates();
    }

    @Override
    public void incInvalidates() {
        this.stats.incLong(invalidatesId, 1L);
        this.cachePerfStats.incInvalidates();
    }

    @Override
    public void incTombstoneCount(int amount) {
        this.stats.incInt(tombstoneCountId, amount);
        this.cachePerfStats.incTombstoneCount(amount);
    }

    @Override
    public void incTombstoneGCCount() {
        this.stats.incInt(tombstoneGCCountId, 1);
        this.cachePerfStats.incTombstoneGCCount();
    }

    @Override
    public void incClearTimeouts() {
        this.stats.incInt(clearTimeoutsId, 1);
        this.cachePerfStats.incClearTimeouts();
    }

    @Override
    public void incConflatedEventsCount() {
        this.stats.incLong(conflatedEventsId, 1L);
        this.cachePerfStats.incConflatedEventsCount();
    }

    @Override
    public void endGet(long start, boolean miss) {
        if (this.clock.isEnabled()) {
            long totalNanos = this.getTime() - start;
            this.stats.incLong(getTimeId, totalNanos);
        }
        this.stats.incLong(getsId, 1L);
        if (miss) {
            this.stats.incLong(missesId, 1L);
        }
        this.cachePerfStats.endGet(start, miss);
    }

    @Override
    public void endGetForClient(long start, boolean miss) {
        long totalNanos;
        long l = totalNanos = this.clock.isEnabled() ? this.getTime() - start : 0L;
        if (miss) {
            this.cacheGetsMissTimer.record(totalNanos, TimeUnit.NANOSECONDS);
        } else {
            this.cacheGetsHitTimer.record(totalNanos, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long endPut(long start, boolean isUpdate) {
        long totalNanos = 0L;
        if (isUpdate) {
            this.stats.incLong(updatesId, 1L);
            if (this.clock.isEnabled()) {
                totalNanos = this.getTime() - start;
                this.stats.incLong(updateTimeId, totalNanos);
            }
        } else {
            this.stats.incLong(putsId, 1L);
            if (this.clock.isEnabled()) {
                totalNanos = this.getTime() - start;
                this.stats.incLong(putTimeId, totalNanos);
            }
        }
        this.cachePerfStats.endPut(start, isUpdate);
        return totalNanos;
    }

    @Override
    public void endPutAll(long start) {
        this.stats.incInt(putAllsId, 1);
        if (this.clock.isEnabled()) {
            this.stats.incLong(putAllTimeId, this.getTime() - start);
        }
        this.cachePerfStats.endPutAll(start);
    }

    @Override
    public void endQueryExecution(long executionTime) {
        this.stats.incInt(queryExecutionsId, 1);
        if (this.clock.isEnabled()) {
            this.stats.incLong(queryExecutionTimeId, executionTime);
        }
        this.cachePerfStats.endQueryExecution(executionTime);
    }

    @Override
    public void endQueryResultsHashCollisionProbe(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(queryResultsHashCollisionProbeTimeId, this.getTime() - start);
        }
        this.cachePerfStats.endQueryResultsHashCollisionProbe(start);
    }

    @Override
    public void incQueryResultsHashCollisions() {
        this.stats.incInt(queryResultsHashCollisionsId, 1);
        this.cachePerfStats.incQueryResultsHashCollisions();
    }

    @Override
    public void incTxConflictCheckTime(long delta) {
        this.stats.incLong(txConflictCheckTimeId, delta);
        this.cachePerfStats.incTxConflictCheckTime(delta);
    }

    @Override
    public void txSuccess(long opTime, long txLifeTime, int txChanges) {
        this.stats.incInt(txCommitsId, 1);
        this.stats.incInt(txCommitChangesId, txChanges);
        this.stats.incLong(txCommitTimeId, opTime);
        this.stats.incLong(txSuccessLifeTimeId, txLifeTime);
        this.cachePerfStats.txSuccess(opTime, txLifeTime, txChanges);
    }

    @Override
    public void txFailure(long opTime, long txLifeTime, int txChanges) {
        this.stats.incInt(txFailuresId, 1);
        this.stats.incInt(txFailureChangesId, txChanges);
        this.stats.incLong(txFailureTimeId, opTime);
        this.stats.incLong(txFailedLifeTimeId, txLifeTime);
        this.cachePerfStats.txFailure(opTime, txLifeTime, txChanges);
    }

    @Override
    public void txRollback(long opTime, long txLifeTime, int txChanges) {
        this.stats.incInt(txRollbacksId, 1);
        this.stats.incInt(txRollbackChangesId, txChanges);
        this.stats.incLong(txRollbackTimeId, opTime);
        this.stats.incLong(txRollbackLifeTimeId, txLifeTime);
        this.cachePerfStats.txRollback(opTime, txLifeTime, txChanges);
    }

    @Override
    public void incEventQueueSize(int items) {
        this.stats.incInt(eventQueueSizeId, items);
        this.cachePerfStats.incEventQueueSize(items);
    }

    @Override
    public void incEventQueueThrottleCount(int items) {
        this.stats.incInt(eventQueueThrottleCountId, items);
        this.cachePerfStats.incEventQueueThrottleCount(items);
    }

    @Override
    public void incEventQueueThrottleTime(long nanos) {
        this.stats.incLong(eventQueueThrottleTimeId, nanos);
        this.cachePerfStats.incEventQueueThrottleTime(nanos);
    }

    @Override
    public void incEventThreads(int items) {
        this.stats.incInt(eventThreadsId, items);
        this.cachePerfStats.incEventThreads(items);
    }

    @Override
    public void incEntryCount(int delta) {
        this.cachePerfStats.incEntryCount(delta);
    }

    @Override
    public void incRetries() {
        this.stats.incInt(retriesId, 1);
        this.cachePerfStats.incRetries();
    }

    @Override
    public void incDiskTasksWaiting() {
        this.stats.incInt(diskTasksWaitingId, 1);
        this.cachePerfStats.incDiskTasksWaiting();
    }

    @Override
    public void decDiskTasksWaiting() {
        this.stats.incInt(diskTasksWaitingId, -1);
        this.cachePerfStats.decDiskTasksWaiting();
    }

    @Override
    public void decDiskTasksWaiting(int count) {
        this.stats.incInt(diskTasksWaitingId, -count);
        this.cachePerfStats.decDiskTasksWaiting(count);
    }

    @Override
    public void incEvictorJobsStarted() {
        this.stats.incInt(evictorJobsStartedId, 1);
        this.cachePerfStats.incEvictorJobsStarted();
    }

    @Override
    public void incEvictorJobsCompleted() {
        this.stats.incInt(evictorJobsCompletedId, 1);
        this.cachePerfStats.incEvictorJobsCompleted();
    }

    @Override
    public void incEvictorQueueSize(int delta) {
        this.stats.incInt(evictorQueueSizeId, delta);
        this.cachePerfStats.incEvictorQueueSize(delta);
    }

    @Override
    public void incEvictWorkTime(long delta) {
        this.stats.incLong(evictWorkTimeId, delta);
        this.cachePerfStats.incEvictWorkTime(delta);
    }

    @Override
    public void incClearCount() {
        this.stats.incLong(clearsId, 1L);
        this.cachePerfStats.incClearCount();
    }

    @Override
    public void incPRQueryRetries() {
        this.stats.incLong(partitionedRegionQueryRetriesId, 1L);
        this.cachePerfStats.incPRQueryRetries();
    }

    @Override
    public void incMetaDataRefreshCount() {
        this.stats.incLong(metaDataRefreshCountId, 1L);
        this.cachePerfStats.incMetaDataRefreshCount();
    }

    @Override
    public void endImport(long entryCount, long start) {
        this.stats.incLong(importedEntriesCountId, entryCount);
        if (this.clock.isEnabled()) {
            this.stats.incLong(importTimeId, this.getTime() - start);
        }
        this.cachePerfStats.endImport(entryCount, start);
    }

    @Override
    public void endExport(long entryCount, long start) {
        this.stats.incLong(exportedEntriesCountId, entryCount);
        if (this.clock.isEnabled()) {
            this.stats.incLong(exportTimeId, this.getTime() - start);
        }
        this.cachePerfStats.endExport(entryCount, start);
    }

    @Override
    public long startCompression() {
        this.stats.incLong(compressionCompressionsId, 1L);
        this.cachePerfStats.stats.incLong(compressionCompressionsId, 1L);
        return this.getTime();
    }

    @Override
    public void endCompression(long startTime, long startSize, long endSize) {
        if (this.clock.isEnabled()) {
            long time = this.getTime() - startTime;
            this.stats.incLong(compressionCompressTimeId, time);
            this.cachePerfStats.stats.incLong(compressionCompressTimeId, time);
        }
        this.stats.incLong(compressionPreCompressedBytesId, startSize);
        this.stats.incLong(compressionPostCompressedBytesId, endSize);
        this.cachePerfStats.stats.incLong(compressionPreCompressedBytesId, startSize);
        this.cachePerfStats.stats.incLong(compressionPostCompressedBytesId, endSize);
    }

    @Override
    public long startDecompression() {
        this.stats.incLong(compressionDecompressionsId, 1L);
        this.cachePerfStats.stats.incLong(compressionDecompressionsId, 1L);
        return this.getTime();
    }

    @Override
    public void endDecompression(long startTime) {
        if (this.clock.isEnabled()) {
            long time = this.getTime() - startTime;
            this.stats.incLong(compressionDecompressTimeId, time);
            this.cachePerfStats.stats.incLong(compressionDecompressTimeId, time);
        }
    }

    private static Gauge registerEntriesGauge(InternalRegion region, MeterRegistry meterRegistry) {
        return Gauge.builder((String)"geode.cache.entries", region::getLocalSize).description("Current number of entries in the region.").tag("region", region.getName()).tag("data.policy", region.getDataPolicy().toString()).baseUnit("entries").register(meterRegistry);
    }

    private static Timer registerCacheGetsTimer(InternalRegion region, MeterRegistry meterRegistry, String resultTagValue) {
        return Timer.builder((String)"geode.cache.gets").description("Total time and count for GET requests from Java or native clients.").tag("region", region.getName()).tag("result", resultTagValue).register(meterRegistry);
    }
}

