/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.admin.StatAlertsManager;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ChangeRefreshIntervalMessage
extends PooledDistributionMessage {
    private long _refreshInterval;

    public static ChangeRefreshIntervalMessage create(long refreshInterval) {
        ChangeRefreshIntervalMessage m = new ChangeRefreshIntervalMessage();
        m._refreshInterval = refreshInterval;
        return m;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeLong(this._refreshInterval);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this._refreshInterval = in.readLong();
    }

    public int getDSFID() {
        return 1071;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        StatAlertsManager.getInstance(dm).setRefreshTimeInterval(this.getRefreshInterval());
    }

    public long getRefreshInterval() {
        return this._refreshInterval;
    }

    public void setRefreshInterval(long interval) {
        this._refreshInterval = interval;
    }

    @Override
    public String toString() {
        return "Set alerts refresh time interval in " + InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }
}

