/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.internal.admin.EntrySnapshot;
import org.apache.geode.internal.admin.GemFireVM;

public class CompoundEntrySnapshot
implements EntrySnapshot {
    private static final long serialVersionUID = 5776382582897895718L;
    private Object name;
    private long lastModifiedTime = 0L;
    private long lastAccessTime = 0L;
    private long numHits = 0L;
    private long numMisses = 0L;
    private float hitRatio = 0.0f;
    private long hitResponders = 0L;
    private double hitRatioSum = 0.0;
    private Set allValues = new HashSet();
    private Set allUserAttributes = new HashSet();

    public CompoundEntrySnapshot(Object entryName) {
        this.name = entryName;
    }

    public void addCache(GemFireVM systemEntity, EntrySnapshot snap) {
        float hitRatio;
        long missCount;
        long hitCount;
        long access;
        if (!snap.getName().equals(this.name)) {
            throw new IllegalArgumentException("All snapshots in a compound snapshot must have the same name");
        }
        Object value = snap.getValue();
        if (value != null) {
            this.allValues.add(value.toString());
        } else {
            this.allValues.add("null");
        }
        Object userAttribute = snap.getUserAttribute();
        if (userAttribute != null) {
            this.allUserAttributes.add(userAttribute.toString());
        } else {
            this.allUserAttributes.add("null");
        }
        long modified = snap.getLastModifiedTime();
        if (modified > 0L && modified > this.lastModifiedTime) {
            this.lastModifiedTime = modified;
        }
        if ((access = snap.getLastAccessTime()) > 0L && access > this.lastAccessTime) {
            this.lastAccessTime = access;
        }
        if ((hitCount = snap.getNumberOfHits()) > 0L) {
            this.numHits += hitCount;
        }
        if ((missCount = snap.getNumberOfMisses()) > 0L) {
            this.numMisses += missCount;
        }
        if ((double)(hitRatio = snap.getHitRatio()) >= 0.0) {
            ++this.hitResponders;
            this.hitRatioSum += (double)hitRatio;
            this.hitRatio = (float)(this.hitRatioSum / (double)this.hitResponders);
        }
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public Object getUserAttribute() {
        return null;
    }

    public Iterator getAllValues() {
        return this.allValues.iterator();
    }

    public Iterator getAllUserAttributes() {
        return this.allUserAttributes.iterator();
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getNumberOfHits() {
        return this.numHits;
    }

    @Override
    public long getNumberOfMisses() {
        return this.numMisses;
    }

    @Override
    public float getHitRatio() {
        return this.hitRatio;
    }
}

