/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.deployment.FunctionScanner;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;

public class DeployedJar {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic(value="This object gets updated in the production code")
    private static final MessageDigest messageDigest = DeployedJar.getMessageDigest();
    private static final Pattern PATTERN_SLASH = Pattern.compile("/");
    private final String artifactId;
    private final File file;
    private final byte[] md5hash;
    private final Collection<Function> registeredFunctions = new ArrayList<Function>();

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getVersion() {
        return JarDeployer.extractVersionFromFilename(this.file.getName());
    }

    public DeployedJar(File versionedJarFile) {
        String artifactId = JarDeployer.toArtifactId(versionedJarFile.getName());
        this.file = versionedJarFile;
        this.artifactId = artifactId;
        if (!DeployedJar.hasValidJarContent(versionedJarFile)) {
            throw new IllegalArgumentException("File does not contain valid JAR content: " + versionedJarFile.getAbsolutePath());
        }
        byte[] digest = null;
        try {
            if (messageDigest != null) {
                digest = this.fileDigest(this.file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.md5hash = digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasValidJarContent(File jarFile) {
        ZipInputStream jarInputStream = null;
        boolean valid = false;
        try {
            jarInputStream = new JarInputStream(new FileInputStream(jarFile));
            valid = ((JarInputStream)jarInputStream).getNextJarEntry() != null;
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerFunctions() throws ClassNotFoundException {
        BufferedInputStream bufferedInputStream;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Registering functions with DeployedJar: {}", (Object)this);
        }
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (Exception ex) {
            logger.error("Unable to scan jar file for functions");
            return;
        }
        ZipInputStream jarInputStream = null;
        try {
            Collection<String> functionClasses = this.findFunctionsInThisJar();
            jarInputStream = new JarInputStream(bufferedInputStream);
            JarEntry jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry();
            while (jarEntry != null) {
                if (jarEntry.getName().endsWith(".class")) {
                    String className = PATTERN_SLASH.matcher(jarEntry.getName()).replaceAll("\\.").substring(0, jarEntry.getName().length() - 6);
                    if (functionClasses.contains(className)) {
                        if (isDebugEnabled) {
                            logger.debug("Attempting to load class: {}, from JAR file: {}", (Object)jarEntry.getName(), (Object)this.file.getAbsolutePath());
                        }
                        try {
                            Class<?> clazz = ClassPathLoader.getLatest().forName(className);
                            Collection<Function> registerableFunctions = this.getRegisterableFunctionsFromClass(clazz);
                            for (Function function : registerableFunctions) {
                                FunctionService.registerFunction(function);
                                if (isDebugEnabled) {
                                    logger.debug("Registering function class: {}, from JAR file: {}", (Object)className, (Object)this.file.getAbsolutePath());
                                }
                                this.registeredFunctions.add(function);
                            }
                        }
                        catch (ClassNotFoundException | NoClassDefFoundError cnfex) {
                            logger.error("Unable to load all classes from JAR file: {}", (Object)this.file.getAbsolutePath(), (Object)cnfex);
                            throw cnfex;
                        }
                    } else if (isDebugEnabled) {
                        logger.debug("No functions found in class: {}, from JAR file: {}", (Object)jarEntry.getName(), (Object)this.file.getAbsolutePath());
                    }
                }
                jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry();
            }
        }
        catch (IOException ioex) {
            logger.error("Exception when trying to read class from ByteArrayInputStream", (Throwable)ioex);
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException ioex) {
                    logger.error("Exception attempting to close JAR input stream", (Throwable)ioex);
                }
            }
        }
    }

    protected synchronized void cleanUp(DeployedJar newVersion) {
        Stream<String> removedFunctions;
        Stream<String> oldFunctions = this.registeredFunctions.stream().map(Function::getId);
        if (newVersion == null) {
            removedFunctions = oldFunctions;
        } else {
            Predicate<String> isRemoved = oldFunctionId -> !newVersion.hasFunctionWithId((String)oldFunctionId);
            removedFunctions = oldFunctions.filter(isRemoved);
        }
        removedFunctions.forEach(FunctionService::unregisterFunction);
        this.registeredFunctions.clear();
        try {
            TypeRegistry typeRegistry = ((InternalCache)CacheFactory.getAnyInstance()).getPdxRegistry();
            if (typeRegistry != null) {
                typeRegistry.flushCache();
            }
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
    }

    boolean hasSameContentAs(File stagedFile) {
        byte[] compareToMd5;
        if (messageDigest == null || this.md5hash == null) {
            return false;
        }
        try {
            compareToMd5 = this.fileDigest(stagedFile);
        }
        catch (IOException ex) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("For JAR file: {}, Comparing MD5 hash {} to {}", (Object)this.file.getAbsolutePath(), (Object)new String(this.md5hash), (Object)new String(compareToMd5));
        }
        return Arrays.equals(this.md5hash, compareToMd5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fileDigest(File file) throws IOException {
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));){
            int read;
            byte[] data = new byte[8192];
            while ((read = fis.read(data)) > 0) {
                messageDigest.update(data, 0, read);
            }
        }
        return messageDigest.digest();
    }

    private Collection<Function> getRegisterableFunctionsFromClass(Class<?> clazz) {
        ArrayList<Function> registerableFunctions;
        block8: {
            registerableFunctions = new ArrayList<Function>();
            try {
                Function function;
                if (!Function.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) break block8;
                boolean registerUninitializedFunction = true;
                if (Declarable.class.isAssignableFrom(clazz)) {
                    try {
                        InternalCache cache = (InternalCache)CacheFactory.getAnyInstance();
                        List<Properties> propertiesList = cache.getDeclarableProperties(clazz.getName());
                        if (!propertiesList.isEmpty()) {
                            registerUninitializedFunction = false;
                            for (Properties properties : propertiesList) {
                                Function function2 = this.newFunction(clazz, true);
                                if (function2 == null) continue;
                                ((Declarable)((Object)function2)).initialize(cache, properties);
                                ((Declarable)((Object)function2)).init(properties);
                                if (function2.getId() == null) continue;
                                registerableFunctions.add(function2);
                            }
                        }
                    }
                    catch (CacheClosedException cache) {
                        // empty catch block
                    }
                }
                if (registerUninitializedFunction && (function = this.newFunction(clazz, false)) != null && function.getId() != null) {
                    registerableFunctions.add(function);
                }
            }
            catch (Exception ex) {
                logger.error("Attempting to register function from JAR file: {}", (Object)this.file.getAbsolutePath(), (Object)ex);
            }
        }
        return registerableFunctions;
    }

    protected Collection<String> findFunctionsInThisJar() throws IOException {
        return new FunctionScanner().findFunctionsInJar(this.file);
    }

    private Function newFunction(Class<Function> clazz, boolean errorOnNoSuchMethod) {
        try {
            Constructor<Function> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException nsmex) {
            if (errorOnNoSuchMethod) {
                logger.error("Zero-arg constructor is required, but not found for class: {}", (Object)clazz.getName(), (Object)nsmex);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Not registering function because it doesn't have a zero-arg constructor: {}", (Object)clazz.getName());
            }
        }
        catch (Exception ex) {
            logger.error("Error when attempting constructor for function for class: {}", (Object)clazz.getName(), (Object)ex);
        }
        return null;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getDeployedFileName() {
        String fileBaseName = JarDeployer.getDeployedFileBaseName(this.file.getName());
        if (fileBaseName == null) {
            throw new IllegalStateException("file name needs to have a sequence number");
        }
        return fileBaseName + ".jar";
    }

    public String getFileCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public URL getFileURL() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException e) {
            logger.warn((Object)e);
            return null;
        }
    }

    private boolean hasFunctionWithId(String id) {
        if (CollectionUtils.isEmpty(this.registeredFunctions)) {
            return false;
        }
        return this.registeredFunctions.stream().map(Function::getId).anyMatch(functionId -> functionId.equals(id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeployedJar other = (DeployedJar)obj;
        return !(this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('@').append(System.identityHashCode(this)).append('{');
        sb.append("artifactId=").append(this.artifactId);
        sb.append(",file=").append(this.file.getAbsolutePath());
        sb.append(",md5hash=").append(this.toHex(this.md5hash));
        sb.append(",version=").append(this.getVersion());
        sb.append('}');
        return sb.toString();
    }

    private String toHex(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (byte b : data) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }
}

