/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.DeployJarChildFirstClassLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.util.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassPathLoader {
    private static final Logger logger = LogManager.getLogger();
    static final String EXCLUDE_TCCL_PROPERTY = "gemfire.excludeThreadContextClassLoader";
    @MakeNotStatic
    private static volatile ClassPathLoader latest;
    private final HashMap<String, DeployJarChildFirstClassLoader> artifactIdsToClassLoader = new HashMap();
    private volatile DeployJarChildFirstClassLoader leafLoader;
    private final JarDeployer jarDeployer;
    private final boolean excludeTCCL;

    public ClassPathLoader(boolean excludeTCCL) {
        this.excludeTCCL = excludeTCCL;
        this.jarDeployer = new JarDeployer();
        this.rebuildClassLoaderForDeployedJars();
    }

    public ClassPathLoader(boolean excludeTCCL, File workingDir) {
        this.excludeTCCL = excludeTCCL;
        this.jarDeployer = new JarDeployer(workingDir);
        this.rebuildClassLoaderForDeployedJars();
    }

    @VisibleForTesting
    static ClassPathLoader setLatestToDefault() {
        latest = new ClassPathLoader(Boolean.getBoolean(EXCLUDE_TCCL_PROPERTY));
        return latest;
    }

    public static ClassPathLoader setLatestToDefault(File workingDir) {
        latest = new ClassPathLoader(Boolean.getBoolean(EXCLUDE_TCCL_PROPERTY), workingDir);
        return latest;
    }

    public JarDeployer getJarDeployer() {
        return this.jarDeployer;
    }

    @VisibleForTesting
    static ClassPathLoader createWithDefaults(boolean excludeTCCL) {
        return new ClassPathLoader(excludeTCCL);
    }

    private synchronized void rebuildClassLoaderForDeployedJars() {
        this.leafLoader = null;
        Collection<DeployedJar> deployedJars = this.jarDeployer.getDeployedJars().values();
        for (DeployedJar deployedJar : deployedJars) {
            this.chainClassloader(deployedJar);
        }
    }

    private ClassLoader getLeafLoader() {
        if (this.leafLoader == null) {
            return ClassPathLoader.class.getClassLoader();
        }
        return this.leafLoader;
    }

    synchronized void chainClassloader(DeployedJar jar) {
        this.leafLoader = new DeployJarChildFirstClassLoader(this.artifactIdsToClassLoader, new URL[]{jar.getFileURL()}, jar.getArtifactId(), this.getLeafLoader());
    }

    synchronized void unloadClassloaderForArtifact(String artifactId) {
        this.artifactIdsToClassLoader.put(artifactId, null);
    }

    public URL getResource(String name) {
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("getResource({})", (Object)name);
        }
        for (ClassLoader classLoader : this.getClassLoaders()) {
            if (isTraceEnabled) {
                logger.trace("getResource trying: {}", (Object)classLoader);
            }
            try {
                URL url = classLoader.getResource(name);
                if (url == null) continue;
                if (isTraceEnabled) {
                    logger.trace("getResource found by: {}", (Object)classLoader);
                }
                return url;
            }
            catch (SecurityException securityException) {
            }
        }
        return null;
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> clazz;
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (isTraceEnabled) {
            logger.trace("forName({})", (Object)name);
        }
        if ((clazz = this.forName(name, isTraceEnabled)) != null) {
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> forName(String name, boolean isTraceEnabled) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            if (isTraceEnabled) {
                logger.trace("forName trying: {}", (Object)classLoader);
            }
            try {
                if (classLoader instanceof DeployJarChildFirstClassLoader && ((DeployJarChildFirstClassLoader)classLoader).thisIsOld()) {
                    return null;
                }
                Class<?> clazz = Class.forName(name, true, classLoader);
                if (clazz == null) continue;
                if (isTraceEnabled) {
                    logger.trace("forName found by: {}", (Object)classLoader);
                }
                return clazz;
            }
            catch (ClassNotFoundException | SecurityException exception) {
            }
        }
        return null;
    }

    Class<?> getProxyClass(Class<?> ... classObjs) {
        IllegalArgumentException ex = null;
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                return Proxy.getProxyClass(classLoader, classObjs);
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException iaex) {
                ex = iaex;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("excludeTCCL=").append(this.excludeTCCL);
        sb.append(", jarDeployer=").append(this.jarDeployer);
        sb.append(", classLoaders=[");
        sb.append(this.getClassLoaders().stream().map(Object::toString).collect(Collectors.joining(", ")));
        sb.append("]}");
        return sb.toString();
    }

    public URL getResource(Class<?> contextClass, String name) {
        URL url;
        if (contextClass != null && (url = contextClass.getResource(name)) != null) {
            return url;
        }
        return this.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(Class<?> contextClass, String name) {
        InputStream is;
        if (contextClass != null && (is = contextClass.getResourceAsStream(name)) != null) {
            return is;
        }
        return this.getResourceAsStream(name);
    }

    private Enumeration<URL> getResources(Class<?> contextClass, String name) throws IOException {
        LinkedHashSet urls = new LinkedHashSet();
        if (contextClass != null) {
            CollectionUtils.addAll(urls, contextClass.getClassLoader().getResources(name));
        }
        for (ClassLoader classLoader : this.getClassLoaders()) {
            Enumeration<URL> resources = classLoader.getResources(name);
            if (resources == null || !resources.hasMoreElements()) continue;
            CollectionUtils.addAll(urls, resources);
        }
        return Collections.enumeration(urls);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getResources(null, name);
    }

    private List<ClassLoader> getClassLoaders() {
        ClassLoader tccl;
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        if (!this.excludeTCCL && (tccl = Thread.currentThread().getContextClassLoader()) != null) {
            classLoaders.add(tccl);
        }
        classLoaders.add(this.getLeafLoader());
        return classLoaders;
    }

    public ClassLoader asClassLoader() {
        return new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return ClassPathLoader.this.forName(name);
            }

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                return ClassPathLoader.this.forName(name);
            }

            @Override
            public URL getResource(String name) {
                return ClassPathLoader.this.getResource(name);
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                return ClassPathLoader.this.getResources(name);
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                return ClassPathLoader.this.getResourceAsStream(name);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassPathLoader getLatest() {
        if (latest != null) return latest;
        Class<ClassPathLoader> clazz = ClassPathLoader.class;
        synchronized (ClassPathLoader.class) {
            if (latest != null) return latest;
            ClassPathLoader.setLatestToDefault();
            // ** MonitorExit[var0] (shouldn't be in output)
            return latest;
        }
    }

    public static ClassLoader getLatestAsClassLoader() {
        return ClassPathLoader.getLatest().asClassLoader();
    }
}

