/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import org.apache.geode.InternalGemFireError;

public class Assert {
    private static final boolean debug = Boolean.getBoolean("gemfire.haltOnAssertFailure");

    public static void assertTrue(boolean b) {
        if (!b) {
            Assert.throwError(null);
        }
    }

    public static void fail(Object message) {
        Assert.throwError(message);
    }

    private static void throwError(Object message) {
        if (debug) {
            System.out.flush();
            System.err.println("Assertion failure: " + message);
            try {
                throw new Exception("get Stack trace");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println();
                System.out.flush();
                System.err.println("Waiting for debugger to attach");
                System.err.flush();
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        }
        InternalGemFireError ex = null;
        ex = message != null ? new InternalGemFireError(message) : new InternalGemFireError();
        throw ex;
    }

    public static void assertTrue(boolean b, Object message) {
        if (!b) {
            Assert.throwError(message);
        }
    }

    public static void assertTrue(boolean b, boolean message) {
        if (!b) {
            Assert.throwError(message);
        }
    }

    public static void assertTrue(boolean b, char message) {
        if (!b) {
            Assert.throwError(new Character(message));
        }
    }

    public static void assertTrue(boolean b, int message) {
        if (!b) {
            Assert.throwError(message);
        }
    }

    public static void assertTrue(boolean b, long message) {
        if (!b) {
            Assert.throwError(message);
        }
    }

    public static void assertTrue(boolean b, float message) {
        if (!b) {
            Assert.throwError(new Float(message));
        }
    }

    public static void assertTrue(boolean b, double message) {
        if (!b) {
            Assert.throwError(message);
        }
    }

    public static boolean assertHoldsLock(Object lock, boolean shouldBeHeld) {
        try {
            if (Thread.holdsLock(lock) != shouldBeHeld) {
                Assert.throwError(null);
            }
        }
        catch (NullPointerException jrockitSucks) {
            Assert.assertTrue(lock != null);
        }
        return true;
    }

    public static void assertArgument(boolean valid, String message, Object ... args) {
        if (!valid) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void assertNotNull(Object obj, String message, Object ... args) {
        if (obj == null) {
            throw new NullPointerException(String.format(message, args));
        }
    }

    public static void assertState(boolean valid, String message, Object ... args) {
        if (!valid) {
            throw new IllegalStateException(String.format(message, args));
        }
    }
}

