/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.i18n.AbstractStringIdResourceBundle;

@Deprecated
public class StringId {
    private static final String RESOURCE_CLASS = "org/apache/geode/internal/i18n/StringIdResourceBundle";
    public final int id;
    private final String text;
    @Immutable
    private static final AbstractStringIdResourceBundle rb;
    @Immutable
    private static final Locale currentLocale;
    @Immutable
    private static boolean includeMsgIDs;
    @Immutable
    public static final StringId LITERAL;

    private static AbstractStringIdResourceBundle getBundle(Locale l) {
        return AbstractStringIdResourceBundle.getBundle(RESOURCE_CLASS, l);
    }

    public StringId(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public String getRawText() {
        return this.text;
    }

    public String toString() {
        return MessageFormat.format(this.text, null);
    }

    public String toString(Object ... params) {
        return MessageFormat.format(this.text, params);
    }

    public String toLocalizedString() {
        String idStr = "";
        if (includeMsgIDs) {
            idStr = "msgID " + this.id + ": ";
        }
        return MessageFormat.format(idStr + rb.getString(this), null);
    }

    public String toLocalizedString(Object ... params) {
        String idStr = "";
        if (includeMsgIDs) {
            idStr = "msgID " + this.id + ": ";
        }
        return MessageFormat.format(idStr + rb.getString(this), params);
    }

    static Locale getCurrentLocale() {
        return currentLocale;
    }

    static AbstractStringIdResourceBundle getActiveResourceBundle() {
        return rb;
    }

    static {
        LITERAL = new StringId(1, "{0}");
        Locale locale = Locale.getDefault();
        AbstractStringIdResourceBundle tempResourceBundle = StringId.getBundle(locale);
        currentLocale = locale;
        rb = tempResourceBundle;
        includeMsgIDs = !rb.usingRawMode();
    }
}

