/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.streaming;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.GemFireRethrowable;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.PRQueryTraceInfo;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.PartitionedRegionQueryEvaluator;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.StaticSerialization;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionOrdinal;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class StreamingOperation {
    private static final Logger logger = LogService.getLogger();
    public static final int MSG_OVERHEAD = 200;
    public final InternalDistributedSystem sys;
    @Immutable
    public static final GemFireRethrowable CHUNK_FULL = new GemFireRethrowable();

    public StreamingOperation(InternalDistributedSystem sys) {
        this.sys = sys;
    }

    public void getDataFromAll(Set recipients) throws TimeoutException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (recipients.isEmpty()) {
            return;
        }
        StreamingProcessor processor = new StreamingProcessor(this.sys, recipients);
        DistributionMessage m = this.createRequestMessage(recipients, processor);
        this.sys.getDistributionManager().putOutgoing(m);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (InternalGemFireException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof TimeoutException) {
                throw (TimeoutException)cause;
            }
            throw ex;
        }
        catch (ReplyException e) {
            e.handleCause();
        }
    }

    protected abstract DistributionMessage createRequestMessage(Set var1, ReplyProcessor21 var2);

    public boolean processChunk(List objects, InternalDistributedMember sender, int sequenceNum, boolean lastInSequence) {
        return this.processData(objects, sender, sequenceNum, lastInSequence);
    }

    protected abstract boolean processData(List var1, InternalDistributedMember var2, int var3, boolean var4);

    public static class StreamingReplyMessage
    extends ReplyMessage {
        protected int msgNum;
        protected boolean lastMsg;
        private transient HeapDataOutputStream chunkStream;
        private transient int numObjects;
        private transient List objectList = null;
        private boolean pdxReadSerialized = false;
        private transient boolean isCanceled = false;

        public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, DistributionManager dm, HeapDataOutputStream chunkStream, int numObjects, int msgNum, boolean lastMsg) {
            StreamingReplyMessage.send(recipient, processorId, exception, dm, chunkStream, numObjects, msgNum, lastMsg, false);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplyException exception, DistributionManager dm, HeapDataOutputStream chunkStream, int numObjects, int msgNum, boolean lastMsg, boolean pdxReadSerialized) {
            StreamingReplyMessage replyMessage = new StreamingReplyMessage();
            replyMessage.processorId = processorId;
            if (exception != null) {
                replyMessage.setException(exception);
                logger.debug("Replying with exception: {}", (Object)replyMessage, (Object)exception);
            }
            replyMessage.chunkStream = chunkStream;
            replyMessage.numObjects = numObjects;
            replyMessage.setRecipient(recipient);
            replyMessage.msgNum = msgNum;
            replyMessage.lastMsg = lastMsg;
            replyMessage.pdxReadSerialized = pdxReadSerialized;
            dm.putOutgoing(replyMessage);
        }

        public int getMessageNumber() {
            return this.msgNum;
        }

        public boolean isLastMessage() {
            return this.lastMsg;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public List getObjects() {
            return this.objectList;
        }

        @Override
        public int getDSFID() {
            return -66;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            int n = in.readInt();
            this.msgNum = in.readInt();
            this.lastMsg = in.readBoolean();
            this.pdxReadSerialized = in.readBoolean();
            Version senderVersion = StaticSerialization.getVersionForDataStream((DataInput)in);
            boolean isSenderAbove_8_1 = senderVersion.compareTo((VersionOrdinal)Version.GFE_81) > 0;
            GemFireCacheImpl cache = null;
            Boolean initialPdxReadSerialized = false;
            try {
                cache = GemFireCacheImpl.getForPdx("fromData invocation in StreamingOperation");
                initialPdxReadSerialized = cache.getPdxReadSerializedOverride();
            }
            catch (CacheClosedException e) {
                logger.debug("Cache is closed. PdxReadSerializedOverride set to false");
            }
            if (n == -1) {
                this.objectList = null;
            } else {
                this.numObjects = n;
                this.objectList = new ArrayList(n);
                if (this.pdxReadSerialized && cache != null) {
                    cache.setPdxReadSerializedOverride(true);
                }
                try {
                    ReplyProcessor21 messageProcessor = ReplyProcessor21.getProcessor(this.processorId);
                    boolean isQueryMessageProcessor = messageProcessor instanceof PartitionedRegionQueryEvaluator.StreamingQueryPartitionResponse;
                    ObjectType elementType = null;
                    if (isQueryMessageProcessor) {
                        elementType = ((PartitionedRegionQueryEvaluator.StreamingQueryPartitionResponse)messageProcessor).getResultType();
                    }
                    boolean lowMemoryDetected = false;
                    for (int i = 0; i < n; ++i) {
                        if (DefaultQuery.testHook != null) {
                            DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.BEFORE_ADD_OR_UPDATE_MAPPING_OR_DESERIALIZING_NTH_STREAMINGOPERATION, null, null);
                        }
                        if (isQueryMessageProcessor && QueryMonitor.isLowMemory()) {
                            lowMemoryDetected = true;
                            break;
                        }
                        Object o = DataSerializer.readObject(in);
                        if (isQueryMessageProcessor && elementType != null && elementType.isStructType()) {
                            boolean convertToStruct = isSenderAbove_8_1;
                            if (convertToStruct && i == 0) {
                                boolean bl = convertToStruct = !(o instanceof PRQueryTraceInfo);
                            }
                            if (convertToStruct) {
                                o = new StructImpl((StructTypeImpl)elementType, (Object[])o);
                            }
                        }
                        this.objectList.add(o);
                    }
                    if (lowMemoryDetected) {
                        this.isCanceled = true;
                        if (DefaultQuery.testHook != null) {
                            DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.LOW_MEMORY_WHEN_DESERIALIZING_STREAMINGOPERATION, null, null);
                        }
                    }
                }
                finally {
                    if (this.pdxReadSerialized && cache != null) {
                        cache.setPdxReadSerializedOverride(initialPdxReadSerialized);
                    }
                }
            }
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            if (this.chunkStream == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.numObjects);
            }
            out.writeInt(this.msgNum);
            out.writeBoolean(this.lastMsg);
            out.writeBoolean(this.pdxReadSerialized);
            if (this.chunkStream != null && this.numObjects > 0) {
                this.chunkStream.sendTo(out);
            }
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.getClass().getName());
            buff.append("(processorId=");
            buff.append(this.processorId);
            buff.append(" from ");
            buff.append(this.getSender());
            ReplyException ex = this.getException();
            if (ex != null) {
                buff.append(" with exception ");
                buff.append(ex);
            }
            buff.append(";numObjects=");
            buff.append(this.numObjects);
            buff.append(";msgNum ");
            buff.append(this.msgNum);
            buff.append(";lastMsg=");
            buff.append(this.lastMsg);
            if (this.objectList != null) {
                buff.append(";objectList(size=");
                buff.append(this.objectList.size());
                buff.append(")");
            } else {
                buff.append(";chunkStream=");
                buff.append(this.chunkStream);
            }
            buff.append(")");
            return buff.toString();
        }
    }

    public static abstract class RequestStreamingMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        protected int processorId;

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            Throwable thr = null;
            ReplyException rex = null;
            Object nextObject = null;
            Object failedObject = null;
            int socketBufferSize = dm.getSystem().getConfig().getSocketBufferSize();
            int chunkSize = socketBufferSize - 200;
            HeapDataOutputStream outStream = new HeapDataOutputStream(chunkSize, this.getSender().getVersionObject());
            boolean sentFinalMessage = false;
            boolean receiverCacheClosed = false;
            int msgNum = 0;
            try {
                do {
                    block15: {
                        int numObjectsInChunk = 0;
                        if (failedObject == null) {
                            nextObject = this.getNextReplyObject();
                        } else {
                            nextObject = failedObject;
                            failedObject = null;
                        }
                        if (nextObject != Token.END_OF_STREAM) {
                            numObjectsInChunk = 1;
                            BlobHelper.serializeTo(nextObject, outStream);
                            do {
                                outStream.disallowExpansion(CHUNK_FULL);
                                nextObject = this.getNextReplyObject();
                                if (nextObject == Token.END_OF_STREAM) continue;
                                try {
                                    BlobHelper.serializeTo(nextObject, outStream);
                                    ++numObjectsInChunk;
                                }
                                catch (GemFireRethrowable e) {
                                    failedObject = nextObject;
                                    break;
                                }
                            } while (nextObject != Token.END_OF_STREAM);
                        }
                        try {
                            this.replyWithData(dm, outStream, numObjectsInChunk, msgNum++, nextObject == Token.END_OF_STREAM);
                            if (nextObject != Token.END_OF_STREAM) break block15;
                            sentFinalMessage = true;
                        }
                        catch (CancelException e) {
                            receiverCacheClosed = true;
                            break;
                        }
                    }
                    outStream.reset();
                } while (nextObject != Token.END_OF_STREAM);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                thr = t;
            }
            if (thr != null) {
                rex = new ReplyException(thr);
                this.replyWithException(dm, rex);
            } else if (!sentFinalMessage && !receiverCacheClosed) {
                throw new InternalGemFireError("this should not happen");
            }
        }

        protected abstract Object getNextReplyObject() throws InterruptedException;

        protected void replyWithData(ClusterDistributionManager dm, HeapDataOutputStream outStream, int numObjects, int msgNum, boolean lastMsg) {
            StreamingReplyMessage.send(this.getSender(), this.processorId, null, dm, outStream, numObjects, msgNum, lastMsg);
        }

        protected void replyWithException(ClusterDistributionManager dm, ReplyException rex) {
            StreamingReplyMessage.send(this.getSender(), this.processorId, rex, dm, null, 0, 0, true);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.getClass().getName());
            buff.append("'; sender=");
            buff.append(this.getSender());
            buff.append("; processorId=");
            buff.append(this.processorId);
            buff.append(")");
            return buff.toString();
        }
    }

    public class StreamingProcessor
    extends ReplyProcessor21 {
        protected volatile boolean abort;
        private final Map statusMap;
        protected final AtomicInteger msgsBeingProcessed;
        private volatile boolean finishedWaiting;

        public StreamingProcessor(InternalDistributedSystem system, InternalDistributedMember member) {
            super(system, member);
            this.abort = false;
            this.statusMap = new HashMap();
            this.msgsBeingProcessed = new AtomicInteger();
            this.finishedWaiting = false;
        }

        public StreamingProcessor(InternalDistributedSystem system, Set members) {
            super(system, (Collection)members);
            this.abort = false;
            this.statusMap = new HashMap();
            this.msgsBeingProcessed = new AtomicInteger();
            this.finishedWaiting = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (!this.waitingOnMember(msg.getSender())) {
                return;
            }
            this.msgsBeingProcessed.incrementAndGet();
            try {
                StreamingReplyMessage m = (StreamingReplyMessage)msg;
                boolean isLast = true;
                List objects = m.getObjects();
                if (objects != null) {
                    boolean isAborted = this.abort;
                    if (!isAborted) {
                        boolean bl = isAborted = !StreamingOperation.this.processChunk(objects, m.getSender(), m.msgNum, m.lastMsg);
                        if (isAborted) {
                            this.abort = true;
                        }
                    }
                    isLast = isAborted || this.trackMessage(m);
                } else {
                    isLast = true;
                }
                if (isLast) {
                    super.process(msg, false);
                }
            }
            finally {
                this.msgsBeingProcessed.decrementAndGet();
                this.checkIfDone();
            }
        }

        @Override
        protected boolean stillWaiting() {
            if (this.finishedWaiting) {
                return false;
            }
            if (this.msgsBeingProcessed.get() > 0) {
                return true;
            }
            this.finishedWaiting = this.finishedWaiting || this.abort || !super.stillWaiting();
            return !this.finishedWaiting;
        }

        @Override
        public String toString() {
            return "<" + this.getClass().getName() + " " + this.getProcessorId() + " waiting for " + this.numMembers() + " replies" + (this.exception == null ? "" : " exception: " + this.exception) + " from " + this.membersToString() + "; waiting for " + this.msgsBeingProcessed.get() + " messages in the process of being processed>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean trackMessage(StreamingReplyMessage m) {
            Status status;
            StreamingProcessor streamingProcessor = this;
            synchronized (streamingProcessor) {
                status = (Status)this.statusMap.get(m.getSender());
                if (status == null) {
                    status = new Status();
                    this.statusMap.put(m.getSender(), status);
                }
            }
            return status.trackMessage(m);
        }

        class Status {
            int msgsProcessed = 0;
            int numMsgs = 0;

            Status() {
            }

            protected synchronized boolean trackMessage(StreamingReplyMessage m) {
                ++this.msgsProcessed;
                if (m.lastMsg) {
                    this.numMsgs = m.msgNum + 1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Streaming Message Tracking Status: Processor id: {}; Sender: {}; Messages Processed: {}; NumMsgs: {}", (Object)StreamingProcessor.this.getProcessorId(), (Object)m.getSender(), (Object)this.msgsProcessed, (Object)this.numMsgs);
                }
                return this.msgsProcessed == this.numMsgs;
            }
        }
    }
}

