/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.NWayMergeResults;
import org.apache.geode.cache.query.internal.OrderByComparator;
import org.apache.geode.cache.query.internal.Ordered;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.internal.utils.LimitIterator;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.serialization.BufferDataOutputStream;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class NWayMergeResults<E>
implements SelectResults<E>,
Ordered,
DataSerializableFixedID {
    private CollectionType collectionType;
    private Collection<E> data;
    private boolean isDistinct;

    public NWayMergeResults() {
    }

    public NWayMergeResults(Collection<? extends Collection<E>> sortedResults, boolean isDistinct, int limit, List<CompiledSortCriterion> orderByAttribs, ExecutionContext context, ObjectType elementType) {
        this.isDistinct = isDistinct;
        this.collectionType = new CollectionTypeImpl(Ordered.class, elementType);
        this.data = new NWayMergeResultsCollection(sortedResults, limit, orderByAttribs, context);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("Addition to collection not supported");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Removal from collection not supported");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("Addition to collection not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Removal from collection not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Removal from collection not supported");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Removal from collection not supported");
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public int occurrences(E element) {
        if (this.isDistinct) {
            return this.data.contains(element) ? 1 : 0;
        }
        int count = 0;
        for (E v : this) {
            if (!(element == null ? v == null : element.equals(v))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Set<E> asSet() {
        return new HashSet(this);
    }

    @Override
    public List<E> asList() {
        return new ArrayList(this);
    }

    @Override
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    public void setElementType(ObjectType elementType) {
        throw new UnsupportedOperationException(" not supported");
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        ObjectType elementType = (ObjectType)context.getDeserializer().readObject(in);
        this.collectionType = new CollectionTypeImpl(NWayMergeResults.class, elementType);
        boolean isStruct = elementType.isStructType();
        this.isDistinct = DataSerializer.readPrimitiveBoolean(in);
        long size = in.readLong();
        this.data = new ArrayList((int)size);
        for (long numLeft = size; numLeft > 0L; --numLeft) {
            if (isStruct) {
                Object[] fields = DataSerializer.readObjectArray(in);
                this.data.add(new StructImpl((StructTypeImpl)elementType, fields));
                continue;
            }
            Object element = context.getDeserializer().readObject(in);
            this.data.add(element);
        }
    }

    public int getDSFID() {
        return 167;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        boolean isStruct = this.collectionType.getElementType().isStructType();
        context.getSerializer().writeObject((Object)this.collectionType.getElementType(), out);
        DataSerializer.writePrimitiveBoolean(this.isDistinct, out);
        HeapDataOutputStream hdos = new HeapDataOutputStream(1024, null);
        BufferDataOutputStream.LongUpdater lu = hdos.reserveLong();
        Iterator<E> iter = this.iterator();
        int numElements = 0;
        while (iter.hasNext()) {
            E data = iter.next();
            if (isStruct) {
                Object[] fields = ((Struct)data).getFieldValues();
                DataSerializer.writeObjectArray(fields, hdos);
            } else {
                context.getSerializer().writeObject(data, (DataOutput)hdos);
            }
            ++numElements;
        }
        lu.update((long)numElements);
        hdos.sendTo(out);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NWayMergeResults:: isDistinct=" + this.isDistinct).append(":");
        builder.append('[');
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next()).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(']');
        return builder.toString();
    }

    @Override
    public Comparator comparator() {
        if (this.data instanceof NWayMergeResultsCollection) {
            return ((NWayMergeResultsCollection)this.data).comparator;
        }
        return null;
    }

    @Override
    public boolean dataPreordered() {
        return !(this.data instanceof NWayMergeResultsCollection);
    }

    private class NWayMergeResultsCollection
    extends AbstractCollection<E> {
        private final Collection<? extends Collection<E>> sortedResults;
        private final OrderByComparator comparator;
        private final int limit;

        public NWayMergeResultsCollection(Collection<? extends Collection<E>> sortedResults, int limit, List<CompiledSortCriterion> orderByAttribs, ExecutionContext context) {
            this.sortedResults = sortedResults;
            this.limit = limit;
            this.comparator = new OrderByComparator(orderByAttribs, NWayMergeResults.this.collectionType.getElementType(), context);
        }

        @Override
        public int size() {
            if (NWayMergeResults.this.isDistinct) {
                Iterator iter = this.iterator();
                int count = 0;
                while (iter.hasNext()) {
                    ++count;
                    iter.next();
                }
                return count;
            }
            int totalSize = 0;
            for (Collection result : this.sortedResults) {
                totalSize += result.size();
            }
            if (this.limit >= 0) {
                return totalSize > this.limit ? this.limit : totalSize;
            }
            return totalSize;
        }

        @Override
        public Iterator<E> iterator() {
            Iterator iter = NWayMergeResults.this.isDistinct ? new NWayMergeDistinctIterator() : new NWayMergeIterator();
            if (this.limit > -1) {
                iter = new LimitIterator(iter, this.limit);
            }
            return iter;
        }

        /*
         * Signature claims super is org.apache.geode.cache.query.internal.NWayMergeResults$NWayMergeResultsCollection.NWayMergeIterator, not org.apache.geode.cache.query.internal.NWayMergeResults$NWayMergeResultsCollection$NWayMergeIterator - discarding signature.
         */
        private class NWayMergeDistinctIterator
        extends NWayMergeIterator {
            private E lastReturned;
            private Boolean cachedHasNext;
            private boolean uninitialized;

            NWayMergeDistinctIterator() {
                this.lastReturned = null;
                this.cachedHasNext = null;
                this.uninitialized = true;
            }

            @Override
            public boolean hasNext() {
                if (this.cachedHasNext != null) {
                    return this.cachedHasNext;
                }
                boolean hasNext = false;
                block0: for (int i = 0; i < this.iterators.length; ++i) {
                    if (this.uninitialized) {
                        boolean bl = hasNext = !this.iterators[i].EOF;
                        if (!hasNext) continue;
                        break;
                    }
                    if (this.lastReturnedIteratorIndex == i) {
                        do {
                            this.iterators[i].move();
                            if (this.iterators[i].EOF) continue block0;
                        } while (this.compare(this.lastReturned, this.iterators[i].get()) == 0);
                        hasNext = true;
                        continue;
                    }
                    while (!this.iterators[i].EOF) {
                        if (this.compare(this.iterators[i].get(), this.lastReturned) != 0) {
                            hasNext = true;
                            continue block0;
                        }
                        this.iterators[i].move();
                    }
                }
                this.uninitialized = false;
                this.cachedHasNext = hasNext;
                return hasNext;
            }

            @Override
            public E next() {
                if (this.cachedHasNext == null) {
                    this.hasNext();
                }
                this.cachedHasNext = null;
                this.lastReturned = this.basicNext();
                return this.lastReturned;
            }

            @Override
            public void remove() {
                super.remove();
            }
        }

        private class NWayMergeIterator
        implements Iterator<E> {
            protected final org.apache.geode.cache.query.internal.NWayMergeResults$NWayMergeResultsCollection.NWayMergeIterator.IteratorWrapper<E>[] iterators;
            protected int lastReturnedIteratorIndex = -1;

            protected NWayMergeIterator() {
                this.iterators = new IteratorWrapper[NWayMergeResultsCollection.this.sortedResults.size()];
                Iterator listIter = NWayMergeResultsCollection.this.sortedResults.iterator();
                int index = 0;
                while (listIter.hasNext()) {
                    IteratorWrapper temp = new IteratorWrapper(((Collection)listIter.next()).iterator());
                    this.iterators[index++] = temp;
                    temp.move();
                }
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                for (int i = 0; i < this.iterators.length; ++i) {
                    if (i == this.lastReturnedIteratorIndex) {
                        hasNext = this.iterators[i].hasNext();
                    } else {
                        boolean bl = hasNext = !((IteratorWrapper)this.iterators[i]).EOF;
                    }
                    if (hasNext) break;
                }
                return hasNext;
            }

            protected E basicNext() {
                if (this.iterators.length == 1) {
                    this.lastReturnedIteratorIndex = 0;
                    if (((IteratorWrapper)this.iterators[0]).EOF) {
                        throw new NoSuchElementException();
                    }
                    return this.iterators[0].get();
                }
                int iteratorIndex = -1;
                Object refObject = null;
                for (int j = 0; j < this.iterators.length; ++j) {
                    if (((IteratorWrapper)this.iterators[j]).EOF) continue;
                    Object temp = this.iterators[j].get();
                    iteratorIndex = j;
                    refObject = temp;
                    break;
                }
                if (iteratorIndex == -1) {
                    throw new NoSuchElementException();
                }
                Object currentOptima = null;
                int indexOfIteratorForOptima = -1;
                currentOptima = refObject;
                indexOfIteratorForOptima = iteratorIndex;
                for (int j = iteratorIndex + 1; j < this.iterators.length; ++j) {
                    Object temp;
                    int compareResult;
                    if (((IteratorWrapper)this.iterators[j]).EOF || (compareResult = this.compare(currentOptima, temp = this.iterators[j].get())) <= 0) continue;
                    currentOptima = temp;
                    indexOfIteratorForOptima = j;
                }
                this.lastReturnedIteratorIndex = indexOfIteratorForOptima;
                return currentOptima;
            }

            protected int compare(E obj1, E obj2) {
                return NWayMergeResults.this.collectionType.getElementType().isStructType() ? NWayMergeResultsCollection.this.comparator.compare(((StructImpl)obj1).getFieldValues(), ((StructImpl)obj2).getFieldValues()) : NWayMergeResultsCollection.this.comparator.compare(obj1, obj2);
            }

            @Override
            public E next() {
                if (this.lastReturnedIteratorIndex != -1) {
                    this.iterators[this.lastReturnedIteratorIndex].move();
                }
                return this.basicNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }

            private class IteratorWrapper<T> {
                private final Iterator<T> iter;
                private T current = null;
                private boolean EOF = false;

                private IteratorWrapper(Iterator<T> iter) {
                    this.iter = iter;
                }

                T get() {
                    return this.current;
                }

                boolean hasNext() {
                    return this.iter.hasNext();
                }

                void move() {
                    if (this.iter.hasNext()) {
                        this.current = this.iter.next();
                    } else {
                        this.current = null;
                        this.EOF = true;
                    }
                }
            }
        }
    }
}

