/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.client.AllConnectionsInUseException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class GetOp {
    private static final Logger logger = LogService.getLogger();
    public static final int HAS_CALLBACK_ARG = 1;
    public static final int HAS_VERSION_TAG = 2;
    public static final int KEY_NOT_PRESENT = 4;
    public static final int VALUE_IS_INVALID = 8;

    public static Object execute(ExecutablePool pool, LocalRegion region, Object key, Object callbackArg, boolean prSingleHopEnabled, EntryEventImpl clientEvent) {
        GetOpImpl op;
        block7: {
            ServerLocation server;
            ClientMetadataService cms = region.getCache().getClientMetadataService();
            op = new GetOpImpl(region, key, callbackArg, prSingleHopEnabled, clientEvent);
            if (logger.isDebugEnabled()) {
                logger.debug("GetOp invoked for key {}", key);
            }
            if (prSingleHopEnabled && (server = cms.getBucketServerLocation(region, Operation.GET, key, null, callbackArg)) != null) {
                try {
                    PoolImpl poolImpl = (PoolImpl)pool;
                    boolean onlyUseExistingCnx = poolImpl.getMaxConnections() != -1 && poolImpl.getConnectionCount() >= poolImpl.getMaxConnections();
                    op.setAllowDuplicateMetadataRefresh(!onlyUseExistingCnx);
                    return pool.executeOn(new ServerLocation(server.getHostName(), server.getPort()), op, true, onlyUseExistingCnx);
                }
                catch (AllConnectionsInUseException poolImpl) {
                }
                catch (ServerConnectivityException e) {
                    if (e instanceof ServerOperationException) {
                        throw e;
                    }
                    cms.removeBucketServerLocation(server);
                }
                catch (CacheLoaderException e) {
                    if (!(e.getCause() instanceof ServerConnectivityException)) break block7;
                    cms.removeBucketServerLocation(server);
                }
            }
        }
        return pool.execute(op);
    }

    private GetOp() {
    }

    static class GetOpImpl
    extends AbstractOp {
        private LocalRegion region = null;
        private boolean prSingleHopEnabled = false;
        private Object key;
        private Object callbackArg;
        private EntryEventImpl clientEvent;

        public String toString() {
            return "GetOpImpl(key=" + this.key + ")";
        }

        public GetOpImpl(LocalRegion region, Object key, Object callbackArg, boolean prSingleHopEnabled, EntryEventImpl clientEvent) {
            super(0, callbackArg != null ? 3 : 2);
            if (logger.isDebugEnabled()) {
                logger.debug("constructing a GetOp for key {}", key);
            }
            this.region = region;
            this.prSingleHopEnabled = prSingleHopEnabled;
            this.key = key;
            this.callbackArg = callbackArg;
            this.clientEvent = clientEvent;
            this.getMessage().addStringPart(region.getFullPath(), true);
            this.getMessage().addStringOrObjPart(key);
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Object processResponse(Message msg, Connection con) throws Exception {
            ClientMetadataService cms;
            int flags;
            Object object = this.processObjResponse(msg, "get");
            if (msg.getNumberOfParts() <= 1) return object;
            int partIdx = 1;
            if (((flags = msg.getPart(partIdx++).getInt()) & 1) != 0) {
                msg.getPart(partIdx++).getObject();
            }
            if (object == null && (flags & 8) != 0) {
                object = Token.INVALID;
            }
            if ((flags & 2) != 0) {
                VersionTag tag = (VersionTag)msg.getPart(partIdx++).getObject();
                assert (con != null);
                assert (con.getEndpoint() != null);
                assert (tag != null);
                tag.replaceNullIDs((InternalDistributedMember)con.getEndpoint().getMemberId());
                if (this.clientEvent != null) {
                    this.clientEvent.setVersionTag(tag);
                }
                if ((flags & 4) != 0) {
                    object = Token.TOMBSTONE;
                }
            }
            if (!this.prSingleHopEnabled || msg.getNumberOfParts() <= partIdx) return object;
            byte version = 0;
            int noOfMsgParts = msg.getNumberOfParts();
            if (noOfMsgParts == partIdx + 1) {
                byte[] bytesReceived;
                Part part;
                if (!(part = msg.getPart(partIdx++)).isBytes() || (bytesReceived = part.getSerializedForm())[0] == 0 || bytesReceived.length != 2) return object;
                try {
                    ClientMetadataService cms2 = this.region.getCache().getClientMetadataService();
                    byte myVersion = cms2.getMetaDataVersion(this.region, Operation.UPDATE, this.key, null, this.callbackArg);
                    if (myVersion == bytesReceived[0] && !this.isAllowDuplicateMetadataRefresh()) return object;
                    cms2.scheduleGetPRMetaData(this.region, false, bytesReceived[1]);
                    return object;
                }
                catch (CacheClosedException e) {
                    return null;
                }
            }
            if (noOfMsgParts != partIdx + 2) return object;
            msg.getPart(partIdx++).getObject();
            Part part = msg.getPart(partIdx++);
            if (!part.isBytes()) return object;
            byte[] bytesReceived = part.getSerializedForm();
            if (this.region == null || bytesReceived.length != 2) return object;
            try {
                cms = this.region.getCache().getClientMetadataService();
                version = cms.getMetaDataVersion(this.region, Operation.UPDATE, this.key, null, this.callbackArg);
            }
            catch (CacheClosedException e) {
                return null;
            }
            if (bytesReceived[0] == version) return object;
            cms.scheduleGetPRMetaData(this.region, false, bytesReceived[1]);
            return object;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGet(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

