/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClientPartitionAdvisor;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class GetClientPartitionAttributesOp {
    private static final Logger logger = LogService.getLogger();

    private GetClientPartitionAttributesOp() {
    }

    public static ClientPartitionAdvisor execute(ExecutablePool pool, String regionFullPath) {
        ClientPartitionAdvisor advisor;
        GetClientPartitionAttributesOpImpl op = new GetClientPartitionAttributesOpImpl(regionFullPath);
        if (logger.isDebugEnabled()) {
            logger.debug("GetClientPartitionAttributesOp#execute : Sending GetClientPartitionAttributesOp Message: {} for region: {} to server using pool: {}", (Object)op.getMessage(), (Object)regionFullPath, (Object)pool);
        }
        if ((advisor = (ClientPartitionAdvisor)pool.execute(op)) != null) {
            advisor.setServerGroup(((PoolImpl)pool).getServerGroup());
        }
        return advisor;
    }

    static class GetClientPartitionAttributesOpImpl
    extends AbstractOp {
        String regionFullPath = null;

        public GetClientPartitionAttributesOpImpl(String regionFullPath) {
            super(73, 1);
            this.regionFullPath = regionFullPath;
            this.getMessage().addStringPart(regionFullPath, true);
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            switch (msg.getMessageType()) {
                case 76: {
                    String errorMsg = msg.getPart(0).getString();
                    if (logger.isDebugEnabled()) {
                        logger.debug(errorMsg);
                    }
                    throw new ServerOperationException(errorMsg);
                }
                case 74: {
                    boolean isDebugEnabled = logger.isDebugEnabled();
                    if (isDebugEnabled) {
                        logger.debug("GetClientPartitionAttributesOpImpl#processResponse: received message of type : {}", (Object)MessageType.getString(msg.getMessageType()));
                    }
                    String partitionResolverName = null;
                    Set fpaSet = null;
                    int bucketCount = (Integer)msg.getPart(0).getObject();
                    String colocatedWith = (String)msg.getPart(1).getObject();
                    if (msg.getNumberOfParts() == 4) {
                        partitionResolverName = (String)msg.getPart(2).getObject();
                        fpaSet = (Set)msg.getPart(3).getObject();
                    } else if (msg.getNumberOfParts() == 3) {
                        Object obj = msg.getPart(2).getObject();
                        if (obj instanceof String) {
                            partitionResolverName = (String)obj;
                        } else {
                            fpaSet = (Set)obj;
                        }
                    } else if (bucketCount == -1) {
                        return null;
                    }
                    if (isDebugEnabled) {
                        logger.debug("GetClientPartitionAttributesOpImpl#processResponse: received all the results from server successfully.");
                    }
                    ClientPartitionAdvisor advisor = new ClientPartitionAdvisor(bucketCount, colocatedWith, partitionResolverName, fpaSet);
                    return advisor;
                }
                case 2: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("GetClientPartitionAttributesOpImpl#processResponse: received message of type EXCEPTION");
                    }
                    Part part = msg.getPart(0);
                    Object obj = part.getObject();
                    String s = "While performing  GetClientPartitionAttributesOp " + ((Throwable)obj).getMessage();
                    throw new ServerOperationException(s, (Throwable)obj);
                }
            }
            throw new InternalGemFireError(String.format("Unknown message type %s", msg.getMessageType()));
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGetClientPartitionAttributes();
        }

        protected String getOpName() {
            return "GetClientPartitionAttributesOp";
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetClientPartitionAttributesSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGetClientPartitionAttributes(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }
    }
}

