/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.geode.alerting.internal.AlertingSessionNotifier;
import org.apache.geode.alerting.internal.api.AlertingService;
import org.apache.geode.alerting.internal.spi.AlertingSessionListener;
import org.apache.geode.alerting.internal.spi.AlertingSessionRegistry;
import org.apache.geode.annotations.internal.MakeNotStatic;

public class AlertingSessionRegistryProvider
implements AlertingSessionRegistry,
AlertingSessionNotifier {
    @MakeNotStatic
    private static final AlertingSessionRegistryProvider INSTANCE = new AlertingSessionRegistryProvider();
    private final Set<AlertingSessionListener> listeners = new LinkedHashSet<AlertingSessionListener>();

    public static AlertingSessionRegistryProvider get() {
        return INSTANCE;
    }

    AlertingSessionRegistryProvider() {
    }

    @Override
    public synchronized void addAlertingSessionListener(AlertingSessionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeAlertingSessionListener(AlertingSessionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void clear() {
        this.listeners.clear();
    }

    @Override
    public synchronized void createSession(AlertingService alertingService) {
        for (AlertingSessionListener listener : this.listeners) {
            listener.createSession(alertingService);
        }
    }

    @Override
    public synchronized void startSession() {
        for (AlertingSessionListener listener : this.listeners) {
            listener.startSession();
        }
    }

    @Override
    public synchronized void stopSession() {
        for (AlertingSessionListener listener : this.listeners) {
            listener.stopSession();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }
}

