/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.internal.SystemMemberCacheImpl;
import org.apache.geode.admin.internal.SystemMemberRegionImpl;
import org.apache.geode.admin.jmx.internal.MBeanUtil;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.admin.GemFireVM;

public class SystemMemberRegionJmxImpl
extends SystemMemberRegionImpl
implements ManagedResource {
    private ObjectName objectName;
    private String mbeanName;
    private ModelMBean modelMBean;

    public SystemMemberRegionJmxImpl(SystemMemberCacheImpl cache, Region region) throws AdminException {
        super(cache, region);
        this.initializeMBean(cache);
    }

    private void initializeMBean(SystemMemberCacheImpl cache) throws AdminException {
        GemFireVM vm = cache.getVM();
        this.mbeanName = new StringBuffer("GemFire.Cache:").append("path=").append(MBeanUtil.makeCompliantMBeanNameProperty(this.getFullPath())).append(",name=").append(MBeanUtil.makeCompliantMBeanNameProperty(cache.getName())).append(",id=").append(cache.getId()).append(",owner=").append(MBeanUtil.makeCompliantMBeanNameProperty(vm.getId().toString())).append(",type=Region").toString();
        this.objectName = MBeanUtil.createMBean(this);
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.SYSTEM_MEMBER_REGION;
    }

    @Override
    public void cleanupResource() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemMemberRegionJmxImpl)) {
            return false;
        }
        SystemMemberRegionJmxImpl other = (SystemMemberRegionJmxImpl)obj;
        return this.getMBeanName().equals(other.getMBeanName());
    }

    public int hashCode() {
        return this.getMBeanName().hashCode();
    }
}

