/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.geode.annotations.Immutable;

@Immutable
public class SystemMemberType
implements Serializable {
    private static final long serialVersionUID = 3284366994485749302L;
    @Immutable
    public static final SystemMemberType MANAGER = new SystemMemberType("GemFireManager", 0);
    @Immutable
    public static final SystemMemberType APPLICATION = new SystemMemberType("Application", 1);
    @Immutable
    public static final SystemMemberType CACHE_VM;
    @Deprecated
    @Immutable
    public static final SystemMemberType CACHE_SERVER;
    private final transient String name;
    public final int ordinal;
    @Immutable
    private static final SystemMemberType[] VALUES;

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private SystemMemberType(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public static SystemMemberType fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public String getName() {
        return this.name;
    }

    public boolean isManager() {
        return this.equals(MANAGER);
    }

    public boolean isApplication() {
        return this.equals(APPLICATION);
    }

    @Deprecated
    public boolean isCacheServer() {
        return this.isCacheVm();
    }

    public boolean isCacheVm() {
        return this.equals(CACHE_VM);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof SystemMemberType)) {
            return false;
        }
        SystemMemberType that = (SystemMemberType)other;
        return this.ordinal == that.ordinal;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.ordinal;
        return result;
    }

    static {
        CACHE_SERVER = CACHE_VM = new SystemMemberType("CacheVm", 2);
        VALUES = new SystemMemberType[]{MANAGER, APPLICATION, CACHE_VM};
    }
}

