/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public final class ArabicAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private final CharArraySet stemExclusionSet;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public ArabicAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public ArabicAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public ArabicAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Set)stemExclusionSet));
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        Object result = new LowerCaseFilter((TokenStream)source);
        if (this.getVersion().onOrAfter(Version.LUCENE_5_4_0)) {
            result = new DecimalDigitFilter((TokenStream)result);
        }
        result = new StopFilter((TokenStream)result, this.stopwords);
        result = new ArabicNormalizationFilter((TokenStream)result);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new ArabicStemFilter((TokenStream)result));
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        Object result = new LowerCaseFilter(in);
        result = new DecimalDigitFilter((TokenStream)result);
        result = new ArabicNormalizationFilter((TokenStream)result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = ArabicAnalyzer.loadStopwordSet((boolean)false, (Class)ArabicAnalyzer.class, (String)ArabicAnalyzer.DEFAULT_STOPWORD_FILE, (String)"#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

