/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MembershipInformation;
import org.apache.geode.distributed.internal.membership.api.QuorumChecker;
import org.apache.geode.distributed.internal.membership.gms.GMSMembershipView;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSEncrypt;
import org.apache.geode.distributed.internal.membership.gms.messenger.GMSPingPonger;
import org.apache.geode.distributed.internal.membership.gms.messenger.JGAddress;
import org.apache.geode.distributed.internal.membership.gms.messenger.JGroupsMessenger;
import org.apache.geode.distributed.internal.membership.gms.messenger.MembershipInformationImpl;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class GMSQuorumChecker<ID extends MemberIdentifier>
implements QuorumChecker {
    private static final Logger logger = LogService.getLogger();
    private final GMSEncrypt encrypt;
    private boolean isInfoEnabled = false;
    private Map<SocketAddress, ID> addressConversionMap;
    private GMSPingPonger pingPonger;
    private Set<ID> receivedAcks;
    private final GMSMembershipView<ID> lastView;
    private boolean quorumAchieved = false;
    private final JChannel channel;
    private JGAddress myAddress;
    private final long partitionThreshold;
    private ConcurrentLinkedQueue<Message> messageQueue = new ConcurrentLinkedQueue();

    public GMSQuorumChecker(GMSMembershipView<ID> jgView, int partitionThreshold, JChannel channel, GMSEncrypt encrypt) {
        this.lastView = jgView;
        this.partitionThreshold = partitionThreshold;
        this.channel = channel;
        this.encrypt = encrypt;
    }

    public void initialize() {
        this.receivedAcks = ConcurrentHashMap.newKeySet();
        this.pingPonger = new GMSPingPonger();
        this.myAddress = (JGAddress)this.channel.down(new Event(91));
        this.addressConversionMap = new ConcurrentHashMap<SocketAddress, ID>(this.lastView.size());
        List<ID> members = this.lastView.getMembers();
        for (MemberIdentifier addr : members) {
            InetSocketAddress sockaddr = new InetSocketAddress(addr.getInetAddress(), addr.getMembershipPort());
            this.addressConversionMap.put(sockaddr, addr);
        }
        this.isInfoEnabled = logger.isInfoEnabled();
        this.resume();
    }

    @Override
    public synchronized boolean checkForQuorum(long timeout) throws InterruptedException {
        if (this.quorumAchieved) {
            return true;
        }
        this.resume();
        if (this.isInfoEnabled) {
            logger.info("beginning quorum check with {}", (Object)this);
        }
        this.sendPingMessages();
        this.quorumAchieved = this.waitForResponses(this.lastView.getMembers().size(), timeout);
        if (!this.quorumAchieved) {
            this.quorumAchieved = this.calculateQuorum();
        }
        return this.quorumAchieved;
    }

    @Override
    public void close() {
        if (this.channel != null && !this.channel.isClosed()) {
            this.channel.close();
        }
    }

    @Override
    public void resume() {
        JGroupsMessenger.setChannelReceiver(this.channel, new QuorumCheckerReceiver());
    }

    @Override
    public MembershipInformation getMembershipInfo() {
        return new MembershipInformationImpl(this.channel, this.messageQueue, this.encrypt);
    }

    private boolean calculateQuorum() {
        int weight = this.getWeight((Collection<ID>)this.lastView.getMembers(), (MemberIdentifier)this.lastView.getLeadMember());
        int ackedWeight = this.getWeight((Collection<ID>)this.receivedAcks, (MemberIdentifier)this.lastView.getLeadMember());
        int lossThreshold = (int)Math.round((double)((long)weight * this.partitionThreshold) / 100.0);
        if (this.isInfoEnabled) {
            logger.info("quorum check: contacted {} processes with {} member weight units.  Threshold for a quorum is {}", (Object)this.receivedAcks.size(), (Object)ackedWeight, (Object)lossThreshold);
        }
        return ackedWeight >= lossThreshold;
    }

    private boolean waitForResponses(int numMembers, long timeout) throws InterruptedException {
        block5: {
            long endTime = System.currentTimeMillis() + timeout;
            do {
                long time;
                long remaining;
                if ((remaining = endTime - (time = System.currentTimeMillis())) <= 0L) {
                    if (this.isInfoEnabled) {
                        logger.info("quorum check: timeout waiting for responses.  {} responses received", (Object)this.receivedAcks.size());
                    }
                    break block5;
                }
                if (this.isInfoEnabled) {
                    logger.info("quorum check: waiting up to {}ms to receive a quorum of responses", (Object)remaining);
                }
                Thread.sleep(500L);
            } while (this.receivedAcks.size() != numMembers);
            if (this.isInfoEnabled) {
                logger.info("quorum check: received responses from all members that were in the old distributed system");
            }
            return true;
        }
        return false;
    }

    private int getWeight(Collection<ID> idms, MemberIdentifier leader) {
        int weight = 0;
        for (MemberIdentifier mbr : idms) {
            int thisWeight = mbr.getMemberWeight();
            if (mbr.getVmKind() == 10) {
                thisWeight += 10;
                if (leader != null && mbr.equals(leader)) {
                    thisWeight += 5;
                }
            } else if (mbr.preferredForCoordinator()) {
                thisWeight += 3;
            }
            weight += thisWeight;
        }
        return weight;
    }

    private void sendPingMessages() {
        List<ID> members = this.lastView.getMembers();
        for (MemberIdentifier addr : members) {
            if (this.receivedAcks.contains(addr)) continue;
            JGAddress dest = new JGAddress(addr);
            if (this.isInfoEnabled) {
                logger.info("quorum check: sending request to {}", (Object)addr);
            }
            try {
                this.pingPonger.sendPingMessage(this.channel, this.myAddress, dest);
            }
            catch (Exception e) {
                logger.info("Failed sending Ping message to " + dest);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " on view " + this.lastView;
    }

    private class QuorumCheckerReceiver
    implements Receiver {
        private QuorumCheckerReceiver() {
        }

        @Override
        public void receive(Message msg) {
            byte[] msgBytes = msg.getBuffer();
            if (GMSQuorumChecker.this.pingPonger.isPingMessage(msgBytes)) {
                try {
                    GMSQuorumChecker.this.pingPonger.sendPongMessage(GMSQuorumChecker.this.channel, GMSQuorumChecker.this.myAddress, msg.getSrc());
                }
                catch (Exception e) {
                    logger.info("Failed sending Pong message to " + msg.getSrc());
                }
            } else if (GMSQuorumChecker.this.pingPonger.isPongMessage(msgBytes)) {
                this.pongReceived(msg.getSrc());
            } else {
                this.queueMessage(msg);
            }
        }

        private void queueMessage(Message msg) {
            GMSQuorumChecker.this.messageQueue.add(msg);
        }

        @Override
        public void getState(OutputStream output) throws Exception {
        }

        @Override
        public void setState(InputStream input) throws Exception {
        }

        @Override
        public void viewAccepted(View new_view) {
        }

        @Override
        public void suspect(Address suspected_mbr) {
        }

        @Override
        public void block() {
        }

        @Override
        public void unblock() {
        }

        public void pongReceived(Address sender) {
            logger.info("received ping-pong response from {}", (Object)sender);
            JGAddress jgSender = (JGAddress)sender;
            InetSocketAddress sockaddr = new InetSocketAddress(jgSender.getInetAddress(), jgSender.getPort());
            MemberIdentifier memberAddr = (MemberIdentifier)GMSQuorumChecker.this.addressConversionMap.get(sockaddr);
            if (memberAddr != null) {
                logger.info("quorum check: mapped address to member ID {}", (Object)memberAddr);
                GMSQuorumChecker.this.receivedAcks.add(memberAddr);
            }
        }
    }
}

