/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import org.apache.geode.StatisticsFactory;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolProcessor;
import org.apache.geode.internal.cache.client.protocol.ClientProtocolService;
import org.apache.geode.internal.protocol.protobuf.statistics.ClientStatistics;
import org.apache.geode.internal.protocol.protobuf.statistics.NoOpStatistics;
import org.apache.geode.internal.protocol.protobuf.statistics.ProtobufClientStatistics;
import org.apache.geode.internal.protocol.protobuf.v1.LocatorMessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufCachePipeline;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufStreamProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.ServerMessageExecutionContext;
import org.apache.geode.internal.security.SecurityService;

public class ProtobufProtocolService
implements ClientProtocolService {
    private volatile ClientStatistics statistics;
    private final ProtobufStreamProcessor protobufStreamProcessor = new ProtobufStreamProcessor();

    @Override
    public synchronized void initializeStatistics(String statisticsName, StatisticsFactory factory) {
        if (this.statistics == null) {
            this.statistics = new ProtobufClientStatistics(factory, statisticsName);
        }
    }

    @Override
    public ClientProtocolProcessor createProcessorForCache(InternalCache cache, SecurityService securityService) {
        assert (this.statistics != null);
        return new ProtobufCachePipeline(this.protobufStreamProcessor, new ServerMessageExecutionContext(cache, this.statistics, securityService));
    }

    ClientStatistics getStatistics() {
        if (this.statistics == null) {
            return new NoOpStatistics();
        }
        return this.statistics;
    }

    @Override
    public ClientProtocolProcessor createProcessorForLocator(InternalLocator locator, SecurityService securityService) {
        return new ProtobufCachePipeline(this.protobufStreamProcessor, new LocatorMessageExecutionContext(locator, this.statistics, securityService));
    }

    @Override
    public int getServiceProtocolVersion() {
        return 1;
    }
}

