/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RedisDataTypeMismatchException;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class SetExecutor
extends StringExecutor {
    private final String SUCCESS = "OK";
    private final int VALUE_INDEX = 2;
    private boolean NX = false;
    private boolean XX = false;
    private boolean KEEPTTL = false;
    private long expiration = 0L;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SET command is \"SET key value [EX seconds] [PX milliseconds] [NX|XX]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        ByteArrayWrapper value = this.getValue(commandElems);
        if (context.getKeyRegistrar().isProtected(key)) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is protected");
        }
        String parseError = this.parseCommandElems(commandElems);
        if (parseError != null) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), parseError));
            return;
        }
        Region<ByteArrayWrapper, ByteArrayWrapper> region = context.getRegionProvider().getStringsRegion();
        if (this.NX) {
            this.setNX(region, command, key, value, context);
            return;
        }
        if (this.XX) {
            this.setXX(region, command, key, value, context);
            return;
        }
        this.set(command, context, region, key, value);
    }

    private ByteArrayWrapper getValue(List<byte[]> commandElems) {
        byte[] value = commandElems.get(2);
        return new ByteArrayWrapper(value);
    }

    private Region getRegion(ExecutionHandlerContext context, ByteArrayWrapper key) {
        RedisDataType redisDataType = context.getKeyRegistrar().getType(key);
        return context.getRegionProvider().getRegionForType(redisDataType);
    }

    private String parseCommandElems(List<byte[]> commandElems) {
        boolean PX = false;
        boolean EX = false;
        this.KEEPTTL = false;
        PX = false;
        EX = false;
        this.XX = false;
        this.NX = false;
        this.expiration = 0L;
        block14: for (int i = 3; i < commandElems.size(); ++i) {
            String current_arg;
            switch (current_arg = Coder.bytesToString(commandElems.get(i)).toUpperCase()) {
                case "KEEPTTL": {
                    this.KEEPTTL = true;
                    continue block14;
                }
                case "EX": {
                    EX = true;
                    this.expiration = this.parseExpirationTime(current_arg, ++i, commandElems);
                    continue block14;
                }
                case "PX": {
                    PX = true;
                    this.expiration = this.parseExpirationTime(current_arg, ++i, commandElems);
                    continue block14;
                }
                case "NX": {
                    this.NX = true;
                    continue block14;
                }
                case "XX": {
                    this.XX = true;
                    continue block14;
                }
                default: {
                    return "syntax error";
                }
            }
        }
        if (EX && PX) {
            return "syntax error";
        }
        if (this.NX && this.XX) {
            return "syntax error";
        }
        if (EX || PX) {
            if (this.expiration == -2L) {
                return "syntax error";
            }
            if (this.expiration == -1L) {
                return "value is not an integer or out of range";
            }
            if (this.expiration == 0L) {
                return "invalid expire time in set";
            }
        }
        return null;
    }

    private long parseExpirationTime(String arg, int index, List<byte[]> commandElems) {
        String expirationString;
        try {
            expirationString = Coder.bytesToString(commandElems.get(index));
        }
        catch (IndexOutOfBoundsException e) {
            return -2L;
        }
        long expiration = 0L;
        try {
            expiration = Long.parseLong(expirationString);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        if (expiration <= 0L) {
            return 0L;
        }
        if (arg.equalsIgnoreCase("EX")) {
            return expiration * 1000L;
        }
        if (arg.equalsIgnoreCase("PX")) {
            return expiration;
        }
        return -1L;
    }

    private void setNX(Region<ByteArrayWrapper, ByteArrayWrapper> region, Command command, ByteArrayWrapper key, ByteArrayWrapper valueWrapper, ExecutionHandlerContext context) {
        if (this.keyAlreadyExistsForDifferentDataType(context, key)) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        this.checkAndSetDataType(key, context);
        Object oldValue = region.putIfAbsent((Object)key, (Object)valueWrapper);
        if (oldValue != null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
        this.handleExpiration(context, key);
    }

    private void setXX(Region<ByteArrayWrapper, ByteArrayWrapper> region, Command command, ByteArrayWrapper key, ByteArrayWrapper valueWrapper, ExecutionHandlerContext context) {
        if (region.containsKey((Object)key) || this.keyAlreadyExistsForDifferentDataType(context, key)) {
            this.set(command, context, region, key, valueWrapper);
        } else {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
        }
    }

    private void set(Command command, ExecutionHandlerContext context, Region<ByteArrayWrapper, ByteArrayWrapper> stringsRegion, ByteArrayWrapper key, ByteArrayWrapper valueWrapper) {
        if (this.keyAlreadyExistsForDifferentDataType(context, key)) {
            this.removeOldValueAndDataTypeAssociation(context, key);
        }
        this.checkAndSetDataType(key, context);
        stringsRegion.put((Object)key, (Object)valueWrapper);
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
        this.handleExpiration(context, key);
    }

    private boolean keyAlreadyExistsForDifferentDataType(ExecutionHandlerContext context, ByteArrayWrapper key) {
        try {
            this.checkDataType(key, RedisDataType.REDIS_STRING, context);
        }
        catch (RedisDataTypeMismatchException e) {
            return true;
        }
        return false;
    }

    private void removeOldValueAndDataTypeAssociation(ExecutionHandlerContext context, ByteArrayWrapper key) {
        Region oldRegion = this.getRegion(context, key);
        oldRegion.remove((Object)key);
        context.getKeyRegistrar().unregister(key);
    }

    private void handleExpiration(ExecutionHandlerContext context, ByteArrayWrapper key) {
        if (this.expiration > 0L) {
            context.getRegionProvider().setExpiration(key, this.expiration);
        } else if (!this.KEEPTTL) {
            context.getRegionProvider().cancelKeyExpiration(key);
        }
    }
}

