/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.set.DeltaSet;
import org.apache.geode.redis.internal.executor.set.SInterExecutor;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public abstract class SetOpExecutor
extends SetExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int setsStartIndex;
        List<byte[]> commandElems = command.getProcessedCommand();
        int n = setsStartIndex = this.isStorage() ? 2 : 1;
        if (commandElems.size() < setsStartIndex + 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        RegionProvider regionProvider = context.getRegionProvider();
        ByteArrayWrapper destination = null;
        if (this.isStorage()) {
            destination = command.getKey();
        }
        ByteArrayWrapper firstSetKey = new ByteArrayWrapper(commandElems.get(setsStartIndex++));
        if (destination != null) {
            try (AutoCloseableLock regionLock = this.withRegionLock(context, destination);){
                this.doActualSetOperation(command, context, commandElems, setsStartIndex, regionProvider, destination, firstSetKey);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            }
            catch (TimeoutException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            }
        } else {
            this.doActualSetOperation(command, context, commandElems, setsStartIndex, regionProvider, destination, firstSetKey);
        }
    }

    private boolean doActualSetOperation(Command command, ExecutionHandlerContext context, List<byte[]> commandElems, int setsStartIndex, RegionProvider regionProvider, ByteArrayWrapper destination, ByteArrayWrapper firstSetKey) {
        Region<ByteArrayWrapper, DeltaSet> region = this.getRegion(context);
        Set<ByteArrayWrapper> firstSet = DeltaSet.members(region, firstSetKey);
        ArrayList<Set<ByteArrayWrapper>> setList = new ArrayList<Set<ByteArrayWrapper>>();
        for (int i = setsStartIndex; i < commandElems.size(); ++i) {
            ByteArrayWrapper key = new ByteArrayWrapper(commandElems.get(i));
            Set<ByteArrayWrapper> entry = DeltaSet.members(region, key);
            if (entry != null) {
                setList.add(entry);
                continue;
            }
            if (!(this instanceof SInterExecutor)) continue;
            setList.add(new HashSet());
        }
        if (setList.isEmpty() && !this.isStorage()) {
            this.respondBulkStrings(command, context, firstSet);
            return true;
        }
        Set<ByteArrayWrapper> resultSet = this.setOp(firstSet, setList);
        if (this.isStorage()) {
            regionProvider.removeKey(destination);
            if (resultSet != null) {
                if (!resultSet.isEmpty()) {
                    region.put((Object)destination, (Object)new DeltaSet(resultSet));
                    context.getKeyRegistrar().register(destination, RedisDataType.REDIS_SET);
                }
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), resultSet.size()));
            } else {
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            }
        } else if (resultSet == null || resultSet.isEmpty()) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
        } else {
            this.respondBulkStrings(command, context, resultSet);
        }
        return false;
    }

    protected abstract boolean isStorage();

    protected abstract Set<ByteArrayWrapper> setOp(Set<ByteArrayWrapper> var1, List<Set<ByteArrayWrapper>> var2);
}

