/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.set.DeltaSet;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SPopExecutor
extends SetExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        int popCount = 1;
        if (commandElems.size() < 2 || commandElems.size() > 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SPOP command is \"SPOP key [count]\""));
            return;
        }
        if (commandElems.size() == 3) {
            try {
                popCount = Integer.parseInt(new String(commandElems.get(2)));
            }
            catch (NumberFormatException nex) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SPOP command is \"SPOP key [count]\""));
                return;
            }
        }
        ByteArrayWrapper key = command.getKey();
        ArrayList<ByteArrayWrapper> popped = new ArrayList<ByteArrayWrapper>();
        try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
            Region<ByteArrayWrapper, DeltaSet> region = this.getRegion(context);
            DeltaSet original = (DeltaSet)region.get((Object)key);
            if (original == null) {
                command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
                return;
            }
            DeltaSet deltaSet = original;
            synchronized (deltaSet) {
                int originalSize;
                block37: {
                    originalSize = original.size();
                    if (originalSize != 0) break block37;
                    command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
                    return;
                }
                if (popCount >= originalSize) {
                    popped.addAll(original.members());
                } else {
                    ByteArrayWrapper[] setMembers = original.members().toArray(new ByteArrayWrapper[originalSize]);
                    Random rand = new Random();
                    while (popped.size() < popCount) {
                        int idx = rand.nextInt(originalSize);
                        ByteArrayWrapper memberToPop = setMembers[idx];
                        if (memberToPop == null) continue;
                        setMembers[idx] = null;
                        popped.add(memberToPop);
                    }
                }
                DeltaSet.srem(region, key, popped, null);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            return;
        }
        catch (TimeoutException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            return;
        }
        try {
            if (popCount == 1) {
                command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), popped.get(0)));
            } else {
                command.setResponse(Coder.getArrayResponse(context.getByteBufAllocator(), popped));
            }
        }
        catch (CoderException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The server had an internal error please try again"));
        }
    }
}

