/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.pubsub;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.org.apache.hadoop.fs.GlobPattern;
import org.apache.logging.log4j.Logger;

public class PunsubscribeExecutor
extends AbstractExecutor {
    private static final Logger logger = LogService.getLogger();

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        byte[] pattern = command.getProcessedCommand().get(1);
        long subscriptionCount = context.getPubSub().punsubscribe(new GlobPattern(new String(pattern)), context.getClient());
        ArrayList<Object> items = new ArrayList<Object>();
        items.add("punsubscribe");
        items.add(pattern);
        items.add(subscriptionCount);
        ByteBuf response = null;
        try {
            response = Coder.getArrayResponse(context.getByteBufAllocator(), items);
        }
        catch (CoderException e) {
            logger.warn("Error encoding unsubscribe response", (Throwable)e);
        }
        command.setResponse(response);
    }
}

