/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.pubsub;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class PublishExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> args = command.getProcessedCommand();
        if (args.size() != 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PUBLISH command is \"PUBLISH channel message\""));
            return;
        }
        String channelName = new String(args.get(1));
        long publishCount = context.getPubSub().publish(channelName, args.get(2));
        this.writeResponse(command, context, publishCount);
    }

    private void writeResponse(Command command, ExecutionHandlerContext context, long publishCount) {
        ByteBuf response = Coder.getIntegerResponse(context.getByteBufAllocator(), publishCount);
        command.setResponse(response);
    }
}

