/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.pubsub;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.org.apache.hadoop.fs.GlobPattern;
import org.apache.logging.log4j.Logger;

public class PsubscribeExecutor
extends AbstractExecutor {
    private static final Logger logger = LogService.getLogger();

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        ArrayList<ArrayList<Object>> items = new ArrayList<ArrayList<Object>>();
        for (int i = 1; i < command.getProcessedCommand().size(); ++i) {
            ArrayList<Object> item = new ArrayList<Object>();
            byte[] pattern = command.getProcessedCommand().get(i);
            long subscribedChannels = context.getPubSub().psubscribe(new GlobPattern(new String(pattern)), context, context.getClient());
            item.add("psubscribe");
            item.add(pattern);
            item.add(subscribedChannels);
            items.add(item);
        }
        this.writeResponse(command, context, items);
    }

    private void writeResponse(Command command, ExecutionHandlerContext context, ArrayList<ArrayList<Object>> items) {
        ByteBuf aggregatedResponse = context.getByteBufAllocator().buffer();
        items.forEach((Consumer<ArrayList<Object>>)((Consumer<ArrayList>)item -> {
            ByteBuf response = null;
            try {
                response = Coder.getArrayResponse(context.getByteBufAllocator(), item);
            }
            catch (CoderException e) {
                logger.warn("Error encoding subscribe response", (Throwable)e);
            }
            if (response != null) {
                aggregatedResponse.writeBytes(response);
                response.release();
            }
        }));
        command.setResponse(aggregatedResponse);
    }
}

