/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hll;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.hll.CardinalityMergeException;
import org.apache.geode.internal.hll.HyperLogLogPlus;
import org.apache.geode.internal.hll.ICardinality;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hll.HllExecutor;

public class PFCountExecutor
extends HllExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PFCOUNT command is \"PFCOUNT key [key ...]\""));
            return;
        }
        Region<ByteArrayWrapper, HyperLogLogPlus> keyRegion = context.getRegionProvider().gethLLRegion();
        ArrayList<HyperLogLogPlus> hlls = new ArrayList<HyperLogLogPlus>();
        for (int i = 1; i < commandElems.size(); ++i) {
            ByteArrayWrapper k = new ByteArrayWrapper(commandElems.get(i));
            this.checkDataType(k, RedisDataType.REDIS_HLL, context);
            HyperLogLogPlus h = (HyperLogLogPlus)keyRegion.get((Object)k);
            if (h == null) continue;
            hlls.add(h);
        }
        if (hlls.isEmpty()) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        HyperLogLogPlus tmp = (HyperLogLogPlus)hlls.remove(0);
        ICardinality[] estimators = hlls.toArray(new HyperLogLogPlus[hlls.size()]);
        try {
            tmp = (HyperLogLogPlus)tmp.merge(estimators);
        }
        catch (CardinalityMergeException e) {
            throw new RuntimeException(e);
        }
        long cardinality = tmp.cardinality();
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), cardinality));
    }
}

