/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hll;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.hll.HyperLogLogPlus;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.hll.HllExecutor;

public class PFAddExecutor
extends HllExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the PFADD command is \"PFADD key element [element ...]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        Region<ByteArrayWrapper, HyperLogLogPlus> keyRegion = context.getRegionProvider().gethLLRegion();
        HyperLogLogPlus hll = (HyperLogLogPlus)keyRegion.get((Object)key);
        boolean changed = false;
        if (hll == null) {
            hll = new HyperLogLogPlus(DEFAULT_HLL_DENSE);
        }
        for (int i = 2; i < commandElems.size(); ++i) {
            byte[] bytes = commandElems.get(i);
            boolean offerChange = hll.offer(bytes);
            if (!offerChange) continue;
            changed = true;
        }
        keyRegion.put((Object)key, (Object)hll);
        if (changed) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }
}

