/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.GeodeRedisHashSynchronized;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HDelExecutor
extends HashExecutor {
    private final int START_FIELDS_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<ByteArrayWrapper> commandElems = command.getProcessedCommandWrappers();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HDEL command is \"HDEL key field [field ...]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_HASH, context);
        GeodeRedisHashSynchronized hash = new GeodeRedisHashSynchronized(key, context);
        int numDeleted = hash.hdel(commandElems.subList(2, commandElems.size()));
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numDeleted));
    }
}

