/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class ExistsExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<ByteArrayWrapper> commandElems = command.getProcessedCommandWrappers();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the EXISTS command is \"EXISTS key\""));
            return;
        }
        long existsCount = commandElems.subList(1, commandElems.size()).stream().filter(key -> context.getKeyRegistrar().isRegistered((ByteArrayWrapper)key)).count();
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), existsCount));
    }
}

