/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.redis.internal.AbstractSubscription;
import org.apache.geode.redis.internal.Client;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.org.apache.hadoop.fs.GlobPattern;

class PatternSubscription
extends AbstractSubscription {
    final GlobPattern pattern;

    public PatternSubscription(Client client, GlobPattern pattern, ExecutionHandlerContext context) {
        super(client, context);
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        this.pattern = pattern;
    }

    @Override
    public List<Object> createResponse(String channel, byte[] message) {
        return Arrays.asList("pmessage", this.pattern.globPattern(), channel, message);
    }

    @Override
    public boolean isEqualTo(Object channelOrPattern, Client client) {
        return this.pattern != null && this.pattern.equals(channelOrPattern) && this.getClient().equals(client);
    }

    @Override
    public boolean matches(String channel) {
        return this.pattern.matches(channel);
    }
}

