/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ResourceEventsListener;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.geode.redis.GeodeRedisServer;
import org.apache.logging.log4j.Logger;

public class GeodeRedisService
implements CacheService,
ResourceEventsListener {
    private static final Logger logger = LogService.getLogger();
    private GeodeRedisServer redisServer;
    private InternalCache cache;

    public boolean init(Cache cache) {
        this.cache = (InternalCache)cache;
        this.cache.getInternalDistributedSystem().addResourceListener((ResourceEventsListener)this);
        return true;
    }

    public void close() {
        this.stopRedisServer();
    }

    public void handleEvent(ResourceEvent event, Object resource) {
        if (event.equals((Object)ResourceEvent.CLUSTER_CONFIGURATION_APPLIED) && resource == this.cache) {
            this.startRedisServer(this.cache);
        }
    }

    private void startRedisServer(InternalCache cache) {
        InternalDistributedSystem system = cache.getInternalDistributedSystem();
        int port = system.getConfig().getRedisPort();
        if (port != 0) {
            String bindAddress = system.getConfig().getRedisBindAddress();
            assert (bindAddress != null);
            if (bindAddress.equals("")) {
                logger.info(String.format("Starting GeodeRedisServer on port %s", port));
            } else {
                logger.info(String.format("Starting GeodeRedisServer on bind address %s on port %s", bindAddress, port));
            }
            this.redisServer = new GeodeRedisServer(bindAddress, port);
            this.redisServer.start();
        }
    }

    private void stopRedisServer() {
        if (this.redisServer != null) {
            this.redisServer.shutdown();
        }
    }

    public Class<? extends CacheService> getInterface() {
        return GeodeRedisService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }
}

