/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.Client;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.PublishResult;
import org.apache.geode.redis.internal.Subscription;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSubscription
implements Subscription {
    private static final Logger logger = LogService.getLogger();
    private final Client client;
    private final ExecutionHandlerContext context;

    AbstractSubscription(Client client, ExecutionHandlerContext context) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.client = client;
        this.context = context;
    }

    @Override
    public PublishResult publishMessage(String channel, byte[] message) {
        ByteBuf messageByteBuffer = this.constructResponse(channel, message);
        if (messageByteBuffer == null) {
            return new PublishResult(this.client, false);
        }
        return new PublishResult(this.client, this.writeToChannelSynchronously(messageByteBuffer));
    }

    Client getClient() {
        return this.client;
    }

    @Override
    public boolean matchesClient(Client client) {
        return this.client.equals(client);
    }

    private ByteBuf constructResponse(String channel, byte[] message) {
        ByteBuf messageByteBuffer;
        try {
            messageByteBuffer = Coder.getArrayResponse(this.context.getByteBufAllocator(), this.createResponse(channel, message));
        }
        catch (CoderException e) {
            logger.warn("Unable to encode publish message", (Throwable)e);
            return null;
        }
        return messageByteBuffer;
    }

    private boolean writeToChannelSynchronously(ByteBuf messageByteBuffer) {
        ChannelFuture channelFuture = this.context.writeToChannel(messageByteBuffer);
        try {
            channelFuture.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ClosedChannelException) {
                logger.warn("Unable to write to channel: {}", (Object)e.getMessage());
            } else {
                logger.warn("Unable to write to channel", (Throwable)e);
            }
            return false;
        }
        catch (InterruptedException e) {
            logger.warn("Unable to write to channel", (Throwable)e);
            return false;
        }
        return channelFuture.cause() == null;
    }
}

