/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.caucho;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.remote.caucho.CauchoInput;
import mx4j.tools.remote.caucho.CauchoOutput;
import mx4j.tools.remote.caucho.CauchoService;
import mx4j.tools.remote.http.HTTPClientInvoker;
import mx4j.tools.remote.http.HTTPConnection;

public abstract class CauchoClientInvoker
extends HTTPClientInvoker {
    private final String endpoint;
    private final HTTPConnection service;
    static /* synthetic */ Class class$mx4j$tools$remote$http$HTTPConnection;
    static /* synthetic */ Class class$mx4j$tools$remote$caucho$CauchoClientInvoker;

    public CauchoClientInvoker(String endpoint) {
        this.endpoint = endpoint;
        CauchoServiceProxy proxy = new CauchoServiceProxy();
        this.service = (HTTPConnection)Proxy.newProxyInstance(proxy.getClass().getClassLoader(), new Class[]{class$mx4j$tools$remote$http$HTTPConnection == null ? (class$mx4j$tools$remote$http$HTTPConnection = CauchoClientInvoker.class$("mx4j.tools.remote.http.HTTPConnection")) : class$mx4j$tools$remote$http$HTTPConnection}, (InvocationHandler)proxy);
    }

    protected HTTPConnection getService() {
        return this.service;
    }

    protected abstract CauchoInput createCauchoInput(InputStream var1);

    protected abstract CauchoOutput createCauchoOutput(OutputStream var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CauchoServiceProxy
    implements InvocationHandler {
        private CauchoServiceProxy() {
        }

        /*
         * Loose catch block
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            URLConnection connection = new URL(CauchoClientInvoker.this.endpoint).openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());
            try {
                CauchoOutput output = CauchoClientInvoker.this.createCauchoOutput(os);
                this.startCall(output);
                this.writeHeaders(output);
                this.writeMethod(output, method);
                this.writeArguments(output, args);
                this.completeCall(output);
                ((OutputStream)os).flush();
                BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
                try {
                    CauchoInput input = CauchoClientInvoker.this.createCauchoInput(is);
                    input.startReply();
                    Object result = input.readObject(null);
                    input.completeReply();
                    Object object = result;
                    return object;
                }
                catch (Throwable x) {
                    Logger logger = Log.getLogger((class$mx4j$tools$remote$caucho$CauchoClientInvoker == null ? (class$mx4j$tools$remote$caucho$CauchoClientInvoker = CauchoClientInvoker.class$("mx4j.tools.remote.caucho.CauchoClientInvoker")) : class$mx4j$tools$remote$caucho$CauchoClientInvoker).getName());
                    if (logger.isEnabledFor(10)) {
                        logger.debug("", x);
                    }
                    throw x;
                }
                finally {
                    ((InputStream)is).close();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                ((OutputStream)os).close();
            }
        }

        private void startCall(CauchoOutput output) throws IOException {
            output.startCall();
        }

        private void writeHeaders(CauchoOutput output) throws IOException {
            output.writeHeader("connectionContext");
            output.writeObject(CauchoClientInvoker.this.getConnectionId());
        }

        private void writeMethod(CauchoOutput output, Method method) throws IOException {
            String methodName = this.mangleMethodName(method);
            output.writeMethod(methodName);
        }

        private String mangleMethodName(Method method) {
            return CauchoService.mangleMethodName(method);
        }

        private void writeArguments(CauchoOutput output, Object[] args) throws IOException {
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    output.writeObject(args[i]);
                }
            }
        }

        private void completeCall(CauchoOutput output) throws IOException {
            output.completeCall();
        }
    }
}

