/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.lang;

import java.io.Serializable;
import java.util.List;

public interface Identifiable<T extends Comparable<T>>
extends Serializable {
    public T getId();

    public static <T extends Identifiable> boolean exists(List<T> list, String id) {
        return list.stream().anyMatch(o -> o.getId().equals(id));
    }

    public static <T extends Identifiable> T find(List<T> list, String id) {
        return (T)((Identifiable)list.stream().filter(o -> o.getId().equals(id)).findFirst().orElse(null));
    }

    public static <T extends Identifiable> void remove(List<T> list, String id) {
        list.removeIf(t -> t.getId().equals(id));
    }
}

