/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class AlterRuntimeConfigFunction
implements InternalFunction<Map<String, String>> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();

    public void execute(FunctionContext<Map<String, String>> context) {
        String memberId = "";
        try {
            InternalCache cache = (InternalCache)context.getCache();
            DistributionConfig config = cache.getInternalDistributedSystem().getConfig();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            Map runtimeAttributes = (Map)context.getArguments();
            Set entries = runtimeAttributes.entrySet();
            block17: for (Map.Entry entry : entries) {
                String attributeName = (String)entry.getKey();
                String attributeValue = (String)entry.getValue();
                switch (attributeName) {
                    case "copy-on-read": {
                        cache.setCopyOnRead(Boolean.parseBoolean(attributeValue));
                        continue block17;
                    }
                    case "lock-lease": {
                        cache.setLockLease(Integer.parseInt(attributeValue));
                        continue block17;
                    }
                    case "lock-timeout": {
                        int lockTimeout = Integer.parseInt(attributeValue);
                        cache.setLockTimeout(lockTimeout);
                        continue block17;
                    }
                    case "search-timeout": {
                        cache.setSearchTimeout(Integer.parseInt(attributeValue));
                        continue block17;
                    }
                    case "message-sync-interval": {
                        cache.setMessageSyncInterval(Integer.parseInt(attributeValue));
                        continue block17;
                    }
                }
                config.setAttribute(attributeName, attributeValue, ConfigSource.runtime());
            }
            CliFunctionResult cliFuncResult = new CliFunctionResult(memberId, true, null);
            context.getResultSender().lastResult((Object)cliFuncResult);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult((Object)result);
        }
        catch (Exception e) {
            logger.error("Exception happened on : " + memberId, (Throwable)e);
            CliFunctionResult cliFuncResult = new CliFunctionResult(memberId, (Object)e, ExceptionUtils.getStackTrace((Throwable)e));
            context.getResultSender().lastResult((Object)cliFuncResult);
        }
    }

    public String getId() {
        return AlterRuntimeConfigFunction.class.getName();
    }
}

